/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.api;

import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.model.AddCollaboratorResponse;
import com.groupdocs.sdk.model.AddReplyResponse;
import com.groupdocs.sdk.model.AnnotationInfo;
import com.groupdocs.sdk.model.AnnotationReplyInfo;
import com.groupdocs.sdk.model.AnnotationSizeInfo;
import com.groupdocs.sdk.model.CreateAnnotationResponse;
import com.groupdocs.sdk.model.DeleteAnnotationResponse;
import com.groupdocs.sdk.model.DeleteDocumentAnnotationsResponse;
import com.groupdocs.sdk.model.DeleteReplyResponse;
import com.groupdocs.sdk.model.EditReplyResponse;
import com.groupdocs.sdk.model.GetCollaboratorsResponse;
import com.groupdocs.sdk.model.GetReviewerContactsResponse;
import com.groupdocs.sdk.model.GetSharedLinkAccessRightsResponse;
import com.groupdocs.sdk.model.ListAnnotationsResponse;
import com.groupdocs.sdk.model.ListRepliesResponse;
import com.groupdocs.sdk.model.MarkerPosition;
import com.groupdocs.sdk.model.MoveAnnotationResponse;
import com.groupdocs.sdk.model.Point;
import com.groupdocs.sdk.model.ResizeAnnotationResponse;
import com.groupdocs.sdk.model.ReviewerContactInfo;
import com.groupdocs.sdk.model.ReviewerInfo;
import com.groupdocs.sdk.model.SaveAnnotationTextResponse;
import com.groupdocs.sdk.model.SetAnnotationAccessResponse;
import com.groupdocs.sdk.model.SetCollaboratorsResponse;
import com.groupdocs.sdk.model.SetReviewerRightsResponse;
import com.groupdocs.sdk.model.SetSessionCallbackUrlResponse;
import com.groupdocs.sdk.model.SetSharedLinkAccessRightsResponse;
import com.groupdocs.sdk.model.TextFieldInfo;
import java.util.HashMap;
import java.util.List;

public class AntApi {
    String basePath = "https://api.groupdocs.com/v2.0";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public CreateAnnotationResponse CreateAnnotation(String userId, String fileId, AnnotationInfo body) throws ApiException {
        if (userId == null || fileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/annotations".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (CreateAnnotationResponse)ApiInvoker.deserialize(response, "", CreateAnnotationResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ListAnnotationsResponse ListAnnotations(String userId, String fileId) throws ApiException {
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/annotations".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (ListAnnotationsResponse)ApiInvoker.deserialize(response, "", ListAnnotationsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteAnnotationResponse DeleteAnnotation(String userId, String annotationId) throws ApiException {
        if (userId == null || annotationId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteAnnotationResponse)ApiInvoker.deserialize(response, "", DeleteAnnotationResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteDocumentAnnotationsResponse DeleteDocumentAnnotations(String userId, String fileId) throws ApiException {
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/annotations".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteDocumentAnnotationsResponse)ApiInvoker.deserialize(response, "", DeleteDocumentAnnotationsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddReplyResponse CreateAnnotationReply(String userId, String annotationId, AnnotationReplyInfo body) throws ApiException {
        if (userId == null || annotationId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}/replies".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddReplyResponse)ApiInvoker.deserialize(response, "", AddReplyResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public EditReplyResponse EditAnnotationReply(String userId, String replyGuid, String body) throws ApiException {
        if (userId == null || replyGuid == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/replies/{replyGuid}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{replyGuid}", String.valueOf(replyGuid));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (EditReplyResponse)ApiInvoker.deserialize(response, "", EditReplyResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteReplyResponse DeleteAnnotationReply(String userId, String replyGuid) throws ApiException {
        if (userId == null || replyGuid == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/replies/{replyGuid}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{replyGuid}", String.valueOf(replyGuid));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteReplyResponse)ApiInvoker.deserialize(response, "", DeleteReplyResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ListRepliesResponse ListAnnotationReplies(String userId, String annotationId, Long after) throws ApiException {
        if (userId == null || annotationId == null || after == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}/replies?after={after}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(after))) {
            queryParams.put("after", String.valueOf(after));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (ListRepliesResponse)ApiInvoker.deserialize(response, "", ListRepliesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SetCollaboratorsResponse SetAnnotationCollaborators(String userId, String fileId, String version, List<String> body) throws ApiException {
        if (userId == null || fileId == null || version == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/version/{version}/collaborators".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{version}", String.valueOf(version));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SetCollaboratorsResponse)ApiInvoker.deserialize(response, "", SetCollaboratorsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetCollaboratorsResponse GetAnnotationCollaborators(String userId, String fileId) throws ApiException {
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/collaborators".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetCollaboratorsResponse)ApiInvoker.deserialize(response, "", GetCollaboratorsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddCollaboratorResponse AddAnnotationCollaborator(String userId, String fileId, ReviewerInfo body) throws ApiException {
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/collaborators".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddCollaboratorResponse)ApiInvoker.deserialize(response, "", AddCollaboratorResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddCollaboratorResponse DeleteDocumentReviewer(String userId, String fileId, String reviewerId) throws ApiException {
        if (userId == null || fileId == null || reviewerId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/collaborators/{reviewerId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{reviewerId}", String.valueOf(reviewerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (AddCollaboratorResponse)ApiInvoker.deserialize(response, "", AddCollaboratorResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetReviewerContactsResponse GetReviewerContacts(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/contacts".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetReviewerContactsResponse)ApiInvoker.deserialize(response, "", GetReviewerContactsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetReviewerContactsResponse SetReviewerContacts(String userId, List<ReviewerContactInfo> body) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/reviewerContacts".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (GetReviewerContactsResponse)ApiInvoker.deserialize(response, "", GetReviewerContactsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public MoveAnnotationResponse MoveAnnotation(String userId, String annotationId, Point body) throws ApiException {
        if (userId == null || annotationId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}/position".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (MoveAnnotationResponse)ApiInvoker.deserialize(response, "", MoveAnnotationResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ResizeAnnotationResponse ResizeAnnotation(String userId, String annotationId, AnnotationSizeInfo body) throws ApiException {
        if (userId == null || annotationId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}/size".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (ResizeAnnotationResponse)ApiInvoker.deserialize(response, "", ResizeAnnotationResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SetAnnotationAccessResponse SetAnnotationAccess(String userId, String annotationId, Integer body) throws ApiException {
        if (userId == null || annotationId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}/annotationAccess".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SetAnnotationAccessResponse)ApiInvoker.deserialize(response, "", SetAnnotationAccessResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public MoveAnnotationResponse MoveAnnotationMarker(String userId, String annotationId, MarkerPosition body) throws ApiException {
        if (userId == null || annotationId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}/markerPosition".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (MoveAnnotationResponse)ApiInvoker.deserialize(response, "", MoveAnnotationResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SetReviewerRightsResponse SetReviewerRights(String userId, String fileId, List<ReviewerInfo> body) throws ApiException {
        if (userId == null || fileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/reviewerRights".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SetReviewerRightsResponse)ApiInvoker.deserialize(response, "", SetReviewerRightsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetSharedLinkAccessRightsResponse GetSharedLinkAccessRights(String userId, String fileId) throws ApiException {
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/sharedLinkAccessRights".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetSharedLinkAccessRightsResponse)ApiInvoker.deserialize(response, "", GetSharedLinkAccessRightsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SetSharedLinkAccessRightsResponse SetSharedLinkAccessRights(String userId, String fileId, String body) throws ApiException {
        if (userId == null || fileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/sharedLinkAccessRights".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SetSharedLinkAccessRightsResponse)ApiInvoker.deserialize(response, "", SetSharedLinkAccessRightsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SetSessionCallbackUrlResponse SetSessionCallbackUrl(String userId, String fileId, String body) throws ApiException {
        if (userId == null || fileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/files/{fileId}/sessionCallbackUrl".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SetSessionCallbackUrlResponse)ApiInvoker.deserialize(response, "", SetSessionCallbackUrlResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SaveAnnotationTextResponse SaveTextField(String userId, String annotationId, TextFieldInfo body) throws ApiException {
        if (userId == null || annotationId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}/textFieldInfo".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SaveAnnotationTextResponse)ApiInvoker.deserialize(response, "", SaveAnnotationTextResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SaveAnnotationTextResponse SetTextFieldColor(String userId, String annotationId, Integer body) throws ApiException {
        if (userId == null || annotationId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/ant/{userId}/annotations/{annotationId}/textFieldColor".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{annotationId}", String.valueOf(annotationId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SaveAnnotationTextResponse)ApiInvoker.deserialize(response, "", SaveAnnotationTextResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

