/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.api;

import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.model.AccountRemovalResponse;
import com.groupdocs.sdk.model.AddStorageProviderResponse;
import com.groupdocs.sdk.model.ChangePasswordResponse;
import com.groupdocs.sdk.model.CreateUserResponse;
import com.groupdocs.sdk.model.DeleteAccountResponse;
import com.groupdocs.sdk.model.DeleteAccountUserResponse;
import com.groupdocs.sdk.model.GetAccountResponse;
import com.groupdocs.sdk.model.GetAccountUsersResponse;
import com.groupdocs.sdk.model.GetRolesResponse;
import com.groupdocs.sdk.model.GetStorageProvidersResponse;
import com.groupdocs.sdk.model.GetUserEmbedKeyResponse;
import com.groupdocs.sdk.model.ResetPasswordResponse;
import com.groupdocs.sdk.model.RevokeResponse;
import com.groupdocs.sdk.model.RoleInfo;
import com.groupdocs.sdk.model.SetUserRolesResponse;
import com.groupdocs.sdk.model.StorageProviderInfo;
import com.groupdocs.sdk.model.UpdateAccountUserResponse;
import com.groupdocs.sdk.model.UpdateStorageProviderResponse;
import com.groupdocs.sdk.model.UpdateUserResponse;
import com.groupdocs.sdk.model.UserInfo;
import com.groupdocs.sdk.model.UserInfoResponse;
import com.groupdocs.sdk.model.UserPasswordInfo;
import java.util.HashMap;
import java.util.List;

public class MgmtApi {
    String basePath = "https://api.groupdocs.com/v2.0";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public UserInfoResponse GetUserProfile(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/profile".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (UserInfoResponse)ApiInvoker.deserialize(response, "", UserInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateUserResponse UpdateUserProfile(String userId, UserInfo body) throws ApiException {
        if (userId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/profile".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateUserResponse)ApiInvoker.deserialize(response, "", UpdateUserResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public RevokeResponse Revoke(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/revoke".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (RevokeResponse)ApiInvoker.deserialize(response, "", RevokeResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ChangePasswordResponse ChangeUserPassword(String userId, UserPasswordInfo body) throws ApiException {
        if (userId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/profile/password".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (ChangePasswordResponse)ApiInvoker.deserialize(response, "", ChangePasswordResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UserInfoResponse GetUserProfileByResetToken(String callerId, String token) throws ApiException {
        if (callerId == null || token == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/reset-tokens?token={token}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(token))) {
            queryParams.put("token", String.valueOf(token));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (UserInfoResponse)ApiInvoker.deserialize(response, "", UserInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UserInfoResponse GetUserProfileByVerifToken(String callerId, String token) throws ApiException {
        if (callerId == null || token == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/verif-tokens?token={token}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(token))) {
            queryParams.put("token", String.valueOf(token));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (UserInfoResponse)ApiInvoker.deserialize(response, "", UserInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UserInfoResponse GetUserProfileByClaimedToken(String callerId, String token) throws ApiException {
        if (callerId == null || token == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/claimed-tokens?token={token}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(token))) {
            queryParams.put("token", String.valueOf(token));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (UserInfoResponse)ApiInvoker.deserialize(response, "", UserInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UserInfoResponse GetAlienUserProfile(String callerId, String userId) throws ApiException {
        if (callerId == null || userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/users/{userId}/profile".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (UserInfoResponse)ApiInvoker.deserialize(response, "", UserInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateUserResponse UpdateAlienUserProfile(String callerId, String userId, UserInfo body) throws ApiException {
        if (callerId == null || userId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/users/{userId}/profile".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateUserResponse)ApiInvoker.deserialize(response, "", UpdateUserResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public CreateUserResponse CreateUser(String callerId, UserInfo body) throws ApiException {
        if (callerId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/users".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (CreateUserResponse)ApiInvoker.deserialize(response, "", CreateUserResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UserInfoResponse CreateUserLogin(String callerId, String userId, String password) throws ApiException {
        if (callerId == null || userId == null || password == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/users/{userId}/logins".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(password))) {
            queryParams.put("password", String.valueOf(password));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (UserInfoResponse)ApiInvoker.deserialize(response, "", UserInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ChangePasswordResponse ChangeAlienUserPassword(String callerId, String userId, UserPasswordInfo body) throws ApiException {
        if (callerId == null || userId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/users/{userId}/password".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (ChangePasswordResponse)ApiInvoker.deserialize(response, "", ChangePasswordResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ResetPasswordResponse ResetUserPassword(String callerId, String userId) throws ApiException {
        if (callerId == null || userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/users/{userId}/password".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (ResetPasswordResponse)ApiInvoker.deserialize(response, "", ResetPasswordResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetStorageProvidersResponse GetStorageProviders(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/storages".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetStorageProvidersResponse)ApiInvoker.deserialize(response, "", GetStorageProvidersResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddStorageProviderResponse AddStorageProvider(String userId, String provider, StorageProviderInfo body) throws ApiException {
        if (userId == null || provider == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/storages/{provider}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{provider}", String.valueOf(provider));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddStorageProviderResponse)ApiInvoker.deserialize(response, "", AddStorageProviderResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateStorageProviderResponse UpdateStorageProvider(String userId, String provider, StorageProviderInfo body) throws ApiException {
        if (userId == null || provider == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/storages/{provider}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{provider}", String.valueOf(provider));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateStorageProviderResponse)ApiInvoker.deserialize(response, "", UpdateStorageProviderResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetRolesResponse GetRoles(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/roles".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetRolesResponse)ApiInvoker.deserialize(response, "", GetRolesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetRolesResponse GetUserRoles(String callerId, String userId) throws ApiException {
        if (callerId == null || userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/users/{userId}/roles".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetRolesResponse)ApiInvoker.deserialize(response, "", GetRolesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SetUserRolesResponse SetUserRoles(String callerId, String userId, List<RoleInfo> body) throws ApiException {
        if (callerId == null || userId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/users/{userId}/roles".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SetUserRolesResponse)ApiInvoker.deserialize(response, "", SetUserRolesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetAccountResponse GetAccount(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/account".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetAccountResponse)ApiInvoker.deserialize(response, "", GetAccountResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteAccountResponse DeleteAccount(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/account".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteAccountResponse)ApiInvoker.deserialize(response, "", DeleteAccountResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetAccountUsersResponse GetAccountUsers(String adminId) throws ApiException {
        if (adminId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{adminId}/account/users".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{adminId}", String.valueOf(adminId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetAccountUsersResponse)ApiInvoker.deserialize(response, "", GetAccountUsersResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateAccountUserResponse UpdateAccountUser(String adminId, String userName, UserInfo body) throws ApiException {
        if (adminId == null || userName == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{adminId}/account/users/{userName}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{adminId}", String.valueOf(adminId)).replace("{userName}", String.valueOf(userName));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateAccountUserResponse)ApiInvoker.deserialize(response, "", UpdateAccountUserResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteAccountUserResponse DeleteAccountUser(String adminId, String userName) throws ApiException {
        if (adminId == null || userName == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{adminId}/account/users/{userName}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{adminId}", String.valueOf(adminId)).replace("{userName}", String.valueOf(userName));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteAccountUserResponse)ApiInvoker.deserialize(response, "", DeleteAccountUserResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AccountRemovalResponse RemoveAccount(String userId, String email, String nonce) throws ApiException {
        if (userId == null || email == null || nonce == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/account/users/removeaccount/{email}?nonce={nonce}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{email}", String.valueOf(email)).replace("{nonce}", String.valueOf(nonce));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (AccountRemovalResponse)ApiInvoker.deserialize(response, "", AccountRemovalResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetUserEmbedKeyResponse GetUserEmbedKey(String userId, String area) throws ApiException {
        if (userId == null || area == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/embedkey/{area}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{area}", String.valueOf(area));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetUserEmbedKeyResponse)ApiInvoker.deserialize(response, "", GetUserEmbedKeyResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetUserEmbedKeyResponse GetUserEmbedKeyFromGuid(String callerId, String guid) throws ApiException {
        if (callerId == null || guid == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{callerId}/embedkey/guid/{guid}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{guid}", String.valueOf(guid));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetUserEmbedKeyResponse)ApiInvoker.deserialize(response, "", GetUserEmbedKeyResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetUserEmbedKeyResponse GenerateKeyForUser(String userId, String area) throws ApiException {
        if (userId == null || area == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/mgmt/{userId}/embedkey/new/{area}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{area}", String.valueOf(area));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetUserEmbedKeyResponse)ApiInvoker.deserialize(response, "", GetUserEmbedKeyResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

