package com.labstack;

import okhttp3.*;

import java.io.IOException;

public class Client {
    private OkHttpClient okHttp;
    private String appId;
    private String appName;

    public static final String API_URL = "https://api.labstack.com";
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");

    public Client(String apiKey) {
         okHttp = new OkHttpClient.Builder()
                .addInterceptor(new APIInterceptor(apiKey))
                .build();
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Log Log() {
        Log log = new Log();
        log.okHttp = okHttp;
        log.setAppId(appId);
        log.setAppName(appName);
        log.setLevel(Log.Level.INFO);
        log.setBatchSize(60);
        log.setDispatchInterval(60);
        return log;
    }
}

class APIInterceptor implements Interceptor {
    private String apiKey;

    public APIInterceptor(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
        Request compressedRequest = chain.request().newBuilder()
                .header("Authorization", "Bearer " + apiKey)
                .build();
        return chain.proceed(compressedRequest);
    }
}

