/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Client;
import com.labstack.EmailException;
import com.labstack.EmailFile;
import com.labstack.EmailMessage;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Rfc3339DateJsonAdapter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Email {
    protected OkHttpClient okHttp;
    private Moshi moshi = new Moshi.Builder().add(Date.class, new Rfc3339DateJsonAdapter().nullSafe()).build();
    private JsonAdapter<EmailMessage> messageJsonAdapter = this.moshi.adapter(EmailMessage.class);
    private JsonAdapter<EmailException> exceptionJsonAdapter = this.moshi.adapter(EmailException.class);

    private void addFiles(List<String> files, List<EmailFile> emailFiles) throws IOException {
        for (String file : files) {
            Path path = Paths.get(file, new String[0]);
            String content = DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(path));
            EmailFile emailFile = new EmailFile(path.getFileName().toString(), content);
            emailFiles.add(emailFile);
        }
    }

    public EmailMessage send(EmailMessage message) throws EmailException {
        try {
            message.addFiles();
            String json = this.messageJsonAdapter.toJson((Object)message);
            Request request = new Request.Builder().url("https://api.labstack.com/email").post(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                return (EmailMessage)this.messageJsonAdapter.fromJson(response.body().source());
            }
            throw (EmailException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new EmailException(0, e.getMessage());
        }
    }
}

