/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Client;
import com.labstack.Fields;
import com.labstack.Level;
import com.labstack.LogException;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class Log {
    protected OkHttpClient okHttp;
    private JsonAdapter<List<Map<String, Object>>> entriesJsonAdapter = Client.moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{Map.class}));
    private JsonAdapter<LogException> exceptionJsonAdapter = Client.moshi.adapter(LogException.class);
    private Timer timer;
    private List<Map<String, Object>> entries = Collections.synchronizedList(new ArrayList());
    private String appId;
    private String appName;
    private Level level;
    private int batchSize;
    private int dispatchInterval;

    protected Log() {
    }

    private void dispatch() throws LogException {
        if (this.entries.size() == 0) {
            return;
        }
        String json = this.entriesJsonAdapter.toJson(this.entries);
        Request request = new Request.Builder().url("https://api.labstack.com/log").post(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw (LogException)this.exceptionJsonAdapter.fromJson(response.body().source());
            }
        }
        catch (IOException e) {
            throw new LogException(0, e.getMessage());
        }
        finally {
            this.entries.clear();
        }
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setDispatchInterval(int dispatchInterval) {
        this.dispatchInterval = dispatchInterval;
    }

    public void debug(Fields fields) {
        this.log(Level.DEBUG, fields);
    }

    public void info(Fields fields) {
        this.log(Level.INFO, fields);
    }

    public void warn(String format, Fields fields) {
        this.log(Level.WARN, fields);
    }

    public void error(String format, Fields fields) {
        this.log(Level.ERROR, fields);
    }

    public void fatal(String format, Fields fields) {
        this.log(Level.FATAL, fields);
    }

    public void log(Level level, Fields fields) {
        if (level.compareTo(this.level) < 0) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        Log.this.dispatch();
                    }
                    catch (LogException e) {
                        System.out.printf("log error: code=%d, message=%s", e.getCode(), e.getMessage());
                    }
                }
            }, 0L, TimeUnit.SECONDS.toMillis(this.dispatchInterval));
        }
        fields.add("time", Client.dateFormat.format(new Date())).add("app_id", this.appId).add("app_name", this.appName).add("level", (Object)level);
        this.entries.add(fields.data);
        if (this.entries.size() >= this.batchSize) {
            try {
                this.dispatch();
            }
            catch (LogException e) {
                System.out.printf("log error: code=%d, message=%s", e.getCode(), e.getMessage());
            }
        }
    }
}

