/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Client;
import com.labstack.Document;
import com.labstack.SearchParameters;
import com.labstack.StoreException;
import com.labstack.StoreSearchResponse;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class Store {
    protected OkHttpClient okHttp;
    private JsonAdapter<Map<String, Object>> documentJsonAdapter = Client.moshi.adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Object.class}));
    private JsonAdapter<StoreSearchResponse> searchResponseJsonAdapter = Client.moshi.adapter(StoreSearchResponse.class);
    private JsonAdapter<StoreException> exceptionJsonAdapter = Client.moshi.adapter(StoreException.class);

    protected Store() {
    }

    public Document insert(String collection, Document document) throws StoreException {
        String json = this.documentJsonAdapter.toJson(document.data);
        Request request = new Request.Builder().url("https://api.labstack.com/store/" + collection).post(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                document.data = (Map)this.documentJsonAdapter.fromJson(response.body().source());
                return document;
            }
            throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public Document get(String collection, String id) throws StoreException {
        Request request = new Request.Builder().url(String.format("%s/store/%s/%s", "https://api.labstack.com", collection, id)).get().build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                Document document = new Document();
                document.data = (Map)this.documentJsonAdapter.fromJson(response.body().source());
                return document;
            }
            throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public StoreSearchResponse search(String collection, SearchParameters parameters) throws StoreException {
        String json = Client.paramsJsonAdapter.toJson((Object)parameters);
        Request request = new Request.Builder().url(String.format("%s/store/%s/search", "https://api.labstack.com", collection)).post(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                return (StoreSearchResponse)this.searchResponseJsonAdapter.fromJson(response.body().source());
            }
            throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public void update(String collection, String id, Document document) throws StoreException {
        String json = this.documentJsonAdapter.toJson(document.data);
        Request request = new Request.Builder().url(String.format("%s/store/%s/%s", "https://api.labstack.com", collection, id)).patch(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
            }
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public void delete(String collection, String id) throws Exception {
        Request request = new Request.Builder().url(String.format("%s/store/%s/%s", "https://api.labstack.com", collection, id)).delete().build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
            }
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }
}

