/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSResourceResolver;

public class DOMHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<Document>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private static final Logger logger = LoggerFactory.getLogger(DOMHandle.class);
    private LSResourceResolver resolver;
    private Document content;
    private DocumentBuilderFactory factory;
    private XPath xpathProcessor;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Document.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Document.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                DOMHandle handle = this.isHandled(type) ? new DOMHandle() : null;
                return handle;
            }
        };
    }

    public DOMHandle() {
        super.setFormat(Format.XML);
        this.setResendable(true);
    }

    public DOMHandle(Document content) {
        this();
        this.set(content);
    }

    public LSResourceResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(LSResourceResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public Document get() {
        return this.content;
    }

    @Override
    public void set(Document content) {
        this.content = content;
    }

    public DOMHandle with(Document content) {
        this.set(content);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("DOMHandle supports the XML format only");
        }
    }

    public DOMHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public DocumentBuilderFactory getFactory() throws ParserConfigurationException {
        if (this.factory == null) {
            this.factory = this.makeDocumentBuilderFactory();
        }
        return this.factory;
    }

    public void setFactory(DocumentBuilderFactory factory) {
        this.factory = factory;
    }

    protected DocumentBuilderFactory makeDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        return factory;
    }

    public XPath getXPathProcessor() {
        if (this.xpathProcessor == null) {
            this.xpathProcessor = this.makeXPathProcessorFactory().newXPath();
        }
        return this.xpathProcessor;
    }

    public void setXPathProcessor(XPath xpathProcessor) {
        this.xpathProcessor = xpathProcessor;
    }

    protected XPathFactory makeXPathProcessorFactory() {
        return XPathFactory.newInstance();
    }

    public <T> T evaluateXPath(String xpathExpression, Class<T> as) throws XPathExpressionException {
        return this.evaluateXPath(xpathExpression, (Node)this.get(), as);
    }

    public <T> T evaluateXPath(String xpathExpression, Node context, Class<T> as) throws XPathExpressionException {
        this.checkContext(context);
        return this.castAs(this.getXPathProcessor().evaluate(xpathExpression, context, this.returnXPathConstant(as)), as);
    }

    public XPathExpression compileXPath(String xpathExpression) throws XPathExpressionException {
        return this.getXPathProcessor().compile(xpathExpression);
    }

    public <T> T evaluateXPath(XPathExpression xpathExpression, Class<T> as) throws XPathExpressionException {
        return this.evaluateXPath(xpathExpression, (Node)this.get(), as);
    }

    public <T> T evaluateXPath(XPathExpression xpathExpression, Node context, Class<T> as) throws XPathExpressionException {
        this.checkContext(context);
        return this.castAs(xpathExpression.evaluate(context, this.returnXPathConstant(as)), as);
    }

    protected void checkContext(Node context) {
        if (context == null) {
            throw new IllegalStateException("Cannot process empty context");
        }
    }

    protected QName returnXPathConstant(Class<?> as) {
        if (as == null) {
            throw new IllegalArgumentException("cannot execute XPath as null");
        }
        if (Node.class.isAssignableFrom(as)) {
            return XPathConstants.NODE;
        }
        if (NodeList.class.isAssignableFrom(as)) {
            return XPathConstants.NODESET;
        }
        if (String.class.isAssignableFrom(as)) {
            return XPathConstants.STRING;
        }
        if (Number.class.isAssignableFrom(as)) {
            return XPathConstants.NUMBER;
        }
        if (Boolean.class.isAssignableFrom(as)) {
            return XPathConstants.BOOLEAN;
        }
        throw new IllegalArgumentException("cannot execute XPath as " + as.getName());
    }

    protected <T> T castAs(Object result, Class<?> as) {
        if (result == null) {
            return null;
        }
        if (!as.isAssignableFrom(result.getClass())) {
            throw new IllegalArgumentException("cannot cast " + result.getClass().getName() + " to " + as.getName());
        }
        Object typedResult = result;
        return (T)typedResult;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            this.content = null;
            return;
        }
        try {
            DocumentBuilderFactory factory;
            if (logger.isInfoEnabled()) {
                logger.info("Parsing DOM document from input stream");
            }
            if ((factory = this.getFactory()) == null) {
                throw new MarkLogicInternalException("Failed to make DOM document builder factory");
            }
            DOMImplementationLS domImpl = (DOMImplementationLS)((Object)factory.newDocumentBuilder().getDOMImplementation());
            LSParser parser = domImpl.createLSParser((short)1, null);
            if (this.resolver != null) {
                parser.getDomConfig().setParameter("resource-resolver", this.resolver);
            }
            LSInput domInput = domImpl.createLSInput();
            domInput.setEncoding("UTF-8");
            domInput.setByteStream(content);
            this.content = parser.parse(domInput);
        }
        catch (ParserConfigurationException e) {
            logger.error("Failed to parse DOM document from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No document to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            DocumentBuilderFactory factory;
            if (logger.isInfoEnabled()) {
                logger.info("Serializing DOM document to output stream");
            }
            if ((factory = this.getFactory()) == null) {
                throw new MarkLogicInternalException("Failed to make DOM document builder factory");
            }
            DOMImplementationLS domImpl = (DOMImplementationLS)((Object)factory.newDocumentBuilder().getDOMImplementation());
            LSOutput domOutput = domImpl.createLSOutput();
            domOutput.setEncoding("UTF-8");
            domOutput.setByteStream(out);
            domImpl.createLSSerializer().write(this.content, domOutput);
        }
        catch (DOMException e) {
            logger.error("Failed to serialize DOM document to output stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (LSException e) {
            logger.error("Failed to serialize DOM document to output stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Failed to serialize DOM document to output stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }
}

