/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.ResourceNotResendableException;
import com.marklogic.client.document.ContentDescriptor;
import com.marklogic.client.document.DocumentDescriptor;
import com.marklogic.client.document.DocumentManager;
import com.marklogic.client.document.DocumentPage;
import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.document.DocumentUriTemplate;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.eval.EvalResult;
import com.marklogic.client.eval.EvalResultIterator;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.impl.BasicPage;
import com.marklogic.client.impl.CombinedQueryDefinition;
import com.marklogic.client.impl.DigestChallengeFilter;
import com.marklogic.client.impl.DocumentDescriptorImpl;
import com.marklogic.client.impl.FailedRequest;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.ServerEvaluationCallImpl;
import com.marklogic.client.impl.StreamingOutputImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.JacksonParserHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.client.io.marker.DocumentPatchHandle;
import com.marklogic.client.io.marker.SearchReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.query.DeleteQueryDefinition;
import com.marklogic.client.query.ElementLocator;
import com.marklogic.client.query.KeyLocator;
import com.marklogic.client.query.KeyValueQueryDefinition;
import com.marklogic.client.query.QueryDefinition;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.RawQueryByExampleDefinition;
import com.marklogic.client.query.RawQueryDefinition;
import com.marklogic.client.query.StringQueryDefinition;
import com.marklogic.client.query.StructuredQueryDefinition;
import com.marklogic.client.query.SuggestDefinition;
import com.marklogic.client.query.ValueLocator;
import com.marklogic.client.query.ValueQueryDefinition;
import com.marklogic.client.query.ValuesDefinition;
import com.marklogic.client.query.ValuesListDefinition;
import com.marklogic.client.util.EditableNamespaceContext;
import com.marklogic.client.util.RequestLogger;
import com.marklogic.client.util.RequestParameters;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.HTTPDigestAuthFilter;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.Boundary;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.MultiPartMediaTypes;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AbstractVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyServices
implements RESTServices {
    private static final Logger logger = LoggerFactory.getLogger(JerseyServices.class);
    static final String ERROR_NS = "http://marklogic.com/xdmp/error";
    private static final String DOCUMENT_URI_PREFIX = "/documents?uri=";
    private static final int DELAY_FLOOR = 125;
    private static final int DELAY_CEILING = 2000;
    private static final int DELAY_MULTIPLIER = 20;
    private static final int DEFAULT_MAX_DELAY = 120000;
    private static final int DEFAULT_MIN_RETRY = 8;
    private static final String MAX_DELAY_PROP = "com.marklogic.client.maximumRetrySeconds";
    private static final String MIN_RETRY_PROP = "com.marklogic.client.minimumRetries";
    private DatabaseClient databaseClient;
    private String database = null;
    private ApacheHttpClient4 client;
    private WebResource connection;
    private boolean released = false;
    private Random randRetry = new Random();
    private int maxDelay = 120000;
    private int minRetry = 8;
    private boolean checkFirstRequest = false;
    private final ThreadLocal<ThreadState> threadState = new ThreadLocal<ThreadState>(){

        @Override
        protected ThreadState initialValue() {
            return new ThreadState(JerseyServices.this.checkFirstRequest);
        }
    };

    private FailedRequest extractErrorFields(ClientResponse response) {
        if (response == null) {
            return null;
        }
        InputStream is = response.getEntityInputStream();
        try {
            FailedRequest handler;
            FailedRequest failedRequest = handler = FailedRequest.getFailedRequest(response.getStatus(), response.getType(), is);
            return failedRequest;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            response.close();
        }
    }

    @Override
    public void connect(String host, int port, String database, String user, String password, DatabaseClientFactory.Authentication authenType, SSLContext context, DatabaseClientFactory.SSLHostnameVerifier verifier) {
        Object x509Verifier = null;
        if (verifier == null) {
            if (context != null) {
                x509Verifier = SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
            }
        } else if (verifier == DatabaseClientFactory.SSLHostnameVerifier.ANY) {
            x509Verifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        } else if (verifier == DatabaseClientFactory.SSLHostnameVerifier.COMMON) {
            x509Verifier = SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        } else if (verifier == DatabaseClientFactory.SSLHostnameVerifier.STRICT) {
            x509Verifier = SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
        } else if (context != null) {
            x509Verifier = new HostnameVerifierAdapter(verifier);
        } else {
            throw new IllegalArgumentException("Null SSLContent but non-null SSLHostnameVerifier for client");
        }
        this.connect(host, port, database, user, password, authenType, context, (X509HostnameVerifier)x509Verifier);
    }

    private void connect(String host, int port, String database, String user, String password, DatabaseClientFactory.Authentication authenType, SSLContext context, X509HostnameVerifier verifier) {
        PlainSocketFactory socketFactory;
        int min;
        String minRetryStr;
        int max;
        String maxDelayStr;
        if (logger.isDebugEnabled()) {
            logger.debug("Connecting to {} at {} as {}", new Object[]{host, port, user});
        }
        if (host == null) {
            throw new IllegalArgumentException("No host provided");
        }
        if (authenType == null && context != null) {
            authenType = DatabaseClientFactory.Authentication.BASIC;
        }
        if (authenType != null) {
            if (user == null) {
                throw new IllegalArgumentException("No user provided");
            }
            if (password == null) {
                throw new IllegalArgumentException("No password provided");
            }
        }
        if (this.connection != null) {
            this.connection = null;
        }
        if (this.client != null) {
            this.client.destroy();
            this.client = null;
        }
        this.database = database;
        String baseUri = (context == null ? "http" : "https") + "://" + host + ":" + port + "/v1/";
        Properties props = System.getProperties();
        if (props.containsKey(MAX_DELAY_PROP) && (maxDelayStr = props.getProperty(MAX_DELAY_PROP)) != null && maxDelayStr.length() > 0 && (max = Integer.parseInt(maxDelayStr)) > 0) {
            this.maxDelay = max * 1000;
        }
        if (props.containsKey(MIN_RETRY_PROP) && (minRetryStr = props.getProperty(MIN_RETRY_PROP)) != null && minRetryStr.length() > 0 && (min = Integer.parseInt(minRetryStr)) > 0) {
            this.minRetry = min;
        }
        if (!props.containsKey("org.apache.commons.logging.Log")) {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        }
        if (!props.containsKey("org.apache.commons.logging.simplelog.log.org.apache.http")) {
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "warn");
        }
        if (!props.containsKey("org.apache.commons.logging.simplelog.log.org.apache.http.wire")) {
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.wire", "warn");
        }
        Scheme scheme = null;
        if (context == null) {
            socketFactory = PlainSocketFactory.getSocketFactory();
            scheme = new Scheme("http", port, (SchemeSocketFactory)socketFactory);
        } else {
            socketFactory = new SSLSocketFactory(context, verifier);
            scheme = new Scheme("https", port, (SchemeSocketFactory)socketFactory);
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(scheme);
        int maxRouteConnections = 100;
        int maxTotalConnections = 2 * maxRouteConnections;
        ThreadSafeClientConnManager connMgr = new ThreadSafeClientConnManager(schemeRegistry);
        connMgr.setMaxTotal(maxTotalConnections);
        connMgr.setDefaultMaxPerRoute(maxRouteConnections);
        connMgr.setMaxForRoute(new HttpRoute(new HttpHost(baseUri)), maxRouteConnections);
        BasicHttpParams httpParams = new BasicHttpParams();
        if (authenType != null) {
            ArrayList<String> authpref = new ArrayList<String>();
            if (authenType == DatabaseClientFactory.Authentication.BASIC) {
                authpref.add("Basic");
            } else if (authenType == DatabaseClientFactory.Authentication.DIGEST) {
                authpref.add("Digest");
            } else {
                throw new MarkLogicInternalException("Internal error - unknown authentication type: " + authenType.name());
            }
            httpParams.setParameter("http.auth.proxy-scheme-pref", authpref);
        }
        httpParams.setBooleanParameter("http.protocol.handle-redirects", false);
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        DefaultApacheHttpClient4Config config = new DefaultApacheHttpClient4Config();
        Map configProps = config.getProperties();
        configProps.put("com.sun.jersey.impl.client.httpclient.preemptiveBasicAuthentication", false);
        configProps.put("com.sun.jersey.impl.client.httpclient.connectionManager", connMgr);
        configProps.put("com.sun.jersey.client.property.followRedirects", false);
        configProps.put("com.sun.jersey.impl.client.httpclient.httpParams", httpParams);
        configProps.put("com.sun.jersey.client.property.chunkedEncodingSize", 32768);
        this.client = ApacheHttpClient4.create((ClientConfig)config);
        if (authenType == null) {
            this.checkFirstRequest = false;
        } else if (authenType == DatabaseClientFactory.Authentication.BASIC) {
            this.checkFirstRequest = false;
            this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, password));
        } else if (authenType == DatabaseClientFactory.Authentication.DIGEST) {
            this.checkFirstRequest = true;
            this.client.addFilter((ClientFilter)new DigestChallengeFilter());
            this.client.addFilter((ClientFilter)new HTTPDigestAuthFilter(user, password));
        } else {
            throw new MarkLogicInternalException("Internal error - unknown authentication type: " + authenType.name());
        }
        this.connection = this.client.resource(baseUri);
    }

    @Override
    public DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    @Override
    public void setDatabaseClient(DatabaseClient client) {
        this.databaseClient = client;
    }

    private WebResource getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        if (this.released) {
            throw new IllegalStateException("You cannot use this connected object anymore--connection has already been released");
        }
        throw new MarkLogicInternalException("Cannot proceed--connection is null for unknown reason");
    }

    @Override
    public void release() {
        this.released = true;
        if (this.databaseClient != null) {
            this.databaseClient = null;
        }
        if (this.client == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Releasing connection");
        }
        this.connection = null;
        this.client.destroy();
        this.client = null;
    }

    private boolean isFirstRequest() {
        return this.threadState.get().isFirstRequest;
    }

    private void setFirstRequest(boolean value) {
        this.threadState.get().isFirstRequest = value;
    }

    private void checkFirstRequest() {
        if (this.checkFirstRequest) {
            this.setFirstRequest(true);
        }
    }

    private int makeFirstRequest(int retry) {
        ClientResponse response = this.getConnection().path("ping").head();
        int statusCode = response.getClientResponseStatus().getStatusCode();
        if (statusCode != ClientResponse.Status.SERVICE_UNAVAILABLE.getStatusCode()) {
            response.close();
            return 0;
        }
        MultivaluedMap responseHeaders = response.getHeaders();
        response.close();
        String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
        int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
        return Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
    }

    @Override
    public void deleteDocument(RequestLogger reqlog, DocumentDescriptor desc, String transactionId, Set<DocumentManager.Metadata> categories, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        FailedRequest failure;
        int retry;
        String uri = desc.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("Document delete for document identifier without uri");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting {} in transaction {}", (Object)uri, (Object)transactionId);
        }
        WebResource webResource = this.makeDocumentResource(this.makeDocumentParams(uri, categories, transactionId, extraParams));
        WebResource.Builder builder = this.addVersionHeader(desc, webResource.getRequestBuilder(), "If-Match");
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.delete(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.NOT_FOUND) {
            response.close();
            throw new ResourceNotFoundException("Could not delete non-existent document");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTNOVERSION")) {
                throw new FailedRequestException("Content version required to delete document", failure);
            }
            throw new ForbiddenUserException("User is not allowed to delete documents", failure);
        }
        if (status == ClientResponse.Status.PRECONDITION_FAILED) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTWRONGVERSION")) {
                throw new FailedRequestException("Content version must match to delete document", failure);
            }
            if (failure.getMessageCode().equals("RESTAPI-EMPTYBODY")) {
                throw new FailedRequestException("Empty request body sent to server", failure);
            }
            throw new FailedRequestException("Precondition Failed", failure);
        }
        if (status != ClientResponse.Status.NO_CONTENT) {
            throw new FailedRequestException("delete failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        response.close();
        this.logRequest(reqlog, "deleted %s document", uri);
    }

    @Override
    public boolean getDocument(RequestLogger reqlog, DocumentDescriptor desc, String transactionId, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, DocumentMetadataReadHandle metadataHandle, AbstractReadHandle contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        HandleImplementation metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata");
        HandleImplementation contentBase = HandleAccessor.checkHandle(contentHandle, "content");
        String metadataFormat = null;
        String metadataMimetype = null;
        if (metadataBase != null) {
            metadataFormat = metadataBase.getFormat().toString().toLowerCase();
            metadataMimetype = metadataBase.getMimetype();
        }
        String contentMimetype = null;
        if (contentBase != null) {
            contentMimetype = contentBase.getMimetype();
        }
        if (metadataBase != null && contentBase != null) {
            return this.getDocumentImpl(reqlog, desc, transactionId, categories, extraParams, metadataFormat, metadataHandle, contentHandle);
        }
        if (metadataBase != null) {
            return this.getDocumentImpl(reqlog, desc, transactionId, categories, extraParams, metadataMimetype, metadataHandle);
        }
        if (contentBase != null) {
            return this.getDocumentImpl(reqlog, desc, transactionId, null, extraParams, contentMimetype, contentHandle);
        }
        return false;
    }

    private boolean getDocumentImpl(RequestLogger reqlog, DocumentDescriptor desc, String transactionId, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, String mimetype, AbstractReadHandle handle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        Object entity;
        int retry;
        String uri = desc.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("Document read for document identifier without uri");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting {} in transaction {}", (Object)uri, (Object)transactionId);
        }
        WebResource.Builder builder = this.makeDocumentResource(this.makeDocumentParams(uri, categories, transactionId, extraParams)).accept(new String[]{mimetype});
        if (extraParams != null && extraParams.containsKey("range")) {
            builder = (WebResource.Builder)builder.header("range", extraParams.get("range").get(0));
        }
        builder = this.addVersionHeader(desc, builder, "If-None-Match");
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.get(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.NOT_FOUND) {
            throw new ResourceNotFoundException("Could not read non-existent document", this.extractErrorFields(response));
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to read documents", this.extractErrorFields(response));
        }
        if (status == ClientResponse.Status.NOT_MODIFIED) {
            response.close();
            return false;
        }
        if (status != ClientResponse.Status.OK && status != ClientResponse.Status.PARTIAL_CONTENT) {
            throw new FailedRequestException("read failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "read %s document from %s transaction with %s mime type and %s metadata categories", uri, transactionId != null ? transactionId : "no", mimetype != null ? mimetype : "no", this.stringJoin(categories, ", ", "no"));
        HandleImplementation handleBase = HandleAccessor.as(handle);
        MultivaluedMap responseHeaders = response.getHeaders();
        if (this.isExternalDescriptor(desc)) {
            this.updateVersion(desc, (MultivaluedMap<String, String>)responseHeaders);
            this.updateDescriptor(desc, (MultivaluedMap<String, String>)responseHeaders);
            this.copyDescriptor(desc, handleBase);
        } else {
            this.updateDescriptor(handleBase, (MultivaluedMap<String, String>)responseHeaders);
        }
        Class as = handleBase.receiveAs();
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || !InputStream.class.isAssignableFrom(as) && !Reader.class.isAssignableFrom(as)) {
            response.close();
        }
        handleBase.receiveContent(reqlog != null ? reqlog.copyContent(entity) : entity);
        return true;
    }

    @Override
    public DocumentPage getBulkDocuments(RequestLogger reqlog, String transactionId, Set<DocumentManager.Metadata> categories, Format format, RequestParameters extraParams, boolean withContent, String ... uris) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        boolean hasMetadata = categories != null && categories.size() > 0;
        JerseyResultIterator iterator = this.getBulkDocumentsImpl(reqlog, transactionId, categories, format, extraParams, withContent, uris);
        return new JerseyDocumentPage(iterator, withContent, hasMetadata);
    }

    @Override
    public DocumentPage getBulkDocuments(RequestLogger reqlog, QueryDefinition querydef, long start, long pageLength, String transactionId, SearchReadHandle searchHandle, QueryManager.QueryView view, Set<DocumentManager.Metadata> categories, Format format, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        boolean hasMetadata = categories != null && categories.size() > 0;
        boolean hasContent = true;
        JerseyResultIterator iterator = this.getBulkDocumentsImpl(reqlog, querydef, start, pageLength, transactionId, searchHandle, view, categories, format, extraParams);
        return new JerseyDocumentPage(iterator, hasContent, hasMetadata);
    }

    private JerseyResultIterator getBulkDocumentsImpl(RequestLogger reqlog, String transactionId, Set<DocumentManager.Metadata> categories, Format format, RequestParameters extraParams, boolean withContent, String ... uris) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        String path = "documents";
        RequestParameters params = new RequestParameters();
        if (extraParams != null) {
            params.putAll(extraParams);
        }
        if (transactionId != null) {
            params.add("txid", transactionId);
        }
        this.addCategoryParams(categories, params, withContent);
        if (format != null) {
            params.add("format", format.toString().toLowerCase());
        }
        for (String uri : uris) {
            params.add("uri", uri);
        }
        DefaultJerseyResultIterator iterator = this.getIteratedResourceImpl(DefaultJerseyResultIterator.class, reqlog, path, params, "multipart/mixed");
        if (iterator != null) {
            if (iterator.getStart() == -1L) {
                iterator.setStart(1L);
            }
            if (iterator.getSize() != -1L) {
                if (iterator.getPageSize() == -1L) {
                    iterator.setPageSize(iterator.getSize());
                }
                if (iterator.getTotalSize() == -1L) {
                    iterator.setTotalSize(iterator.getSize());
                }
            }
        }
        return iterator;
    }

    private JerseyResultIterator getBulkDocumentsImpl(RequestLogger reqlog, QueryDefinition querydef, long start, long pageLength, String transactionId, SearchReadHandle searchHandle, QueryManager.QueryView view, Set<DocumentManager.Metadata> categories, Format format, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        JerseySearchRequest request;
        ClientResponse response;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (extraParams != null) {
            params.putAll((Map)extraParams);
        }
        boolean withContent = true;
        this.addCategoryParams(categories, (MultivaluedMap<String, String>)params, withContent);
        if (searchHandle != null && view != null) {
            params.add((Object)"view", (Object)view.toString().toLowerCase());
        }
        if (start > 1L) {
            params.add((Object)"start", (Object)Long.toString(start));
        }
        if (pageLength >= 0L) {
            params.add((Object)"pageLength", (Object)Long.toString(pageLength));
        }
        if (format != null) {
            params.add((Object)"format", (Object)format.toString().toLowerCase());
        }
        if (transactionId != null) {
            params.add((Object)"txid", (Object)transactionId);
        }
        if (format == null && searchHandle != null) {
            HandleImplementation handleBase = HandleAccessor.as(searchHandle);
            if (Format.XML == handleBase.getFormat()) {
                params.add((Object)"format", (Object)"xml");
            } else if (Format.JSON == handleBase.getFormat()) {
                params.add((Object)"format", (Object)"json");
            }
        }
        if ((response = (request = this.generateSearchRequest(reqlog, querydef, "multipart/mixed", (MultivaluedMap<String, String>)params)).getResponse()) == null) {
            return null;
        }
        MultiPart entity = null;
        if (searchHandle != null && response.hasEntity() && (entity = (MultiPart)response.getEntity(MultiPart.class)) != null) {
            List partList = entity.getBodyParts();
            if (partList != null && partList.size() > 0) {
                BodyPart searchResponsePart = (BodyPart)partList.get(0);
                HandleImplementation handleBase = HandleAccessor.as(searchHandle);
                handleBase.receiveContent(searchResponsePart.getEntityAs(handleBase.receiveAs()));
                partList = partList.subList(1, partList.size());
            }
            MultipartCloseable closeable = new MultipartCloseable(response, entity);
            return this.makeResults(JerseyServiceResultIterator.class, reqlog, "read", "resource", partList, response, closeable);
        }
        return this.makeResults(JerseyServiceResultIterator.class, reqlog, "read", "resource", response);
    }

    private boolean getDocumentImpl(RequestLogger reqlog, DocumentDescriptor desc, String transactionId, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, String metadataFormat, DocumentMetadataReadHandle metadataHandle, AbstractReadHandle contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        MultiPart entity;
        int retry;
        String uri = desc.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("Document read for document identifier without uri");
        }
        assert (metadataHandle != null) : "metadataHandle is null";
        assert (contentHandle != null) : "contentHandle is null";
        if (logger.isDebugEnabled()) {
            logger.debug("Getting multipart for {} in transaction {}", (Object)uri, (Object)transactionId);
        }
        MultivaluedMap<String, String> docParams = this.makeDocumentParams(uri, categories, transactionId, extraParams, true);
        docParams.add((Object)"format", (Object)metadataFormat);
        WebResource.Builder builder = this.makeDocumentResource(docParams).getRequestBuilder();
        builder = this.addVersionHeader(desc, builder, "If-None-Match");
        MediaType multipartType = Boundary.addBoundary((MediaType)MultiPartMediaTypes.MULTIPART_MIXED_TYPE);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)((WebResource.Builder)builder.accept(new MediaType[]{multipartType})).get(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.NOT_FOUND) {
            throw new ResourceNotFoundException("Could not read non-existent document", this.extractErrorFields(response));
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to read documents", this.extractErrorFields(response));
        }
        if (status == ClientResponse.Status.NOT_MODIFIED) {
            response.close();
            return false;
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException("read failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "read %s document from %s transaction with %s metadata categories and content", uri, transactionId != null ? transactionId : "no", this.stringJoin(categories, ", ", "no"));
        MultiPart multiPart = entity = response.hasEntity() ? (MultiPart)response.getEntity(MultiPart.class) : null;
        if (entity == null) {
            return false;
        }
        List partList = entity.getBodyParts();
        if (partList == null) {
            return false;
        }
        int partCount = partList.size();
        if (partCount == 0) {
            return false;
        }
        if (partCount != 2) {
            throw new FailedRequestException("read expected 2 parts but got " + partCount + " parts");
        }
        HandleImplementation metadataBase = HandleAccessor.as(metadataHandle);
        HandleImplementation contentBase = HandleAccessor.as(contentHandle);
        BodyPart contentPart = (BodyPart)partList.get(1);
        MultivaluedMap responseHeaders = response.getHeaders();
        MultivaluedMap contentHeaders = contentPart.getHeaders();
        if (this.isExternalDescriptor(desc)) {
            this.updateVersion(desc, (MultivaluedMap<String, String>)responseHeaders);
            this.updateFormat((ContentDescriptor)desc, (MultivaluedMap<String, String>)responseHeaders);
            this.updateMimetype((ContentDescriptor)desc, (MultivaluedMap<String, String>)contentHeaders);
            this.updateLength((ContentDescriptor)desc, (MultivaluedMap<String, String>)contentHeaders);
            this.copyDescriptor(desc, contentBase);
        } else {
            this.updateFormat((ContentDescriptor)contentBase, (MultivaluedMap<String, String>)responseHeaders);
            this.updateMimetype((ContentDescriptor)contentBase, (MultivaluedMap<String, String>)contentHeaders);
            this.updateLength((ContentDescriptor)contentBase, (MultivaluedMap<String, String>)contentHeaders);
        }
        metadataBase.receiveContent(((BodyPart)partList.get(0)).getEntityAs(metadataBase.receiveAs()));
        Object contentEntity = contentPart.getEntityAs(contentBase.receiveAs());
        contentBase.receiveContent(reqlog != null ? reqlog.copyContent(contentEntity) : contentEntity);
        try {
            entity.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        response.close();
        return true;
    }

    @Override
    public DocumentDescriptor head(RequestLogger reqlog, String uri, String transactionId) throws ForbiddenUserException, FailedRequestException {
        ClientResponse response = this.headImpl(reqlog, uri, transactionId, this.makeDocumentResource(this.makeDocumentParams(uri, null, transactionId, null)));
        if (response == null) {
            return null;
        }
        MultivaluedMap responseHeaders = response.getHeaders();
        response.close();
        this.logRequest(reqlog, "checked %s document from %s transaction", uri, transactionId != null ? transactionId : "no");
        DocumentDescriptorImpl desc = new DocumentDescriptorImpl(uri, false);
        this.updateVersion(desc, (MultivaluedMap<String, String>)responseHeaders);
        this.updateDescriptor(desc, (MultivaluedMap<String, String>)responseHeaders);
        return desc;
    }

    @Override
    public boolean exists(String uri) throws ForbiddenUserException, FailedRequestException {
        return this.headImpl(null, uri, null, this.getConnection().path(uri)) != null;
    }

    public ClientResponse headImpl(RequestLogger reqlog, String uri, String transactionId, WebResource webResource) {
        int retry;
        if (uri == null) {
            throw new IllegalArgumentException("Existence check for document identifier without uri");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Requesting head for {} in transaction {}", (Object)uri, (Object)transactionId);
        }
        WebResource.Builder builder = webResource.getRequestBuilder();
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = builder.head()).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status != ClientResponse.Status.OK) {
            if (status == ClientResponse.Status.NOT_FOUND) {
                response.close();
                return null;
            }
            if (status == ClientResponse.Status.FORBIDDEN) {
                throw new ForbiddenUserException("User is not allowed to check the existence of documents", this.extractErrorFields(response));
            }
            throw new FailedRequestException("Document existence check failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        return response;
    }

    @Override
    public void putDocument(RequestLogger reqlog, DocumentDescriptor desc, String transactionId, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        Format descFormat;
        String contentMimetype;
        if (desc.getUri() == null) {
            throw new IllegalArgumentException("Document write for document identifier without uri");
        }
        HandleImplementation metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata");
        HandleImplementation contentBase = HandleAccessor.checkHandle(contentHandle, "content");
        String metadataMimetype = null;
        if (metadataBase != null) {
            metadataMimetype = metadataBase.getMimetype();
        }
        String string = contentMimetype = (descFormat = desc.getFormat()) != null && descFormat != Format.UNKNOWN ? desc.getMimetype() : null;
        if (contentMimetype == null && contentBase != null) {
            Format contentFormat = contentBase.getFormat();
            if (descFormat != null && descFormat != contentFormat) {
                contentMimetype = descFormat.getDefaultMimetype();
            } else if (contentFormat != null && contentFormat != Format.UNKNOWN) {
                contentMimetype = contentBase.getMimetype();
            }
        }
        if (metadataBase != null && contentBase != null) {
            this.putPostDocumentImpl(reqlog, "put", desc, transactionId, categories, extraParams, metadataMimetype, metadataHandle, contentMimetype, contentHandle);
        } else if (metadataBase != null) {
            this.putPostDocumentImpl(reqlog, "put", desc, transactionId, categories, false, extraParams, metadataMimetype, metadataHandle);
        } else if (contentBase != null) {
            this.putPostDocumentImpl(reqlog, "put", desc, transactionId, null, true, extraParams, contentMimetype, contentHandle);
        }
    }

    @Override
    public DocumentDescriptor postDocument(RequestLogger reqlog, DocumentUriTemplate template, String transactionId, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        String directory;
        String extension;
        Format templateFormat;
        String contentMimetype;
        DocumentDescriptorImpl desc = new DocumentDescriptorImpl(false);
        HandleImplementation metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata");
        HandleImplementation contentBase = HandleAccessor.checkHandle(contentHandle, "content");
        String metadataMimetype = null;
        if (metadataBase != null) {
            metadataMimetype = metadataBase.getMimetype();
        }
        String string = contentMimetype = (templateFormat = template.getFormat()) != null && templateFormat != Format.UNKNOWN ? template.getMimetype() : null;
        if (contentMimetype == null && contentBase != null) {
            Format contentFormat = contentBase.getFormat();
            if (templateFormat != null && templateFormat != contentFormat) {
                contentMimetype = templateFormat.getDefaultMimetype();
                desc.setFormat(templateFormat);
            } else if (contentFormat != null && contentFormat != Format.UNKNOWN) {
                contentMimetype = contentBase.getMimetype();
                desc.setFormat(contentFormat);
            }
        }
        desc.setMimetype(contentMimetype);
        if (extraParams == null) {
            extraParams = new RequestParameters();
        }
        if ((extension = template.getExtension()) != null) {
            extraParams.add("extension", extension);
        }
        if ((directory = template.getDirectory()) != null) {
            extraParams.add("directory", directory);
        }
        if (metadataBase != null && contentBase != null) {
            this.putPostDocumentImpl(reqlog, "post", desc, transactionId, categories, extraParams, metadataMimetype, metadataHandle, contentMimetype, contentHandle);
        } else if (contentBase != null) {
            this.putPostDocumentImpl(reqlog, "post", desc, transactionId, null, true, extraParams, contentMimetype, contentHandle);
        }
        return desc;
    }

    private void putPostDocumentImpl(RequestLogger reqlog, String method, DocumentDescriptor desc, String transactionId, Set<DocumentManager.Metadata> categories, boolean isOnContent, RequestParameters extraParams, String mimetype, AbstractWriteHandle handle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        String location;
        FailedRequest failure;
        int retry;
        String uri = desc.getUri();
        HandleImplementation handleBase = HandleAccessor.as(handle);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending {} document in transaction {}", (Object)(uri != null ? uri : "new"), (Object)transactionId);
        }
        this.logRequest(reqlog, "writing %s document from %s transaction with %s mime type and %s metadata categories", uri != null ? uri : "new", transactionId != null ? transactionId : "no", mimetype != null ? mimetype : "no", this.stringJoin(categories, ", ", "no"));
        WebResource webResource = this.makeDocumentResource(this.makeDocumentParams(uri, categories, transactionId, extraParams, isOnContent));
        WebResource.Builder builder = webResource.type(mimetype != null ? mimetype : "*/*");
        if (uri != null) {
            builder = this.addVersionHeader(desc, builder, "If-Match");
        }
        if ("patch".equals(method)) {
            builder = (WebResource.Builder)builder.header("X-HTTP-Method-Override", (Object)"PATCH");
            method = "post";
        }
        boolean isResendable = handleBase.isResendable();
        ClientResponse response = null;
        ClientResponse.Status status = null;
        MultivaluedMap responseHeaders = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            Object value;
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((value = handleBase.sendContent()) == null) {
                throw new IllegalArgumentException("Document write with null value for " + (uri != null ? uri : "new document"));
            }
            if (this.isFirstRequest() && !isResendable && this.isStreaming(value) && (nextDelay = this.makeFirstRequest(retry)) != 0) continue;
            if (value instanceof OutputStreamSender) {
                StreamingOutputImpl sentStream = new StreamingOutputImpl((OutputStreamSender)value, reqlog);
                response = "put".equals(method) ? (ClientResponse)builder.put(ClientResponse.class, (Object)sentStream) : (ClientResponse)builder.post(ClientResponse.class, (Object)sentStream);
            } else {
                Object sentObj = reqlog != null ? reqlog.copyContent(value) : value;
                response = "put".equals(method) ? (ClientResponse)builder.put(ClientResponse.class, sentObj) : (ClientResponse)builder.post(ClientResponse.class, sentObj);
            }
            status = response.getClientResponseStatus();
            responseHeaders = response.getHeaders();
            if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (!isResendable) {
                this.checkFirstRequest();
                throw new ResourceNotResendableException("Cannot retry request for " + (uri != null ? uri : "new document"));
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.NOT_FOUND) {
            throw new ResourceNotFoundException("Could not write non-existent document", this.extractErrorFields(response));
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTNOVERSION")) {
                throw new FailedRequestException("Content version required to write document", failure);
            }
            throw new ForbiddenUserException("User is not allowed to write documents", failure);
        }
        if (status == ClientResponse.Status.PRECONDITION_FAILED) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTWRONGVERSION")) {
                throw new FailedRequestException("Content version must match to write document", failure);
            }
            if (failure.getMessageCode().equals("RESTAPI-EMPTYBODY")) {
                throw new FailedRequestException("Empty request body sent to server", failure);
            }
            throw new FailedRequestException("Precondition Failed", failure);
        }
        if (status == null) {
            throw new FailedRequestException("write failed: Unknown Reason", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.CREATED && status != ClientResponse.Status.NO_CONTENT) {
            throw new FailedRequestException("write failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        if (uri == null && (location = (String)responseHeaders.getFirst((Object)"Location")) != null) {
            int offset = location.indexOf(DOCUMENT_URI_PREFIX);
            if (offset == -1) {
                throw new MarkLogicInternalException("document create produced invalid location: " + location);
            }
            uri = location.substring(offset + DOCUMENT_URI_PREFIX.length());
            if (uri == null) {
                throw new MarkLogicInternalException("document create produced location without uri: " + location);
            }
            desc.setUri(uri);
            this.updateVersion(desc, (MultivaluedMap<String, String>)responseHeaders);
            this.updateDescriptor(desc, (MultivaluedMap<String, String>)responseHeaders);
        }
        response.close();
    }

    private void putPostDocumentImpl(RequestLogger reqlog, String method, DocumentDescriptor desc, String transactionId, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, String metadataMimetype, DocumentMetadataWriteHandle metadataHandle, String contentMimetype, AbstractWriteHandle contentHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        String location;
        FailedRequest failure;
        int retry;
        String uri = desc.getUri();
        if (logger.isDebugEnabled()) {
            logger.debug("Sending {} multipart document in transaction {}", (Object)(uri != null ? uri : "new"), (Object)transactionId);
        }
        this.logRequest(reqlog, "writing %s document from %s transaction with %s metadata categories and content", uri != null ? uri : "new", transactionId != null ? transactionId : "no", this.stringJoin(categories, ", ", "no"));
        MultivaluedMap<String, String> docParams = this.makeDocumentParams(uri, categories, transactionId, extraParams, true);
        WebResource.Builder builder = this.makeDocumentResource(docParams).getRequestBuilder();
        if (uri != null) {
            builder = this.addVersionHeader(desc, builder, "If-Match");
        }
        MediaType multipartType = Boundary.addBoundary((MediaType)MultiPartMediaTypes.MULTIPART_MIXED_TYPE);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        MultivaluedMap responseHeaders = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            MultiPart multiPart = new MultiPart();
            boolean hasStreamingPart = this.addParts(multiPart, reqlog, new String[]{metadataMimetype, contentMimetype}, new AbstractWriteHandle[]{metadataHandle, contentHandle});
            if (this.isFirstRequest() && hasStreamingPart && (nextDelay = this.makeFirstRequest(retry)) != 0) continue;
            WebResource.Builder requestBlder = (WebResource.Builder)builder.type(multipartType);
            response = "put".equals(method) ? (ClientResponse)requestBlder.put(ClientResponse.class, (Object)multiPart) : (ClientResponse)requestBlder.post(ClientResponse.class, (Object)multiPart);
            status = response.getClientResponseStatus();
            responseHeaders = response.getHeaders();
            if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (hasStreamingPart) {
                throw new ResourceNotResendableException("Cannot retry request for " + (uri != null ? uri : "new document"));
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.NOT_FOUND) {
            response.close();
            throw new ResourceNotFoundException("Could not write non-existent document");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTNOVERSION")) {
                throw new FailedRequestException("Content version required to write document", failure);
            }
            throw new ForbiddenUserException("User is not allowed to write documents", failure);
        }
        if (status == ClientResponse.Status.PRECONDITION_FAILED) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTWRONGVERSION")) {
                throw new FailedRequestException("Content version must match to write document", failure);
            }
            if (failure.getMessageCode().equals("RESTAPI-EMPTYBODY")) {
                throw new FailedRequestException("Empty request body sent to server", failure);
            }
            throw new FailedRequestException("Precondition Failed", failure);
        }
        if (status != ClientResponse.Status.CREATED && status != ClientResponse.Status.NO_CONTENT) {
            throw new FailedRequestException("write failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        if (uri == null && (location = (String)responseHeaders.getFirst((Object)"Location")) != null) {
            int offset = location.indexOf(DOCUMENT_URI_PREFIX);
            if (offset == -1) {
                throw new MarkLogicInternalException("document create produced invalid location: " + location);
            }
            uri = location.substring(offset + DOCUMENT_URI_PREFIX.length());
            if (uri == null) {
                throw new MarkLogicInternalException("document create produced location without uri: " + location);
            }
            desc.setUri(uri);
            this.updateVersion(desc, responseHeaders);
            this.updateDescriptor(desc, (MultivaluedMap<String, String>)responseHeaders);
        }
        response.close();
    }

    @Override
    public void patchDocument(RequestLogger reqlog, DocumentDescriptor desc, String transactionId, Set<DocumentManager.Metadata> categories, boolean isOnContent, DocumentPatchHandle patchHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        HandleImplementation patchBase = HandleAccessor.checkHandle(patchHandle, "patch");
        this.putPostDocumentImpl(reqlog, "patch", desc, transactionId, categories, isOnContent, null, patchBase.getMimetype(), patchHandle);
    }

    @Override
    public String openTransaction(String name, int timeLimit) throws ForbiddenUserException, FailedRequestException {
        int retry;
        if (logger.isDebugEnabled()) {
            logger.debug("Opening transaction");
        }
        MultivaluedMapImpl transParams = new MultivaluedMapImpl();
        if (name != null || timeLimit > 0) {
            if (name != null) {
                this.addEncodedParam((MultivaluedMap<String, String>)transParams, "name", name);
            }
            if (timeLimit > 0) {
                transParams.add((Object)"timeLimit", (Object)String.valueOf(timeLimit));
            }
        }
        if (this.database != null) {
            this.addEncodedParam((MultivaluedMap<String, String>)transParams, "database", this.database);
        }
        WebResource resource = transParams != null ? this.getConnection().path("transactions").queryParams((MultivaluedMap)transParams) : this.getConnection().path("transactions");
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)resource.post(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to open transactions", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.SEE_OTHER) {
            throw new FailedRequestException("transaction open failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        String location = (String)response.getHeaders().getFirst((Object)"Location");
        response.close();
        if (location == null) {
            throw new MarkLogicInternalException("transaction open failed to provide location");
        }
        if (!location.contains("/")) {
            throw new MarkLogicInternalException("transaction open produced invalid location: " + location);
        }
        return location.substring(location.lastIndexOf("/") + 1);
    }

    @Override
    public void commitTransaction(String transactionId) throws ForbiddenUserException, FailedRequestException {
        this.completeTransaction(transactionId, "commit");
    }

    @Override
    public void rollbackTransaction(String transactionId) throws ForbiddenUserException, FailedRequestException {
        this.completeTransaction(transactionId, "rollback");
    }

    private void completeTransaction(String transactionId, String result) throws ForbiddenUserException, FailedRequestException {
        int retry;
        if (result == null) {
            throw new MarkLogicInternalException("transaction completion without operation");
        }
        if (transactionId == null) {
            throw new MarkLogicInternalException("transaction completion without id: " + result);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Completing transaction {} with {}", (Object)transactionId, (Object)result);
        }
        MultivaluedMapImpl transParams = new MultivaluedMapImpl();
        transParams.add((Object)"result", (Object)result);
        WebResource webResource = this.getConnection().path("transactions/" + transactionId).queryParams((MultivaluedMap)transParams);
        WebResource.Builder builder = webResource.getRequestBuilder();
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.post(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to complete transaction with " + result, this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.NO_CONTENT) {
            throw new FailedRequestException("transaction " + result + " failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        response.close();
    }

    private void addCategoryParams(Set<DocumentManager.Metadata> categories, MultivaluedMap<String, String> params, boolean withContent) {
        if (withContent && categories == null || categories.size() == 0) {
            params.add((Object)"category", (Object)"content");
        } else {
            if (withContent) {
                params.add((Object)"category", (Object)"content");
            }
            if (categories.contains((Object)DocumentManager.Metadata.ALL)) {
                params.add((Object)"category", (Object)"metadata");
            } else {
                for (DocumentManager.Metadata category : categories) {
                    params.add((Object)"category", (Object)category.name().toLowerCase());
                }
            }
        }
    }

    private void addCategoryParams(Set<DocumentManager.Metadata> categories, RequestParameters params, boolean withContent) {
        if (withContent && categories == null || categories.size() == 0) {
            params.add("category", "content");
        } else {
            if (withContent) {
                params.add("category", "content");
            }
            if (categories.contains((Object)DocumentManager.Metadata.ALL)) {
                params.add("category", "metadata");
            } else {
                for (DocumentManager.Metadata category : categories) {
                    params.add("category", category.name().toLowerCase());
                }
            }
        }
    }

    private MultivaluedMap<String, String> makeDocumentParams(String uri, Set<DocumentManager.Metadata> categories, String transactionId, RequestParameters extraParams) {
        return this.makeDocumentParams(uri, categories, transactionId, extraParams, false);
    }

    private MultivaluedMap<String, String> makeDocumentParams(String uri, Set<DocumentManager.Metadata> categories, String transactionId, RequestParameters extraParams, boolean withContent) {
        MultivaluedMapImpl docParams = new MultivaluedMapImpl();
        if (extraParams != null && extraParams.size() > 0) {
            for (Map.Entry<String, List<String>> entry : extraParams.entrySet()) {
                String extraKey = entry.getKey();
                if ("range".equalsIgnoreCase(extraKey)) continue;
                this.addEncodedParam((MultivaluedMap<String, String>)docParams, extraKey, entry.getValue());
            }
        }
        this.addEncodedParam((MultivaluedMap<String, String>)docParams, "uri", uri);
        if (this.database != null) {
            this.addEncodedParam((MultivaluedMap<String, String>)docParams, "database", this.database);
        }
        if (categories == null || categories.size() == 0) {
            docParams.add((Object)"category", (Object)"content");
        } else {
            if (withContent) {
                docParams.add((Object)"category", (Object)"content");
            }
            if (categories.contains((Object)DocumentManager.Metadata.ALL)) {
                docParams.add((Object)"category", (Object)"metadata");
            } else {
                for (DocumentManager.Metadata category : categories) {
                    docParams.add((Object)"category", (Object)category.name().toLowerCase());
                }
            }
        }
        if (transactionId != null) {
            docParams.add((Object)"txid", (Object)transactionId);
        }
        return docParams;
    }

    private WebResource makeDocumentResource(MultivaluedMap<String, String> queryParams) {
        return this.getConnection().path("documents").queryParams(queryParams);
    }

    private boolean isExternalDescriptor(ContentDescriptor desc) {
        return desc != null && desc instanceof DocumentDescriptorImpl && !((DocumentDescriptorImpl)desc).isInternal();
    }

    private void updateDescriptor(ContentDescriptor desc, MultivaluedMap<String, String> headers) {
        if (desc == null || headers == null) {
            return;
        }
        this.updateFormat(desc, headers);
        this.updateMimetype(desc, headers);
        this.updateLength(desc, headers);
    }

    private void copyDescriptor(DocumentDescriptor desc, HandleImplementation handleBase) {
        if (handleBase == null) {
            return;
        }
        handleBase.setFormat(desc.getFormat());
        handleBase.setMimetype(desc.getMimetype());
        handleBase.setByteLength(desc.getByteLength());
    }

    private void updateFormat(ContentDescriptor descriptor, MultivaluedMap<String, String> headers) {
        this.updateFormat(descriptor, this.getHeaderFormat(headers));
    }

    private void updateFormat(ContentDescriptor descriptor, Format format) {
        if (format != null) {
            descriptor.setFormat(format);
        }
    }

    private Format getHeaderFormat(MultivaluedMap<String, String> headers) {
        List values;
        if (headers.containsKey((Object)"vnd.marklogic.document-format") && (values = (List)headers.get((Object)"vnd.marklogic.document-format")) != null) {
            return Format.valueOf(((String)values.get(0)).toUpperCase());
        }
        return null;
    }

    private Format getHeaderFormat(BodyPart part) {
        String value;
        ContentDisposition contentDisposition = part.getContentDisposition();
        if (part.getHeaders().containsKey((Object)"vnd.marklogic.document-format")) {
            String value2 = (String)part.getHeaders().getFirst((Object)"vnd.marklogic.document-format");
            if (value2 != null) {
                return Format.valueOf(value2.toUpperCase());
            }
        } else if (contentDisposition != null) {
            Map parameters = contentDisposition.getParameters();
            if (parameters != null && parameters.get("format") != null) {
                return Format.valueOf(((String)parameters.get("format")).toUpperCase());
            }
        } else if (part.getHeaders().containsKey((Object)"Content-Type") && (value = (String)part.getHeaders().getFirst((Object)"Content-Type")) != null) {
            return Format.getFromMimetype(value);
        }
        return null;
    }

    private void updateMimetype(ContentDescriptor descriptor, MultivaluedMap<String, String> headers) {
        this.updateMimetype(descriptor, this.getHeaderMimetype((Map<String, List<String>>)headers));
    }

    private void updateMimetype(ContentDescriptor descriptor, String mimetype) {
        if (mimetype != null) {
            descriptor.setMimetype(mimetype);
        }
    }

    private String getHeaderMimetype(Map<String, List<String>> headers) {
        List<String> values;
        if (headers.containsKey("Content-Type") && (values = headers.get("Content-Type")) != null) {
            String mimetype;
            String contentType = values.get(0);
            String string = mimetype = contentType.contains(";") ? contentType.substring(0, contentType.indexOf(";")) : contentType;
            if (mimetype != null && mimetype.length() > 0) {
                return mimetype;
            }
        }
        return null;
    }

    private void updateLength(ContentDescriptor descriptor, MultivaluedMap<String, String> headers) {
        this.updateLength(descriptor, this.getHeaderLength(headers));
    }

    private void updateLength(ContentDescriptor descriptor, long length) {
        descriptor.setByteLength(length);
    }

    private long getHeaderLength(MultivaluedMap<String, String> headers) {
        List values;
        if (headers.containsKey((Object)"Content-Length") && (values = (List)headers.get((Object)"Content-Length")) != null) {
            return Long.valueOf((String)values.get(0));
        }
        return -1L;
    }

    private String getHeaderUri(ContentDisposition contentDisposition) {
        if (contentDisposition != null) {
            return contentDisposition.getFileName();
        }
        return null;
    }

    private void updateVersion(DocumentDescriptor descriptor, MultivaluedMap<String, String> headers) {
        List values;
        long version = -1L;
        if (headers.containsKey((Object)"ETag") && (values = (List)headers.get((Object)"ETag")) != null) {
            String value = (String)values.get(0);
            version = Long.valueOf(value.substring(1, value.length() - 1));
        }
        descriptor.setVersion(version);
    }

    private WebResource.Builder addVersionHeader(DocumentDescriptor desc, WebResource.Builder builder, String name) {
        long version;
        if (desc != null && desc instanceof DocumentDescriptorImpl && !((DocumentDescriptorImpl)desc).isInternal() && (version = desc.getVersion()) != -1L) {
            return (WebResource.Builder)builder.header(name, (Object)("\"" + String.valueOf(version) + "\""));
        }
        return builder;
    }

    @Override
    public <T> T search(RequestLogger reqlog, Class<T> as, QueryDefinition queryDef, String mimetype, long start, long len, QueryManager.QueryView view, String transactionId) throws ForbiddenUserException, FailedRequestException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (start > 1L) {
            params.add((Object)"start", (Object)Long.toString(start));
        }
        if (len > 0L) {
            params.add((Object)"pageLength", (Object)Long.toString(len));
        }
        if (transactionId != null) {
            params.add((Object)"txid", (Object)transactionId);
        }
        if (view != null && view != QueryManager.QueryView.DEFAULT) {
            if (view == QueryManager.QueryView.ALL) {
                params.add((Object)"view", (Object)"all");
            } else if (view == QueryManager.QueryView.RESULTS) {
                params.add((Object)"view", (Object)"results");
            } else if (view == QueryManager.QueryView.FACETS) {
                params.add((Object)"view", (Object)"facets");
            } else if (view == QueryManager.QueryView.METADATA) {
                params.add((Object)"view", (Object)"metadata");
            }
        }
        T entity = this.search(reqlog, as, queryDef, mimetype, (MultivaluedMap<String, String>)params);
        this.logRequest(reqlog, "searched starting at %s with length %s in %s transaction with %s mime type", start, len, transactionId, mimetype);
        return entity;
    }

    @Override
    public <T> T search(RequestLogger reqlog, Class<T> as, QueryDefinition queryDef, String mimetype, String view) throws ForbiddenUserException, FailedRequestException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (view != null) {
            params.add((Object)"view", (Object)view);
        }
        return this.search(reqlog, as, queryDef, mimetype, (MultivaluedMap<String, String>)params);
    }

    private <T> T search(RequestLogger reqlog, Class<T> as, QueryDefinition queryDef, String mimetype, MultivaluedMap<String, String> params) throws ForbiddenUserException, FailedRequestException {
        Object entity;
        JerseySearchRequest request = this.generateSearchRequest(reqlog, queryDef, mimetype, params);
        ClientResponse response = request.getResponse();
        if (response == null) {
            return null;
        }
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            response.close();
        }
        return (T)entity;
    }

    private JerseySearchRequest generateSearchRequest(RequestLogger reqlog, QueryDefinition queryDef, String mimetype, MultivaluedMap<String, String> params) {
        if (this.database != null) {
            if (params == null) {
                params = new MultivaluedMapImpl();
            }
            this.addEncodedParam((MultivaluedMap<String, String>)params, "database", this.database);
        }
        return new JerseySearchRequest(reqlog, queryDef, mimetype, (MultivaluedMap<String, String>)params);
    }

    @Override
    public void deleteSearch(RequestLogger reqlog, DeleteQueryDefinition queryDef, String transactionId) throws ForbiddenUserException, FailedRequestException {
        int retry;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (queryDef.getDirectory() != null) {
            this.addEncodedParam((MultivaluedMap<String, String>)params, "directory", queryDef.getDirectory());
        }
        this.addEncodedParam((MultivaluedMap<String, String>)params, "collection", queryDef.getCollections());
        if (transactionId != null) {
            params.add((Object)"txid", (Object)transactionId);
        }
        if (this.database != null) {
            this.addEncodedParam((MultivaluedMap<String, String>)params, "database", this.database);
        }
        WebResource webResource = this.getConnection().path("search").queryParams((MultivaluedMap)params);
        WebResource.Builder builder = webResource.getRequestBuilder();
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.delete(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to delete", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.NO_CONTENT) {
            throw new FailedRequestException("delete failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "deleted search results in %s transaction", transactionId);
    }

    @Override
    public <T> T values(Class<T> as, ValuesDefinition valDef, String mimetype, long start, long pageLength, String transactionId) throws ForbiddenUserException, FailedRequestException {
        Object entity;
        int retry;
        MultivaluedMapImpl docParams = new MultivaluedMapImpl();
        String optionsName = valDef.getOptionsName();
        if (optionsName != null && optionsName.length() > 0) {
            this.addEncodedParam((MultivaluedMap<String, String>)docParams, "options", optionsName);
        }
        if (valDef.getAggregate() != null) {
            this.addEncodedParam((MultivaluedMap<String, String>)docParams, "aggregate", valDef.getAggregate());
        }
        if (valDef.getAggregatePath() != null) {
            this.addEncodedParam((MultivaluedMap<String, String>)docParams, "aggregatePath", valDef.getAggregatePath());
        }
        if (valDef.getView() != null) {
            docParams.add((Object)"view", (Object)valDef.getView());
        }
        if (valDef.getDirection() != null) {
            if (valDef.getDirection() == ValuesDefinition.Direction.ASCENDING) {
                docParams.add((Object)"direction", (Object)"ascending");
            } else {
                docParams.add((Object)"direction", (Object)"descending");
            }
        }
        if (valDef.getFrequency() != null) {
            if (valDef.getFrequency() == ValuesDefinition.Frequency.FRAGMENT) {
                docParams.add((Object)"frequency", (Object)"fragment");
            } else {
                docParams.add((Object)"frequency", (Object)"item");
            }
        }
        if (start > 0L) {
            docParams.add((Object)"start", (Object)Long.toString(start));
            if (pageLength > 0L) {
                docParams.add((Object)"pageLength", (Object)Long.toString(pageLength));
            }
        }
        HandleImplementation baseHandle = null;
        if (valDef.getQueryDefinition() != null) {
            ValueQueryDefinition queryDef = valDef.getQueryDefinition();
            if (optionsName == null) {
                optionsName = queryDef.getOptionsName();
                if (optionsName != null) {
                    this.addEncodedParam((MultivaluedMap<String, String>)docParams, "options", optionsName);
                }
            } else if (queryDef.getOptionsName() != null && optionsName != queryDef.getOptionsName() && logger.isWarnEnabled()) {
                logger.warn("values definition options take precedence over query definition options");
            }
            if (queryDef.getCollections() != null && logger.isWarnEnabled()) {
                logger.warn("collections scope ignored for values query");
            }
            if (queryDef.getDirectory() != null && logger.isWarnEnabled()) {
                logger.warn("directory scope ignored for values query");
            }
            if (queryDef instanceof StringQueryDefinition) {
                String text = ((StringQueryDefinition)queryDef).getCriteria();
                if (text != null) {
                    this.addEncodedParam((MultivaluedMap<String, String>)docParams, "q", text);
                }
            } else if (queryDef instanceof StructuredQueryDefinition) {
                String structure = ((StructuredQueryDefinition)queryDef).serialize();
                if (structure != null) {
                    this.addEncodedParam((MultivaluedMap<String, String>)docParams, "structuredQuery", structure);
                }
            } else if (queryDef instanceof RawQueryDefinition) {
                StructureWriteHandle handle = ((RawQueryDefinition)((Object)queryDef)).getHandle();
                baseHandle = HandleAccessor.checkHandle(handle, "values");
            } else if (logger.isWarnEnabled()) {
                logger.warn("unsupported query definition: " + queryDef.getClass().getName());
            }
            ServerTransform transform = queryDef.getResponseTransform();
            if (transform != null) {
                transform.merge((Map<String, List<String>>)docParams);
            }
        }
        if (transactionId != null) {
            docParams.add((Object)"txid", (Object)transactionId);
        }
        String uri = "values";
        if (valDef.getName() != null) {
            uri = uri + "/" + valDef.getName();
        }
        WebResource.Builder builder = this.getConnection().path(uri).queryParams((MultivaluedMap)docParams).accept(new String[]{mimetype});
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = baseHandle == null ? this.doGet(builder) : this.doPost(null, (WebResource.Builder)builder.type(baseHandle.getMimetype()), baseHandle.sendContent(), baseHandle.isResendable())).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to search", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException("search failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            response.close();
        }
        return (T)entity;
    }

    @Override
    public <T> T valuesList(Class<T> as, ValuesListDefinition valDef, String mimetype, String transactionId) throws ForbiddenUserException, FailedRequestException {
        Object entity;
        int retry;
        MultivaluedMapImpl docParams = new MultivaluedMapImpl();
        String optionsName = valDef.getOptionsName();
        if (optionsName != null && optionsName.length() > 0) {
            this.addEncodedParam((MultivaluedMap<String, String>)docParams, "options", optionsName);
        }
        if (transactionId != null) {
            docParams.add((Object)"txid", (Object)transactionId);
        }
        String uri = "values";
        WebResource.Builder builder = this.getConnection().path(uri).queryParams((MultivaluedMap)docParams).accept(new String[]{mimetype});
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.get(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to search", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException("search failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            response.close();
        }
        return (T)entity;
    }

    @Override
    public <T> T optionsList(Class<T> as, String mimetype, String transactionId) throws ForbiddenUserException, FailedRequestException {
        Object entity;
        int retry;
        MultivaluedMapImpl docParams = new MultivaluedMapImpl();
        if (transactionId != null) {
            docParams.add((Object)"txid", (Object)transactionId);
        }
        String uri = "config/query";
        WebResource.Builder builder = this.getConnection().path(uri).queryParams((MultivaluedMap)docParams).accept(new String[]{mimetype});
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.get(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to search", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException("search failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            response.close();
        }
        return (T)entity;
    }

    @Override
    public <T> T getValue(RequestLogger reqlog, String type, String key, boolean isNullable, String mimetype, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        Object entity;
        int retry;
        if (logger.isDebugEnabled()) {
            logger.debug("Getting {}/{}", (Object)type, (Object)key);
        }
        WebResource.Builder builder = this.getConnection().path(type + "/" + key).accept(new String[]{mimetype});
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.get(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status != ClientResponse.Status.OK) {
            if (status == ClientResponse.Status.NOT_FOUND) {
                response.close();
                if (!isNullable) {
                    throw new ResourceNotFoundException("Could not get " + type + "/" + key);
                }
                return null;
            }
            if (status == ClientResponse.Status.FORBIDDEN) {
                throw new ForbiddenUserException("User is not allowed to read " + type, this.extractErrorFields(response));
            }
            throw new FailedRequestException(type + " read failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "read %s value with %s key and %s mime type", type, key, mimetype != null ? mimetype : null);
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            response.close();
        }
        return (T)(reqlog != null ? reqlog.copyContent(entity) : entity);
    }

    @Override
    public <T> T getValues(RequestLogger reqlog, String type, String mimetype, Class<T> as) throws ForbiddenUserException, FailedRequestException {
        return this.getValues(reqlog, type, null, mimetype, as);
    }

    @Override
    public <T> T getValues(RequestLogger reqlog, String type, RequestParameters extraParams, String mimetype, Class<T> as) throws ForbiddenUserException, FailedRequestException {
        Object entity;
        int retry;
        MultivaluedMap<String, String> requestParams;
        if (logger.isDebugEnabled()) {
            logger.debug("Getting {}", (Object)type);
        }
        WebResource.Builder builder = (requestParams = this.convertParams(extraParams)) == null ? this.getConnection().path(type).accept(new String[]{mimetype}) : this.getConnection().path(type).queryParams(requestParams).accept(new String[]{mimetype});
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.get(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to read " + type, this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException(type + " read failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "read %s values with %s mime type", type, mimetype != null ? mimetype : null);
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            response.close();
        }
        return (T)(reqlog != null ? reqlog.copyContent(entity) : entity);
    }

    @Override
    public void postValue(RequestLogger reqlog, String type, String key, String mimetype, Object value) throws ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (logger.isDebugEnabled()) {
            logger.debug("Posting {}/{}", (Object)type, (Object)key);
        }
        this.putPostValueImpl(reqlog, "post", type, key, null, mimetype, value, ClientResponse.Status.CREATED);
    }

    @Override
    public void postValue(RequestLogger reqlog, String type, String key, RequestParameters extraParams) throws ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (logger.isDebugEnabled()) {
            logger.debug("Posting {}/{}", (Object)type, (Object)key);
        }
        this.putPostValueImpl(reqlog, "post", type, key, extraParams, null, null, ClientResponse.Status.NO_CONTENT);
    }

    @Override
    public void putValue(RequestLogger reqlog, String type, String key, String mimetype, Object value) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (logger.isDebugEnabled()) {
            logger.debug("Putting {}/{}", (Object)type, (Object)key);
        }
        this.putPostValueImpl(reqlog, "put", type, key, null, mimetype, value, ClientResponse.Status.NO_CONTENT, ClientResponse.Status.CREATED);
    }

    @Override
    public void putValue(RequestLogger reqlog, String type, String key, RequestParameters extraParams, String mimetype, Object value) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (logger.isDebugEnabled()) {
            logger.debug("Putting {}/{}", (Object)type, (Object)key);
        }
        this.putPostValueImpl(reqlog, "put", type, key, extraParams, mimetype, value, ClientResponse.Status.NO_CONTENT);
    }

    private void putPostValueImpl(RequestLogger reqlog, String method, String type, String key, RequestParameters extraParams, String mimetype, Object value, ClientResponse.Status ... expectedStatuses) {
        int retry;
        if (key != null) {
            this.logRequest(reqlog, "writing %s value with %s key and %s mime type", type, key, mimetype != null ? mimetype : null);
        } else {
            this.logRequest(reqlog, "writing %s values with %s mime type", type, mimetype != null ? mimetype : null);
        }
        HandleImplementation handle = value instanceof HandleImplementation ? (HandleImplementation)value : null;
        MultivaluedMap<String, String> requestParams = this.convertParams(extraParams);
        String connectPath = null;
        WebResource.Builder builder = null;
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            WebResource resource;
            boolean isResendable;
            boolean isStreaming;
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            Object nextValue = handle != null ? handle.sendContent() : value;
            Object sentValue = null;
            sentValue = nextValue instanceof OutputStreamSender ? new StreamingOutputImpl((OutputStreamSender)nextValue, reqlog) : (reqlog != null && retry == 0 ? reqlog.copyContent(nextValue) : nextValue);
            boolean bl = isStreaming = this.isFirstRequest() || handle == null ? this.isStreaming(sentValue) : false;
            boolean bl2 = handle == null ? !isStreaming : (isResendable = handle.isResendable());
            if (this.isFirstRequest() && !isResendable && isStreaming && (nextDelay = this.makeFirstRequest(retry)) != 0) continue;
            if ("put".equals(method)) {
                if (builder == null) {
                    connectPath = key != null ? type + "/" + key : type;
                    resource = requestParams == null ? this.getConnection().path(connectPath) : this.getConnection().path(connectPath).queryParams(requestParams);
                    builder = mimetype == null ? resource.getRequestBuilder() : resource.type(mimetype);
                }
                response = sentValue == null ? (ClientResponse)builder.put(ClientResponse.class) : (ClientResponse)builder.put(ClientResponse.class, sentValue);
            } else if ("post".equals(method)) {
                if (builder == null) {
                    connectPath = type;
                    resource = requestParams == null ? this.getConnection().path(connectPath) : this.getConnection().path(connectPath).queryParams(requestParams);
                    builder = mimetype == null ? resource.getRequestBuilder() : resource.type(mimetype);
                }
                response = sentValue == null ? (ClientResponse)builder.post(ClientResponse.class) : (ClientResponse)builder.post(ClientResponse.class, sentValue);
            } else {
                throw new MarkLogicInternalException("unknown method type " + method);
            }
            status = response.getClientResponseStatus();
            if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (!isResendable) {
                this.checkFirstRequest();
                throw new ResourceNotResendableException("Cannot retry request for " + connectPath);
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to write " + type, this.extractErrorFields(response));
        }
        if (status == ClientResponse.Status.NOT_FOUND) {
            throw new ResourceNotFoundException(type + " not found for write", this.extractErrorFields(response));
        }
        boolean statusOk = false;
        for (ClientResponse.Status expectedStatus : expectedStatuses) {
            boolean bl = statusOk = statusOk || status == expectedStatus;
            if (statusOk) break;
        }
        if (!statusOk) {
            throw new FailedRequestException(type + " write failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        response.close();
    }

    @Override
    public void deleteValue(RequestLogger reqlog, String type, String key) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        int retry;
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting {}/{}", (Object)type, (Object)key);
        }
        WebResource builder = this.getConnection().path(type + "/" + key);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.delete(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to delete " + type, this.extractErrorFields(response));
        }
        if (status == ClientResponse.Status.NOT_FOUND) {
            throw new ResourceNotFoundException(type + " not found for delete", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.NO_CONTENT) {
            throw new FailedRequestException("delete failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        response.close();
        this.logRequest(reqlog, "deleted %s value with %s key", type, key);
    }

    @Override
    public void deleteValues(RequestLogger reqlog, String type) throws ForbiddenUserException, FailedRequestException {
        int retry;
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting {}", (Object)type);
        }
        WebResource builder = this.getConnection().path(type);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.delete(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to delete " + type, this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.NO_CONTENT) {
            throw new FailedRequestException("delete failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        response.close();
        this.logRequest(reqlog, "deleted %s values", type);
    }

    @Override
    public <R extends AbstractReadHandle> R getResource(RequestLogger reqlog, String path, RequestParameters params, R output) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        int retry;
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String mimetype = outputBase.getMimetype();
        Class as = outputBase.receiveAs();
        WebResource.Builder builder = this.makeGetBuilder(path, params, mimetype);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = this.doGet(builder)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "read", "resource", path, RESTServices.ResponseStatus.OK_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "read", "resource", response, as));
        } else {
            response.close();
        }
        return output;
    }

    @Override
    public ResourceServices.ServiceResultIterator getIteratedResource(RequestLogger reqlog, String path, RequestParameters params, String ... mimetypes) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.getIteratedResourceImpl(JerseyServiceResultIterator.class, reqlog, path, params, mimetypes);
    }

    private <U extends JerseyResultIterator> U getIteratedResourceImpl(Class<U> clazz, RequestLogger reqlog, String path, RequestParameters params, String ... mimetypes) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        int retry;
        WebResource.Builder builder = this.makeGetBuilder(path, params, null);
        MediaType multipartType = Boundary.addBoundary((MediaType)MultiPartMediaTypes.MULTIPART_MIXED_TYPE);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = this.doGet((WebResource.Builder)builder.accept(new MediaType[]{multipartType}))).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "read", "resource", path, RESTServices.ResponseStatus.OK_OR_NO_CONTENT);
        return this.makeResults(clazz, reqlog, "read", "resource", response);
    }

    @Override
    public <R extends AbstractReadHandle> R putResource(RequestLogger reqlog, String path, RequestParameters params, AbstractWriteHandle input, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        HandleImplementation inputBase = HandleAccessor.checkHandle(input, "write");
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String inputMimetype = inputBase.getMimetype();
        boolean isResendable = inputBase.isResendable();
        String outputMimeType = null;
        Class as = null;
        if (outputBase != null) {
            outputMimeType = outputBase.getMimetype();
            as = outputBase.receiveAs();
        }
        WebResource.Builder builder = this.makePutBuilder(path, params, inputMimetype, outputMimeType);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = this.doPut(reqlog, builder, inputBase.sendContent(), !isResendable)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (!isResendable) {
                this.checkFirstRequest();
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "write", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "write", "resource", response, as));
        } else {
            response.close();
        }
        return output;
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R putResource(RequestLogger reqlog, String path, RequestParameters params, W[] input, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        if (input == null || input.length == 0) {
            throw new IllegalArgumentException("input not specified for multipart");
        }
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String outputMimetype = outputBase.getMimetype();
        Class as = outputBase.receiveAs();
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            MultiPart multiPart = new MultiPart();
            boolean hasStreamingPart = this.addParts(multiPart, reqlog, (AbstractWriteHandle[])input);
            WebResource.Builder builder = this.makePutBuilder(path, params, multiPart, outputMimetype);
            response = this.doPut(builder, multiPart, hasStreamingPart);
            status = response.getClientResponseStatus();
            if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (hasStreamingPart) {
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "write", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "write", "resource", response, as));
        } else {
            response.close();
        }
        return output;
    }

    @Override
    public <R extends AbstractReadHandle> R postResource(RequestLogger reqlog, String path, RequestParameters params, AbstractWriteHandle input, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        HandleImplementation inputBase = HandleAccessor.checkHandle(input, "write");
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String inputMimetype = inputBase.getMimetype();
        String outputMimetype = outputBase.getMimetype();
        boolean isResendable = inputBase.isResendable();
        Class as = outputBase.receiveAs();
        WebResource.Builder builder = this.makePostBuilder(path, params, inputMimetype, (Object)outputMimetype);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = this.doPost(reqlog, builder, inputBase.sendContent(), !isResendable)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (!isResendable) {
                this.checkFirstRequest();
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "apply", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "apply", "resource", response, as));
        } else {
            response.close();
        }
        return output;
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R postResource(RequestLogger reqlog, String path, RequestParameters params, W[] input, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        return (R)this.postResource(reqlog, path, params, (AbstractWriteHandle[])input, null, output);
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R postResource(RequestLogger reqlog, String path, RequestParameters params, W[] input, Map<String, List<String>>[] headers, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String outputMimetype = outputBase != null ? outputBase.getMimetype() : null;
        Class as = outputBase != null ? outputBase.receiveAs() : null;
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            MultiPart multiPart = new MultiPart();
            boolean hasStreamingPart = this.addParts(multiPart, reqlog, null, (AbstractWriteHandle[])input, headers);
            WebResource.Builder builder = this.makePostBuilder(path, params, multiPart, (Object)outputMimetype);
            response = this.doPost(builder, multiPart, hasStreamingPart);
            status = response.getClientResponseStatus();
            if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (hasStreamingPart) {
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "apply", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "apply", "resource", response, as));
        } else {
            response.close();
        }
        return output;
    }

    @Override
    public void postBulkDocuments(RequestLogger reqlog, DocumentWriteSet writeSet, ServerTransform transform, Format defaultFormat, String transactionId) throws ForbiddenUserException, FailedRequestException {
        this.postBulkDocuments(reqlog, writeSet, transform, transactionId, defaultFormat, (R)null);
    }

    public <R extends AbstractReadHandle> R postBulkDocuments(RequestLogger reqlog, DocumentWriteSet writeSet, ServerTransform transform, String transactionId, Format defaultFormat, R output) throws ForbiddenUserException, FailedRequestException {
        ArrayList<AbstractWriteHandle> writeHandles = new ArrayList<AbstractWriteHandle>();
        ArrayList<MultivaluedMapImpl> headerList = new ArrayList<MultivaluedMapImpl>();
        for (DocumentWriteOperation write : writeSet) {
            MultivaluedMapImpl headers;
            HandleImplementation metadata = HandleAccessor.checkHandle(write.getMetadata(), "write");
            HandleImplementation content = HandleAccessor.checkHandle(write.getContent(), "write");
            if (write.getOperationType() == DocumentWriteOperation.OperationType.DISABLE_METADATA_DEFAULT) {
                headers = new MultivaluedMapImpl();
                headers.add((Object)"Content-Type", (Object)metadata.getMimetype());
                headers.add((Object)"Content-Disposition", (Object)"inline; category=metadata");
                headerList.add(headers);
                writeHandles.add(write.getMetadata());
            } else if (metadata != null) {
                headers = new MultivaluedMapImpl();
                headers.add((Object)"Content-Type", (Object)metadata.getMimetype());
                if (write.getOperationType() == DocumentWriteOperation.OperationType.METADATA_DEFAULT) {
                    headers.add((Object)"Content-Disposition", (Object)"inline; category=metadata");
                } else {
                    headers.add((Object)"Content-Disposition", (Object)(ContentDisposition.type((String)"attachment").fileName(write.getUri()).build().toString() + "; category=metadata"));
                }
                headerList.add(headers);
                writeHandles.add(write.getMetadata());
            }
            if (content == null) continue;
            headers = new MultivaluedMapImpl();
            String mimeType = content.getMimetype();
            if (mimeType == null && defaultFormat != null) {
                mimeType = defaultFormat.getDefaultMimetype();
            }
            headers.add((Object)"Content-Type", (Object)mimeType);
            headers.add((Object)"Content-Disposition", (Object)ContentDisposition.type((String)"attachment").fileName(write.getUri()).build().toString());
            headerList.add(headers);
            writeHandles.add(write.getContent());
        }
        RequestParameters params = new RequestParameters();
        if (transform != null) {
            transform.merge(params);
        }
        if (transactionId != null) {
            params.add("txid", transactionId);
        }
        return (R)this.postResource(reqlog, "documents", params, writeHandles.toArray(new AbstractWriteHandle[0]), headerList.toArray(new HashMap[0]), output);
    }

    @Override
    public EvalResultIterator postEvalInvoke(RequestLogger reqlog, String code, String modulePath, ServerEvaluationCallImpl.Context context, Map<String, Object> variables, EditableNamespaceContext namespaces, String transactionId) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        String formUrlEncodedPayload;
        String path;
        RequestParameters params = new RequestParameters();
        try {
            StringBuffer sb = new StringBuffer();
            if (context == ServerEvaluationCallImpl.Context.ADHOC_XQUERY) {
                path = "eval";
                sb.append("xquery=");
                sb.append(URLEncoder.encode(code, "UTF-8"));
            } else if (context == ServerEvaluationCallImpl.Context.ADHOC_JAVASCRIPT) {
                path = "eval";
                sb.append("javascript=");
                sb.append(URLEncoder.encode(code, "UTF-8"));
            } else if (context == ServerEvaluationCallImpl.Context.INVOKE) {
                path = "invoke";
                sb.append("module=");
                sb.append(URLEncoder.encode(modulePath, "UTF-8"));
            } else {
                throw new IllegalStateException("Invalid eval context: " + (Object)((Object)context));
            }
            if (variables != null && variables.size() > 0) {
                sb.append("&vars=");
                ObjectNode vars = new ObjectMapper().createObjectNode();
                for (String name : variables.keySet()) {
                    Object valueObject = variables.get(name);
                    if (namespaces != null) {
                        for (String prefix : namespaces.keySet()) {
                            if (name == null || prefix == null || !name.startsWith(prefix + ":")) continue;
                            name = "{" + namespaces.get(prefix) + "}" + name.substring(prefix.length() + 1);
                        }
                    }
                    if (valueObject == null) {
                        vars.putNull(name);
                        continue;
                    }
                    if (valueObject instanceof BigDecimal) {
                        vars.put(name, (BigDecimal)valueObject);
                        continue;
                    }
                    if (valueObject instanceof Double) {
                        vars.put(name, (Double)valueObject);
                        continue;
                    }
                    if (valueObject instanceof Float) {
                        vars.put(name, (Float)valueObject);
                        continue;
                    }
                    if (valueObject instanceof Integer) {
                        vars.put(name, (Integer)valueObject);
                        continue;
                    }
                    if (valueObject instanceof Long) {
                        vars.put(name, (Long)valueObject);
                        continue;
                    }
                    if (valueObject instanceof Short) {
                        vars.put(name, (Short)valueObject);
                        continue;
                    }
                    if (valueObject instanceof Number) {
                        vars.put(name, new BigDecimal(valueObject.toString()));
                        continue;
                    }
                    if (valueObject instanceof Boolean) {
                        vars.put(name, (Boolean)valueObject);
                        continue;
                    }
                    if (valueObject instanceof String) {
                        vars.put(name, (String)valueObject);
                        continue;
                    }
                    if (valueObject instanceof JacksonHandle) {
                        vars.set(name, ((JacksonHandle)valueObject).get());
                        continue;
                    }
                    if (valueObject instanceof JacksonParserHandle) {
                        vars.set(name, (JsonNode)((JacksonParserHandle)valueObject).get().readValueAs(JsonNode.class));
                        continue;
                    }
                    if (!(valueObject instanceof AbstractWriteHandle)) continue;
                    vars.put(name, HandleAccessor.contentAsString((AbstractWriteHandle)valueObject));
                }
                sb.append(URLEncoder.encode(vars.toString(), "UTF-8"));
            }
            formUrlEncodedPayload = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported", e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        if (transactionId != null) {
            params.add("txid", transactionId);
        }
        StringHandle input = new StringHandle(formUrlEncodedPayload).withMimetype("application/x-www-form-urlencoded");
        return new JerseyEvalResultIterator(this.postIteratedResourceImpl(DefaultJerseyResultIterator.class, reqlog, path, params, input, new String[0]));
    }

    @Override
    public ResourceServices.ServiceResultIterator postIteratedResource(RequestLogger reqlog, String path, RequestParameters params, AbstractWriteHandle input, String ... outputMimetypes) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        return this.postIteratedResourceImpl(JerseyServiceResultIterator.class, reqlog, path, params, input, outputMimetypes);
    }

    private <U extends JerseyResultIterator> U postIteratedResourceImpl(Class<U> clazz, RequestLogger reqlog, String path, RequestParameters params, AbstractWriteHandle input, String ... outputMimetypes) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        HandleImplementation inputBase = HandleAccessor.checkHandle(input, "write");
        String inputMimetype = inputBase.getMimetype();
        boolean isResendable = inputBase.isResendable();
        WebResource.Builder builder = this.makePostBuilder(path, params, inputMimetype, null);
        MediaType multipartType = Boundary.addBoundary((MediaType)MultiPartMediaTypes.MULTIPART_MIXED_TYPE);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            Object value = inputBase.sendContent();
            response = this.doPost(reqlog, (WebResource.Builder)builder.accept(new MediaType[]{multipartType}), value, !isResendable);
            status = response.getClientResponseStatus();
            if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (!isResendable) {
                this.checkFirstRequest();
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "apply", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        return this.makeResults(clazz, reqlog, "apply", "resource", response);
    }

    @Override
    public <W extends AbstractWriteHandle> ResourceServices.ServiceResultIterator postIteratedResource(RequestLogger reqlog, String path, RequestParameters params, W[] input, String ... outputMimetypes) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        return (ResourceServices.ServiceResultIterator)((Object)this.postIteratedResourceImpl(JerseyServiceResultIterator.class, reqlog, path, params, (AbstractWriteHandle[])input, outputMimetypes));
    }

    private <W extends AbstractWriteHandle, U extends JerseyResultIterator> U postIteratedResourceImpl(Class<U> clazz, RequestLogger reqlog, String path, RequestParameters params, W[] input, String ... outputMimetypes) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            MultiPart multiPart = new MultiPart();
            boolean hasStreamingPart = this.addParts(multiPart, reqlog, (AbstractWriteHandle[])input);
            WebResource.Builder builder = this.makePostBuilder(path, params, multiPart, (Object)Boundary.addBoundary((MediaType)MultiPartMediaTypes.MULTIPART_MIXED_TYPE));
            response = this.doPost(builder, multiPart, hasStreamingPart);
            status = response.getClientResponseStatus();
            if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            response.close();
            if (hasStreamingPart) {
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "apply", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        return this.makeResults(clazz, reqlog, "apply", "resource", response);
    }

    @Override
    public <R extends AbstractReadHandle> R deleteResource(RequestLogger reqlog, String path, RequestParameters params, R output) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        int retry;
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String outputMimeType = null;
        Class as = null;
        if (outputBase != null) {
            outputMimeType = outputBase.getMimetype();
            as = outputBase.receiveAs();
        }
        WebResource.Builder builder = this.makeDeleteBuilder(reqlog, path, params, outputMimeType);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = this.doDelete(builder)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "delete", "resource", path, RESTServices.ResponseStatus.OK_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "delete", "resource", response, as));
        } else {
            response.close();
        }
        return output;
    }

    private WebResource.Builder makeGetBuilder(String path, RequestParameters params, Object mimetype) {
        if (path == null) {
            throw new IllegalArgumentException("Read with null path");
        }
        WebResource.Builder builder = this.makeBuilder(path, this.convertParams(params), null, mimetype);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Getting %s as %s", path, mimetype));
        }
        return builder;
    }

    private ClientResponse doGet(WebResource.Builder builder) {
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private WebResource.Builder makePutBuilder(String path, RequestParameters params, String inputMimetype, String outputMimetype) {
        if (path == null) {
            throw new IllegalArgumentException("Write with null path");
        }
        WebResource.Builder builder = this.makeBuilder(path, this.convertParams(params), inputMimetype, outputMimetype);
        if (logger.isDebugEnabled()) {
            logger.debug("Putting {}", (Object)path);
        }
        return builder;
    }

    private ClientResponse doPut(RequestLogger reqlog, WebResource.Builder builder, Object value, boolean isStreaming) {
        if (value == null) {
            throw new IllegalArgumentException("Resource write with null value");
        }
        if (this.isFirstRequest() && this.isStreaming(value)) {
            this.makeFirstRequest(0);
        }
        ClientResponse response = null;
        response = value instanceof OutputStreamSender ? (ClientResponse)builder.put(ClientResponse.class, (Object)new StreamingOutputImpl((OutputStreamSender)value, reqlog)) : (reqlog != null ? (ClientResponse)builder.put(ClientResponse.class, reqlog.copyContent(value)) : (ClientResponse)builder.put(ClientResponse.class, value));
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private WebResource.Builder makePutBuilder(String path, RequestParameters params, MultiPart multiPart, String outputMimetype) {
        if (path == null) {
            throw new IllegalArgumentException("Write with null path");
        }
        WebResource.Builder builder = this.makeBuilder(path, this.convertParams(params), Boundary.addBoundary((MediaType)MultiPartMediaTypes.MULTIPART_MIXED_TYPE), outputMimetype);
        if (logger.isDebugEnabled()) {
            logger.debug("Putting multipart for {}", (Object)path);
        }
        return builder;
    }

    private ClientResponse doPut(WebResource.Builder builder, MultiPart multiPart, boolean hasStreamingPart) {
        if (this.isFirstRequest() && hasStreamingPart) {
            this.makeFirstRequest(0);
        }
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)multiPart);
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private WebResource.Builder makePostBuilder(String path, RequestParameters params, Object inputMimetype, Object outputMimetype) {
        if (path == null) {
            throw new IllegalArgumentException("Apply with null path");
        }
        WebResource.Builder builder = this.makeBuilder(path, this.convertParams(params), inputMimetype, outputMimetype);
        if (logger.isDebugEnabled()) {
            logger.debug("Posting {}", (Object)path);
        }
        return builder;
    }

    private ClientResponse doPost(RequestLogger reqlog, WebResource.Builder builder, Object value, boolean isStreaming) {
        if (this.isFirstRequest() && this.isStreaming(value)) {
            this.makeFirstRequest(0);
        }
        ClientResponse response = null;
        response = value instanceof OutputStreamSender ? (ClientResponse)builder.post(ClientResponse.class, (Object)new StreamingOutputImpl((OutputStreamSender)value, reqlog)) : (reqlog != null ? (ClientResponse)builder.post(ClientResponse.class, reqlog.copyContent(value)) : (ClientResponse)builder.post(ClientResponse.class, value));
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private WebResource.Builder makePostBuilder(String path, RequestParameters params, MultiPart multiPart, Object outputMimetype) {
        if (path == null) {
            throw new IllegalArgumentException("Apply with null path");
        }
        WebResource.Builder builder = this.makeBuilder(path, this.convertParams(params), Boundary.addBoundary((MediaType)MultiPartMediaTypes.MULTIPART_MIXED_TYPE), outputMimetype);
        if (logger.isDebugEnabled()) {
            logger.debug("Posting multipart for {}", (Object)path);
        }
        return builder;
    }

    private ClientResponse doPost(WebResource.Builder builder, MultiPart multiPart, boolean hasStreamingPart) {
        if (this.isFirstRequest() && hasStreamingPart) {
            this.makeFirstRequest(0);
        }
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)multiPart);
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private WebResource.Builder makeDeleteBuilder(RequestLogger reqlog, String path, RequestParameters params, String mimetype) {
        if (path == null) {
            throw new IllegalArgumentException("Delete with null path");
        }
        WebResource.Builder builder = this.makeBuilder(path, this.convertParams(params), null, mimetype);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting {}", (Object)path);
        }
        return builder;
    }

    private ClientResponse doDelete(WebResource.Builder builder) {
        ClientResponse response = (ClientResponse)builder.delete(ClientResponse.class);
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private MultivaluedMap<String, String> convertParams(RequestParameters params) {
        if (params == null || params.size() == 0) {
            return null;
        }
        MultivaluedMapImpl requestParams = new MultivaluedMapImpl();
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            this.addEncodedParam((MultivaluedMap<String, String>)requestParams, entry.getKey(), entry.getValue());
        }
        return requestParams;
    }

    private void addEncodedParam(MultivaluedMap<String, String> params, String key, List<String> values) {
        List<String> encodedParams = this.encodeParamValues(values);
        if (encodedParams != null && encodedParams.size() > 0) {
            params.put((Object)key, encodedParams);
        }
    }

    private void addEncodedParam(MultivaluedMap<String, String> params, String key, String[] values) {
        List<String> encodedParams = this.encodeParamValues(values);
        if (encodedParams != null && encodedParams.size() > 0) {
            params.put((Object)key, encodedParams);
        }
    }

    private void addEncodedParam(MultivaluedMap<String, String> params, String key, String value) {
        if ((value = this.encodeParamValue(value)) == null) {
            return;
        }
        params.add((Object)key, (Object)value);
    }

    private List<String> encodeParamValues(List<String> oldValues) {
        if (oldValues == null) {
            return null;
        }
        int oldSize = oldValues.size();
        if (oldSize == 0) {
            return null;
        }
        ArrayList<String> newValues = new ArrayList<String>(oldSize);
        for (String value : oldValues) {
            String newValue = this.encodeParamValue(value);
            if (newValue == null) continue;
            newValues.add(newValue);
        }
        return newValues;
    }

    private List<String> encodeParamValues(String[] oldValues) {
        if (oldValues == null) {
            return null;
        }
        int oldSize = oldValues.length;
        if (oldSize == 0) {
            return null;
        }
        ArrayList<String> newValues = new ArrayList<String>(oldSize);
        for (String value : oldValues) {
            String newValue = this.encodeParamValue(value);
            if (newValue == null) continue;
            newValues.add(newValue);
        }
        return newValues;
    }

    private String encodeParamValue(String value) {
        if (value == null) {
            return null;
        }
        return UriComponent.encode((String)value, (UriComponent.Type)UriComponent.Type.QUERY_PARAM).replace("+", "%20");
    }

    private <W extends AbstractWriteHandle> boolean addParts(MultiPart multiPart, RequestLogger reqlog, W[] input) {
        return this.addParts(multiPart, reqlog, null, (AbstractWriteHandle[])input, null);
    }

    private <W extends AbstractWriteHandle> boolean addParts(MultiPart multiPart, RequestLogger reqlog, String[] mimetypes, W[] input) {
        return this.addParts(multiPart, reqlog, null, (AbstractWriteHandle[])input, null);
    }

    private <W extends AbstractWriteHandle> boolean addParts(MultiPart multiPart, RequestLogger reqlog, String[] mimetypes, W[] input, Map<String, List<String>>[] headers) {
        if (mimetypes != null && mimetypes.length != input.length) {
            throw new IllegalArgumentException("Mismatch between count of mimetypes and input");
        }
        if (headers != null && headers.length != input.length) {
            throw new IllegalArgumentException("Mismatch between count of headers and input");
        }
        multiPart.setMediaType(new MediaType("multipart", "mixed"));
        boolean hasStreamingPart = false;
        for (int i = 0; i < input.length; ++i) {
            W handle = input[i];
            HandleImplementation handleBase = HandleAccessor.checkHandle(handle, "write");
            if (!hasStreamingPart) {
                hasStreamingPart = !handleBase.isResendable();
            }
            Object value = handleBase.sendContent();
            String inputMimetype = null;
            if (mimetypes != null) {
                inputMimetype = mimetypes[i];
            }
            if (inputMimetype == null && headers != null) {
                inputMimetype = this.getHeaderMimetype(headers[i]);
            }
            if (inputMimetype == null) {
                inputMimetype = handleBase.getMimetype();
            }
            String[] typeParts = inputMimetype != null && inputMimetype.contains("/") ? inputMimetype.split("/", 2) : null;
            MediaType typePart = typeParts != null ? new MediaType(typeParts[0], typeParts[1]) : MediaType.WILDCARD_TYPE;
            BodyPart bodyPart = null;
            bodyPart = value instanceof OutputStreamSender ? new BodyPart((Object)new StreamingOutputImpl((OutputStreamSender)value, reqlog), typePart) : (reqlog != null ? new BodyPart(reqlog.copyContent(value), typePart) : new BodyPart(value, typePart));
            if (headers != null) {
                MultivaluedMap mutableHeaders = bodyPart.getHeaders();
                mutableHeaders.putAll(headers[i]);
            }
            multiPart = multiPart.bodyPart(bodyPart);
        }
        return hasStreamingPart;
    }

    private WebResource.Builder makeBuilder(String path, MultivaluedMap<String, String> params, Object inputMimetype, Object outputMimetype) {
        if (params == null) {
            params = new MultivaluedMapImpl();
        }
        if (this.database != null) {
            this.addEncodedParam((MultivaluedMap<String, String>)params, "database", this.database);
        }
        WebResource resource = this.getConnection().path(path).queryParams((MultivaluedMap)params);
        WebResource.Builder builder = resource.getRequestBuilder();
        if (inputMimetype != null) {
            if (inputMimetype instanceof String) {
                builder = (WebResource.Builder)builder.type((String)inputMimetype);
            } else if (inputMimetype instanceof MediaType) {
                builder = (WebResource.Builder)builder.type((MediaType)inputMimetype);
            } else {
                throw new IllegalArgumentException("Unknown input mimetype specifier " + inputMimetype.getClass().getName());
            }
        }
        if (outputMimetype != null) {
            if (outputMimetype instanceof String) {
                builder = (WebResource.Builder)builder.accept(new String[]{(String)outputMimetype});
            } else if (outputMimetype instanceof MediaType) {
                builder = (WebResource.Builder)builder.accept(new MediaType[]{(MediaType)outputMimetype});
            } else {
                throw new IllegalArgumentException("Unknown output mimetype specifier " + outputMimetype.getClass().getName());
            }
        }
        return builder;
    }

    private void checkStatus(ClientResponse response, ClientResponse.Status status, String operation, String entityType, String path, RESTServices.ResponseStatus expected) {
        if (!expected.isExpected(status)) {
            if (status == ClientResponse.Status.NOT_FOUND) {
                throw new ResourceNotFoundException("Could not " + operation + " " + entityType + " at " + path, this.extractErrorFields(response));
            }
            if (status == ClientResponse.Status.FORBIDDEN) {
                throw new ForbiddenUserException("User is not allowed to " + operation + " " + entityType + " at " + path, this.extractErrorFields(response));
            }
            throw new FailedRequestException("failed to " + operation + " " + entityType + " at " + path + ": " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
    }

    private <T> T makeResult(RequestLogger reqlog, String operation, String entityType, ClientResponse response, Class<T> as) {
        Object entity;
        if (as == null) {
            return null;
        }
        this.logRequest(reqlog, "%s for %s", operation, entityType);
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            response.close();
        }
        return (T)(reqlog != null ? reqlog.copyContent(entity) : entity);
    }

    private <U extends JerseyResultIterator> U makeResults(Class<U> clazz, RequestLogger reqlog, String operation, String entityType, ClientResponse response) {
        if (response == null) {
            return null;
        }
        MultiPart entity = response.hasEntity() ? (MultiPart)response.getEntity(MultiPart.class) : null;
        List partList = entity == null ? null : entity.getBodyParts();
        MultipartCloseable closeable = new MultipartCloseable(response, entity);
        return this.makeResults(clazz, reqlog, operation, entityType, partList, response, closeable);
    }

    private <U extends JerseyResultIterator> U makeResults(Class<U> clazz, RequestLogger reqlog, String operation, String entityType, List<BodyPart> partList, ClientResponse response, Closeable closeable) {
        this.logRequest(reqlog, "%s for %s", operation, entityType);
        if (response == null) {
            return null;
        }
        try {
            Constructor<U> constructor = clazz.getConstructor(JerseyServices.class, RequestLogger.class, List.class, Closeable.class);
            JerseyResultIterator result = (JerseyResultIterator)constructor.newInstance(this, reqlog, partList, closeable);
            MultivaluedMap headers = response.getHeaders();
            if (headers.containsKey((Object)"vnd.marklogic.start")) {
                result.setStart(Long.parseLong((String)((List)headers.get((Object)"vnd.marklogic.start")).get(0)));
            }
            if (headers.containsKey((Object)"vnd.marklogic.pageLength")) {
                result.setPageSize(Long.parseLong((String)((List)headers.get((Object)"vnd.marklogic.pageLength")).get(0)));
            }
            if (headers.containsKey((Object)"vnd.marklogic.result-estimate")) {
                result.setTotalSize(Long.parseLong((String)((List)headers.get((Object)"vnd.marklogic.result-estimate")).get(0)));
            }
            return (U)result;
        }
        catch (Throwable t) {
            throw new MarkLogicInternalException("Error instantiating " + clazz.getName(), t);
        }
    }

    private boolean isStreaming(Object value) {
        return !(value instanceof String) && !(value instanceof byte[]) && !(value instanceof File);
    }

    private void logRequest(RequestLogger reqlog, String message, Object ... params) {
        if (reqlog == null) {
            return;
        }
        PrintStream out = reqlog.getPrintStream();
        if (out == null) {
            return;
        }
        if (params == null || params.length == 0) {
            out.println(message);
        } else {
            out.format(message, params);
            out.println();
        }
    }

    private String stringJoin(Collection collection, String separator, String defaultValue) {
        if (collection == null || collection.size() == 0) {
            return defaultValue;
        }
        StringBuilder builder = null;
        for (Object value : collection) {
            if (builder == null) {
                builder = new StringBuilder();
            } else {
                builder.append(separator);
            }
            builder.append(value);
        }
        return builder != null ? builder.toString() : null;
    }

    private int calculateDelay(Random rand, int i) {
        int min;
        int n = i > 6 ? 2000 : (min = i == 0 ? 125 : 125 + (1 << i) * 20);
        int range = i > 6 ? 125 : (i == 0 ? 40 : (i == 6 ? 2000 - min : (1 << i) * 20));
        return min + this.randRetry.nextInt(range);
    }

    public HttpClient getClientImplementation() {
        if (this.client == null) {
            return null;
        }
        return this.client.getClientHandler().getHttpClient();
    }

    @Override
    public <T> T suggest(Class<T> as, SuggestDefinition suggestionDef) {
        Object entity;
        int retry;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        String suggestCriteria = suggestionDef.getStringCriteria();
        String[] queries = suggestionDef.getQueryStrings();
        String optionsName = suggestionDef.getOptionsName();
        Integer limit = suggestionDef.getLimit();
        Integer cursorPosition = suggestionDef.getCursorPosition();
        if (suggestCriteria != null) {
            params.add((Object)"partial-q", (Object)suggestCriteria);
        }
        if (optionsName != null) {
            params.add((Object)"options", (Object)optionsName);
        }
        if (limit != null) {
            params.add((Object)"limit", (Object)Long.toString(limit.intValue()));
        }
        if (cursorPosition != null) {
            params.add((Object)"cursor-position", (Object)Long.toString(cursorPosition.intValue()));
        }
        if (queries != null) {
            for (String stringQuery : queries) {
                params.add((Object)"q", (Object)stringQuery);
            }
        }
        WebResource.Builder builder = null;
        builder = this.getConnection().path("suggest").queryParams((MultivaluedMap)params).accept(new String[]{"application/xml"});
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = (ClientResponse)builder.get(ClientResponse.class)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to get suggestions", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException("Suggest call failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        Object object = entity = response.hasEntity() ? response.getEntity(as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            response.close();
        }
        return (T)entity;
    }

    @Override
    public InputStream match(StructureWriteHandle document, String[] candidateRules, String mimeType, ServerTransform transform) {
        InputStream entity;
        int retry;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        HandleImplementation baseHandle = HandleAccessor.checkHandle(document, "match");
        if (candidateRules.length > 0) {
            for (String candidateRule : candidateRules) {
                params.add((Object)"rule", (Object)candidateRule);
            }
        }
        if (transform != null) {
            transform.merge((Map<String, List<String>>)params);
        }
        WebResource.Builder builder = null;
        builder = (WebResource.Builder)this.getConnection().path("alert/match").queryParams((MultivaluedMap)params).accept(new String[]{"application/xml"}).type(mimeType);
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = this.doPost(null, builder, baseHandle.sendContent(), false)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to match", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException("match failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        InputStream inputStream = entity = response.hasEntity() ? (InputStream)response.getEntity(InputStream.class) : null;
        if (entity == null) {
            response.close();
        }
        return entity;
    }

    @Override
    public InputStream match(QueryDefinition queryDef, long start, long pageLength, String[] candidateRules, ServerTransform transform) {
        InputStream entity;
        int retry;
        if (queryDef == null) {
            throw new IllegalArgumentException("Cannot match null query");
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (start > 1L) {
            params.add((Object)"start", (Object)Long.toString(start));
        }
        if (pageLength >= 0L) {
            params.add((Object)"pageLength", (Object)Long.toString(pageLength));
        }
        if (transform != null) {
            transform.merge((Map<String, List<String>>)params);
        }
        if (candidateRules.length > 0) {
            for (String candidateRule : candidateRules) {
                params.add((Object)"rule", (Object)candidateRule);
            }
        }
        if (queryDef.getOptionsName() != null) {
            params.add((Object)"options", (Object)queryDef.getOptionsName());
        }
        WebResource.Builder builder = null;
        String structure = null;
        HandleImplementation baseHandle = null;
        if (queryDef instanceof RawQueryDefinition) {
            StructureWriteHandle handle = ((RawQueryDefinition)queryDef).getHandle();
            baseHandle = HandleAccessor.checkHandle(handle, "match");
            if (logger.isDebugEnabled()) {
                logger.debug("Searching for structure {}", (Object)structure);
            }
            builder = (WebResource.Builder)this.getConnection().path("alert/match").queryParams((MultivaluedMap)params).type("application/xml").accept(new String[]{"application/xml"});
        } else if (queryDef instanceof StringQueryDefinition) {
            String text = ((StringQueryDefinition)queryDef).getCriteria();
            if (logger.isDebugEnabled()) {
                logger.debug("Searching for {} in transaction {}", (Object)text);
            }
            if (text != null) {
                this.addEncodedParam((MultivaluedMap<String, String>)params, "q", text);
            }
            builder = this.getConnection().path("alert/match").queryParams((MultivaluedMap)params).accept(new String[]{"application/xml"});
        } else if (queryDef instanceof StructuredQueryDefinition) {
            structure = ((StructuredQueryDefinition)queryDef).serialize();
            if (logger.isDebugEnabled()) {
                logger.debug("Searching for structure {} in transaction {}", (Object)structure);
            }
            builder = (WebResource.Builder)this.getConnection().path("alert/match").queryParams((MultivaluedMap)params).type("application/xml").accept(new String[]{"application/xml"});
        } else {
            throw new UnsupportedOperationException("Cannot match with " + queryDef.getClass().getName());
        }
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (queryDef instanceof StringQueryDefinition) {
                response = (ClientResponse)builder.get(ClientResponse.class);
            } else if (queryDef instanceof StructuredQueryDefinition) {
                response = (ClientResponse)builder.post(ClientResponse.class, (Object)structure);
            } else if (queryDef instanceof RawQueryDefinition) {
                response = this.doPost(null, builder, baseHandle.sendContent(), false);
            } else {
                throw new UnsupportedOperationException("Cannot match with " + queryDef.getClass().getName());
            }
            status = response.getClientResponseStatus();
            if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to match", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException("match failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        InputStream inputStream = entity = response.hasEntity() ? (InputStream)response.getEntity(InputStream.class) : null;
        if (entity == null) {
            response.close();
        }
        return entity;
    }

    @Override
    public InputStream match(String[] docIds, String[] candidateRules, ServerTransform transform) {
        InputStream entity;
        int retry;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (docIds.length > 0) {
            for (String docId : docIds) {
                params.add((Object)"uri", (Object)docId);
            }
        }
        if (candidateRules.length > 0) {
            for (String candidateRule : candidateRules) {
                params.add((Object)"rule", (Object)candidateRule);
            }
        }
        if (transform != null) {
            transform.merge((Map<String, List<String>>)params);
        }
        WebResource.Builder builder = this.getConnection().path("alert/match").queryParams((MultivaluedMap)params).accept(new String[]{"application/xml"});
        ClientResponse response = null;
        ClientResponse.Status status = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((status = (response = this.doGet(builder)).getClientResponseStatus()) != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            MultivaluedMap responseHeaders = response.getHeaders();
            String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
            response.close();
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            this.checkFirstRequest();
            throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
        }
        if (status == ClientResponse.Status.FORBIDDEN) {
            throw new ForbiddenUserException("User is not allowed to match", this.extractErrorFields(response));
        }
        if (status != ClientResponse.Status.OK) {
            throw new FailedRequestException("match failed: " + status.getReasonPhrase(), this.extractErrorFields(response));
        }
        InputStream inputStream = entity = response.hasEntity() ? (InputStream)response.getEntity(InputStream.class) : null;
        if (entity == null) {
            response.close();
        }
        return entity;
    }

    public class JerseyDocumentRecord
    implements DocumentRecord {
        private JerseyResult content;
        private JerseyResult metadata;

        public JerseyDocumentRecord(JerseyResult content, JerseyResult metadata) {
            this.content = content;
            this.metadata = metadata;
        }

        public JerseyDocumentRecord(JerseyResult content) {
            this.content = content;
        }

        @Override
        public String getUri() {
            if (this.content == null && this.metadata != null) {
                return this.metadata.getUri();
            }
            if (this.content != null) {
                return this.content.getUri();
            }
            throw new IllegalStateException("Missing both content and metadata!");
        }

        @Override
        public Format getFormat() {
            return this.content.getFormat();
        }

        @Override
        public String getMimetype() {
            return this.content.getMimetype();
        }

        @Override
        public <T extends DocumentMetadataReadHandle> T getMetadata(T metadataHandle) {
            if (this.metadata == null) {
                throw new IllegalStateException("getMetadata called when no metadata is available");
            }
            return this.metadata.getContent(metadataHandle);
        }

        @Override
        public <T extends AbstractReadHandle> T getContent(T contentHandle) {
            if (this.content == null) {
                throw new IllegalStateException("getContent called when no content is available");
            }
            return this.content.getContent(contentHandle);
        }
    }

    public class DefaultJerseyResultIterator
    extends JerseyResultIterator<JerseyResult>
    implements Iterator<JerseyResult> {
        public DefaultJerseyResultIterator(RequestLogger reqlog, List<BodyPart> partList, Closeable closeable) {
            super(reqlog, partList, JerseyResult.class, closeable);
        }
    }

    public class JerseyServiceResultIterator
    extends JerseyResultIterator<JerseyServiceResult>
    implements ResourceServices.ServiceResultIterator {
        public JerseyServiceResultIterator(RequestLogger reqlog, List<BodyPart> partList, Closeable closeable) {
            super(reqlog, partList, JerseyServiceResult.class, closeable);
        }
    }

    public class JerseyResultIterator<T extends JerseyResult> {
        private RequestLogger reqlog;
        private Iterator<BodyPart> partQueue;
        private Class<T> clazz;
        private long start = -1L;
        private long size = -1L;
        private long pageSize = -1L;
        private long totalSize = -1L;
        private Closeable closeable;

        public JerseyResultIterator(RequestLogger reqlog, List<BodyPart> partList, Class<T> clazz, Closeable closeable) {
            this.clazz = clazz;
            this.reqlog = reqlog;
            if (partList != null && partList.size() > 0) {
                this.size = partList.size();
                this.partQueue = new ConcurrentLinkedQueue<BodyPart>(partList).iterator();
            } else {
                this.size = 0L;
            }
            this.closeable = closeable;
        }

        public long getStart() {
            return this.start;
        }

        public JerseyResultIterator<T> setStart(long start) {
            this.start = start;
            return this;
        }

        public long getSize() {
            return this.size;
        }

        public JerseyResultIterator<T> setSize(long size) {
            this.size = new Long(size);
            return this;
        }

        public long getPageSize() {
            return this.pageSize;
        }

        public JerseyResultIterator<T> setPageSize(long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public JerseyResultIterator<T> setTotalSize(long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public boolean hasNext() {
            if (this.partQueue == null) {
                return false;
            }
            boolean hasNext = this.partQueue.hasNext();
            return hasNext;
        }

        public T next() {
            if (this.partQueue == null) {
                return null;
            }
            try {
                Constructor<T> constructor = this.clazz.getConstructor(JerseyServices.class, RequestLogger.class, BodyPart.class);
                return (T)((JerseyResult)constructor.newInstance(new JerseyServices(), this.reqlog, this.partQueue.next()));
            }
            catch (Throwable t) {
                throw new IllegalStateException("Error instantiating " + this.clazz.getName());
            }
        }

        public void remove() {
            if (this.partQueue == null) {
                return;
            }
            this.partQueue.remove();
            if (!this.partQueue.hasNext()) {
                this.close();
            }
        }

        public void close() {
            this.partQueue = null;
            this.reqlog = null;
            if (this.closeable != null) {
                try {
                    this.closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public class JerseyServiceResult
    extends JerseyResult
    implements ResourceServices.ServiceResult {
        public JerseyServiceResult(RequestLogger reqlog, BodyPart part) {
            super(reqlog, part);
        }
    }

    public class JerseyResult {
        private RequestLogger reqlog;
        private BodyPart part;
        private boolean extractedHeaders = false;
        private MultivaluedMap<String, String> headers = null;
        private String uri;
        private Format format;
        private String mimetype;
        private long length;

        public JerseyResult(RequestLogger reqlog, BodyPart part) {
            this.reqlog = reqlog;
            this.part = part;
        }

        public <T> T getEntityAs(Class<T> clazz) {
            return (T)this.part.getEntityAs(clazz);
        }

        public <R extends AbstractReadHandle> R getContent(R handle) {
            if (this.part == null) {
                throw new IllegalStateException("Content already retrieved");
            }
            HandleImplementation handleBase = HandleAccessor.as(handle);
            this.extractHeaders();
            JerseyServices.this.updateFormat(handleBase, this.format);
            JerseyServices.this.updateMimetype(handleBase, this.mimetype);
            JerseyServices.this.updateLength(handleBase, this.length);
            Object contentEntity = this.part.getEntityAs(handleBase.receiveAs());
            handleBase.receiveContent(this.reqlog != null ? this.reqlog.copyContent(contentEntity) : contentEntity);
            this.part = null;
            this.reqlog = null;
            return handle;
        }

        public <T> T getContentAs(Class<T> clazz) {
            ContentHandle<T> readHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(clazz);
            if ((readHandle = this.getContent(readHandle)) == null) {
                return null;
            }
            return readHandle.get();
        }

        public String getUri() {
            this.extractHeaders();
            return this.uri;
        }

        public Format getFormat() {
            this.extractHeaders();
            return this.format;
        }

        public String getMimetype() {
            this.extractHeaders();
            return this.mimetype;
        }

        public long getLength() {
            this.extractHeaders();
            return this.length;
        }

        public String getHeader(String name) {
            this.extractHeaders();
            return (String)this.headers.getFirst((Object)name);
        }

        private void extractHeaders() {
            if (this.part == null || this.extractedHeaders) {
                return;
            }
            this.headers = this.part.getHeaders();
            this.format = JerseyServices.this.getHeaderFormat(this.part);
            this.mimetype = JerseyServices.this.getHeaderMimetype(this.headers);
            this.length = JerseyServices.this.getHeaderLength((MultivaluedMap<String, String>)this.headers);
            this.uri = JerseyServices.this.getHeaderUri(this.part.getContentDisposition());
            this.extractedHeaders = true;
        }
    }

    public class MultipartCloseable
    implements Closeable {
        private ClientResponse response;
        private MultiPart multiPart;

        public MultipartCloseable(ClientResponse response, MultiPart multiPart) {
            this.response = response;
            this.multiPart = multiPart;
        }

        @Override
        public void close() throws IOException {
            if (this.multiPart != null) {
                this.multiPart.close();
            }
            if (this.response != null) {
                this.response.close();
            }
        }
    }

    public class JerseyEvalResult
    implements EvalResult {
        private JerseyResult content;

        public JerseyEvalResult(JerseyResult content) {
            this.content = content;
        }

        @Override
        public Format getFormat() {
            return this.content.getFormat();
        }

        @Override
        public EvalResult.Type getType() {
            String xPrimitive;
            String contentType = this.content.getHeader("Content-Type");
            if (contentType != null) {
                if ("application/json".equals(contentType)) {
                    return EvalResult.Type.JSON;
                }
                if ("text/json".equals(contentType)) {
                    return EvalResult.Type.JSON;
                }
                if ("application/xml".equals(contentType)) {
                    return EvalResult.Type.XML;
                }
                if ("text/xml".equals(contentType)) {
                    return EvalResult.Type.XML;
                }
                if ("application/x-unknown-content-type".equals(contentType) && "binary()".equals(this.content.getHeader("X-Primitive"))) {
                    return EvalResult.Type.BINARY;
                }
                if ("application/octet-stream".equals(contentType) && "node()".equals(this.content.getHeader("X-Primitive"))) {
                    return EvalResult.Type.BINARY;
                }
            }
            if ((xPrimitive = this.content.getHeader("X-Primitive")) == null) {
                return EvalResult.Type.OTHER;
            }
            if ("string".equals(xPrimitive) || "untypedAtomic".equals(xPrimitive)) {
                return EvalResult.Type.STRING;
            }
            if ("boolean".equals(xPrimitive)) {
                return EvalResult.Type.BOOLEAN;
            }
            if ("attribute()".equals(xPrimitive)) {
                return EvalResult.Type.ATTRIBUTE;
            }
            if ("comment()".equals(xPrimitive)) {
                return EvalResult.Type.COMMENT;
            }
            if ("processing-instruction()".equals(xPrimitive)) {
                return EvalResult.Type.PROCESSINGINSTRUCTION;
            }
            if ("text()".equals(xPrimitive)) {
                return EvalResult.Type.TEXTNODE;
            }
            if ("binary()".equals(xPrimitive)) {
                return EvalResult.Type.BINARY;
            }
            if ("duration".equals(xPrimitive)) {
                return EvalResult.Type.DURATION;
            }
            if ("date".equals(xPrimitive)) {
                return EvalResult.Type.DATE;
            }
            if ("anyURI".equals(xPrimitive)) {
                return EvalResult.Type.ANYURI;
            }
            if ("hexBinary".equals(xPrimitive)) {
                return EvalResult.Type.HEXBINARY;
            }
            if ("base64Binary".equals(xPrimitive)) {
                return EvalResult.Type.BASE64BINARY;
            }
            if ("dateTime".equals(xPrimitive)) {
                return EvalResult.Type.DATETIME;
            }
            if ("decimal".equals(xPrimitive)) {
                return EvalResult.Type.DECIMAL;
            }
            if ("double".equals(xPrimitive)) {
                return EvalResult.Type.DOUBLE;
            }
            if ("float".equals(xPrimitive)) {
                return EvalResult.Type.FLOAT;
            }
            if ("gDay".equals(xPrimitive)) {
                return EvalResult.Type.GDAY;
            }
            if ("gMonth".equals(xPrimitive)) {
                return EvalResult.Type.GMONTH;
            }
            if ("gMonthDay".equals(xPrimitive)) {
                return EvalResult.Type.GMONTHDAY;
            }
            if ("gYear".equals(xPrimitive)) {
                return EvalResult.Type.GYEAR;
            }
            if ("gYearMonth".equals(xPrimitive)) {
                return EvalResult.Type.GYEARMONTH;
            }
            if ("integer".equals(xPrimitive)) {
                return EvalResult.Type.INTEGER;
            }
            if ("QName".equals(xPrimitive)) {
                return EvalResult.Type.QNAME;
            }
            if ("time".equals(xPrimitive)) {
                return EvalResult.Type.TIME;
            }
            if ("null".equals(xPrimitive)) {
                return EvalResult.Type.NULL;
            }
            return EvalResult.Type.OTHER;
        }

        @Override
        public <H extends AbstractReadHandle> H get(H handle) {
            return this.content.getContent(handle);
        }

        @Override
        public <T> T getAs(Class<T> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("clazz cannot be null");
            }
            ContentHandle<T> readHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(clazz);
            if (readHandle == null) {
                return null;
            }
            if ((readHandle = this.get(readHandle)) == null) {
                return null;
            }
            return readHandle.get();
        }

        @Override
        public String getString() {
            return this.content.getEntityAs(String.class);
        }

        @Override
        public Number getNumber() {
            if (this.getType() == EvalResult.Type.DECIMAL) {
                return new BigDecimal(this.getString());
            }
            if (this.getType() == EvalResult.Type.DOUBLE) {
                return new Double(this.getString());
            }
            if (this.getType() == EvalResult.Type.FLOAT) {
                return new Float(this.getString());
            }
            if (this.getType() == EvalResult.Type.INTEGER) {
                return new Long(this.getString());
            }
            return new BigDecimal(this.getString());
        }

        @Override
        public Boolean getBoolean() {
            return new Boolean(this.getString());
        }
    }

    public class JerseyEvalResultIterator
    implements EvalResultIterator {
        private JerseyResultIterator iterator;

        JerseyEvalResultIterator(JerseyResultIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<EvalResult> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EvalResult next() {
            if (this.iterator == null) {
                throw new NoSuchElementException("No results available");
            }
            Object jerseyResult = this.iterator.next();
            JerseyEvalResult result = new JerseyEvalResult((JerseyResult)jerseyResult);
            return result;
        }

        @Override
        public void close() {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
    }

    private class JerseySearchRequest {
        RequestLogger reqlog;
        QueryDefinition queryDef;
        String mimetype;
        MultivaluedMap<String, String> params;
        WebResource.Builder builder = null;
        String structure = null;
        HandleImplementation baseHandle = null;

        JerseySearchRequest(RequestLogger reqlog, QueryDefinition queryDef, String mimetype, MultivaluedMap<String, String> params) {
            this.reqlog = reqlog;
            this.queryDef = queryDef;
            this.mimetype = mimetype;
            this.params = params != null ? params : new MultivaluedMapImpl();
            this.addParams();
            this.init();
        }

        void addParams() {
            ServerTransform transform;
            String directory = this.queryDef.getDirectory();
            if (directory != null) {
                JerseyServices.this.addEncodedParam((MultivaluedMap<String, String>)this.params, "directory", directory);
            }
            JerseyServices.this.addEncodedParam((MultivaluedMap<String, String>)this.params, "collection", this.queryDef.getCollections());
            String optionsName = this.queryDef.getOptionsName();
            if (optionsName != null && optionsName.length() > 0) {
                JerseyServices.this.addEncodedParam((MultivaluedMap<String, String>)this.params, "options", optionsName);
            }
            if ((transform = this.queryDef.getResponseTransform()) != null) {
                transform.merge((Map<String, List<String>>)this.params);
            }
        }

        void init() {
            if (this.queryDef instanceof RawQueryDefinition) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Raw search");
                }
                StructureWriteHandle handle = ((RawQueryDefinition)this.queryDef).getHandle();
                this.baseHandle = HandleAccessor.checkHandle(handle, "search");
                Format payloadFormat = this.baseHandle.getFormat();
                if (payloadFormat == Format.UNKNOWN) {
                    payloadFormat = null;
                } else if (payloadFormat != Format.XML && payloadFormat != Format.JSON) {
                    throw new IllegalArgumentException("Cannot perform raw search for " + payloadFormat.name());
                }
                String payloadMimetype = this.baseHandle.getMimetype();
                if (payloadFormat != null) {
                    if (payloadMimetype == null) {
                        payloadMimetype = payloadFormat.getDefaultMimetype();
                    }
                } else if (payloadMimetype == null) {
                    payloadMimetype = "application/xml";
                }
                String path = this.queryDef instanceof RawQueryByExampleDefinition ? "qbe" : "search";
                WebResource resource = JerseyServices.this.getConnection().path(path).queryParams(this.params);
                this.builder = payloadMimetype != null ? (WebResource.Builder)resource.type(payloadMimetype).accept(new String[]{this.mimetype}) : resource.accept(new String[]{this.mimetype});
            } else if (this.queryDef instanceof StringQueryDefinition) {
                String text = ((StringQueryDefinition)this.queryDef).getCriteria();
                if (logger.isDebugEnabled()) {
                    logger.debug("Searching for {}", (Object)text);
                }
                if (text != null) {
                    JerseyServices.this.addEncodedParam((MultivaluedMap<String, String>)this.params, "q", text);
                }
                this.builder = (WebResource.Builder)JerseyServices.this.getConnection().path("search").queryParams(this.params).type("application/xml").accept(new String[]{this.mimetype});
            } else if (this.queryDef instanceof KeyValueQueryDefinition) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Searching for keys/values");
                }
                KeyValueQueryDefinition pairs = (KeyValueQueryDefinition)this.queryDef;
                for (Map.Entry entry : pairs.entrySet()) {
                    ValueLocator loc = (ValueLocator)entry.getKey();
                    if (loc instanceof KeyLocator) {
                        JerseyServices.this.addEncodedParam((MultivaluedMap<String, String>)this.params, "key", ((KeyLocator)loc).getKey());
                    } else {
                        ElementLocator eloc = (ElementLocator)loc;
                        this.params.add((Object)"element", (Object)eloc.getElement().toString());
                        if (eloc.getAttribute() != null) {
                            this.params.add((Object)"attribute", (Object)eloc.getAttribute().toString());
                        }
                    }
                    JerseyServices.this.addEncodedParam((MultivaluedMap<String, String>)this.params, "value", (String)entry.getValue());
                }
                this.builder = JerseyServices.this.getConnection().path("keyvalue").queryParams(this.params).accept(new String[]{this.mimetype});
            } else if (this.queryDef instanceof StructuredQueryDefinition) {
                this.structure = ((StructuredQueryDefinition)this.queryDef).serialize();
                if (logger.isDebugEnabled()) {
                    logger.debug("Searching for structure {}", (Object)this.structure);
                }
                this.builder = (WebResource.Builder)JerseyServices.this.getConnection().path("search").queryParams(this.params).type("application/xml").accept(new String[]{this.mimetype});
            } else if (this.queryDef instanceof CombinedQueryDefinition) {
                this.structure = ((CombinedQueryDefinition)this.queryDef).serialize();
                if (logger.isDebugEnabled()) {
                    logger.debug("Searching for combined query {}", (Object)this.structure);
                }
                this.builder = (WebResource.Builder)JerseyServices.this.getConnection().path("search").queryParams(this.params).type("application/xml").accept(new String[]{this.mimetype});
            } else if (this.queryDef instanceof DeleteQueryDefinition) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Searching for deletes");
                }
                this.builder = JerseyServices.this.getConnection().path("search").queryParams(this.params).accept(new String[]{this.mimetype});
            } else {
                throw new UnsupportedOperationException("Cannot search with " + this.queryDef.getClass().getName());
            }
        }

        ClientResponse getResponse() {
            int retry;
            ClientResponse response = null;
            ClientResponse.Status status = null;
            long startTime = System.currentTimeMillis();
            int nextDelay = 0;
            for (retry = 0; retry < JerseyServices.this.minRetry || System.currentTimeMillis() - startTime < (long)JerseyServices.this.maxDelay; ++retry) {
                if (nextDelay > 0) {
                    try {
                        Thread.sleep(nextDelay);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.queryDef instanceof StringQueryDefinition) {
                    response = JerseyServices.this.doGet(this.builder);
                } else if (this.queryDef instanceof KeyValueQueryDefinition) {
                    response = JerseyServices.this.doGet(this.builder);
                } else if (this.queryDef instanceof StructuredQueryDefinition) {
                    response = JerseyServices.this.doPost(this.reqlog, this.builder, this.structure, true);
                } else if (this.queryDef instanceof CombinedQueryDefinition) {
                    response = JerseyServices.this.doPost(this.reqlog, this.builder, this.structure, true);
                } else if (this.queryDef instanceof DeleteQueryDefinition) {
                    response = JerseyServices.this.doGet(this.builder);
                } else if (this.queryDef instanceof RawQueryDefinition) {
                    response = JerseyServices.this.doPost(this.reqlog, this.builder, this.baseHandle.sendContent(), true);
                } else {
                    throw new UnsupportedOperationException("Cannot search with " + this.queryDef.getClass().getName());
                }
                status = response.getClientResponseStatus();
                if (status != ClientResponse.Status.SERVICE_UNAVAILABLE) {
                    if (!JerseyServices.this.isFirstRequest()) break;
                    JerseyServices.this.setFirstRequest(false);
                    break;
                }
                MultivaluedMap responseHeaders = response.getHeaders();
                String retryAfterRaw = (String)responseHeaders.getFirst((Object)"Retry-After");
                int retryAfter = retryAfterRaw != null ? Integer.valueOf(retryAfterRaw) : -1;
                response.close();
                nextDelay = Math.max(retryAfter, JerseyServices.this.calculateDelay(JerseyServices.this.randRetry, retry));
            }
            if (status == ClientResponse.Status.SERVICE_UNAVAILABLE) {
                JerseyServices.this.checkFirstRequest();
                throw new FailedRequestException("Service unavailable and maximum retry period elapsed: " + Math.round((System.currentTimeMillis() - startTime) / 1000L) + " seconds after " + retry + " retries");
            }
            if (status == ClientResponse.Status.NOT_FOUND) {
                response.close();
                return null;
            }
            if (status == ClientResponse.Status.FORBIDDEN) {
                throw new ForbiddenUserException("User is not allowed to search", JerseyServices.this.extractErrorFields(response));
            }
            if (status != ClientResponse.Status.OK) {
                throw new FailedRequestException("search failed: " + status.getReasonPhrase(), JerseyServices.this.extractErrorFields(response));
            }
            return response;
        }
    }

    private class JerseyDocumentPage
    extends BasicPage<DocumentRecord>
    implements DocumentPage,
    Iterator<DocumentRecord> {
        private JerseyResultIterator iterator;
        private Iterator<DocumentRecord> docRecordIterator;
        private boolean hasMetadata;
        private boolean hasContent;

        JerseyDocumentPage(JerseyResultIterator iterator, boolean hasContent, boolean hasMetadata) {
            super(new ArrayList().iterator(), iterator != null ? iterator.getStart() : 1L, iterator != null ? iterator.getPageSize() : 0L, iterator != null ? iterator.getTotalSize() : 0L);
            this.iterator = iterator;
            this.hasContent = hasContent;
            this.hasMetadata = hasMetadata;
            if (iterator == null) {
                this.setSize(0L);
            } else {
                this.setSize(iterator.getSize());
            }
        }

        @Override
        public Iterator<DocumentRecord> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocumentRecord next() {
            JerseyDocumentRecord record;
            if (this.iterator == null) {
                throw new NoSuchElementException("No documents available");
            }
            Object result = this.iterator.next();
            if (this.hasContent && this.hasMetadata) {
                Object metadata = result;
                Object content = this.iterator.next();
                record = new JerseyDocumentRecord((JerseyResult)content, (JerseyResult)metadata);
            } else if (this.hasContent) {
                Object content = result;
                record = new JerseyDocumentRecord((JerseyResult)content);
            } else if (this.hasMetadata) {
                Object metadata = result;
                record = new JerseyDocumentRecord(null, (JerseyResult)metadata);
            } else {
                throw new IllegalStateException("Should never have neither content nor metadata");
            }
            return record;
        }

        @Override
        public <T extends AbstractReadHandle> T nextContent(T contentHandle) {
            return this.next().getContent(contentHandle);
        }

        @Override
        public void close() {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
    }

    protected static class ThreadState {
        boolean isFirstRequest;

        ThreadState(boolean value) {
            this.isFirstRequest = value;
        }
    }

    protected static class HostnameVerifierAdapter
    extends AbstractVerifier {
        private DatabaseClientFactory.SSLHostnameVerifier verifier;

        protected HostnameVerifierAdapter(DatabaseClientFactory.SSLHostnameVerifier verifier) {
            this.verifier = verifier;
        }

        public void verify(String hostname, String[] cns, String[] subjectAlts) throws SSLException {
            this.verifier.verify(hostname, cns, subjectAlts);
        }
    }
}

