/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.collector;

import com.maxxton.microdocs.core.collector.SchemaParser;
import com.maxxton.microdocs.core.domain.schema.Schema;
import com.maxxton.microdocs.core.domain.schema.SchemaArray;
import com.maxxton.microdocs.core.domain.schema.SchemaDummy;
import com.maxxton.microdocs.core.domain.schema.SchemaEnum;
import com.maxxton.microdocs.core.domain.schema.SchemaGenericObject;
import com.maxxton.microdocs.core.domain.schema.SchemaObject;
import com.maxxton.microdocs.core.domain.schema.SchemaPrimitive;
import com.maxxton.microdocs.core.domain.schema.SchemaType;
import com.maxxton.microdocs.core.reflect.ClassType;
import com.maxxton.microdocs.core.reflect.ReflectAnnotation;
import com.maxxton.microdocs.core.reflect.ReflectClass;
import com.maxxton.microdocs.core.reflect.ReflectDescription;
import com.maxxton.microdocs.core.reflect.ReflectField;
import com.maxxton.microdocs.core.reflect.ReflectGenericClass;
import com.maxxton.microdocs.crawler.ErrorReporter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SchemaCollector {
    private Map<String, Schema> schemas = new HashMap<String, Schema>();
    private final String[] annotations;
    private final SchemaParser[] schemaParsers;

    public SchemaCollector(String[] annotations, SchemaParser[] schemaParsers) {
        this.annotations = annotations;
        this.schemaParsers = schemaParsers;
    }

    public Map<String, Schema> collect(List<ReflectClass<?>> classes) {
        HashMap models = new HashMap();
        classes.stream().filter(clazz -> clazz.hasAnnotation(this.annotations) && !this.schemas.containsKey(clazz.getName())).forEach(clazz -> models.put(clazz.getName(), clazz));
        models.entrySet().forEach(entry -> this.schemas.put((String)entry.getKey(), this.collectSchema((ReflectClass)entry.getValue(), new ArrayList<ReflectGenericClass>())));
        return this.schemas.entrySet().stream().filter(entry -> !((Schema)entry.getValue()).getType().equals((Object)SchemaType.DUMMY)).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (Schema)p.getValue()));
    }

    public Schema collect(ReflectClass reflectClass) {
        Schema schema;
        if (!this.schemas.containsKey(reflectClass.getName())) {
            schema = this.collectSchema(reflectClass, new ArrayList<ReflectGenericClass>());
            if (schema.getType() != SchemaType.OBJECT || schema instanceof SchemaObject && ((SchemaObject)schema).isIgnore()) {
                return schema;
            }
            this.schemas.put(reflectClass.getName(), schema);
        }
        schema = new SchemaPrimitive();
        schema.setReference("#/definitions/" + reflectClass.getName());
        return schema;
    }

    public Schema collect(ReflectGenericClass reflectGenericClass) {
        if (reflectGenericClass.getGenericTypes().isEmpty()) {
            return this.collect(reflectGenericClass.getClassType());
        }
        return this.collectSchema(reflectGenericClass.getClassType(), reflectGenericClass.getGenericTypes());
    }

    private Schema collectSchema(ReflectClass reflectClass, List<ReflectGenericClass> genericClasses) {
        ErrorReporter.get().printNotice("Collect Schema: " + reflectClass.getName());
        for (SchemaParser schemaParser : this.schemaParsers) {
            if (!schemaParser.getClassName().equals(reflectClass.getName())) continue;
            return schemaParser.parse(reflectClass, genericClasses, this);
        }
        if (reflectClass.getType() == ClassType.ENUM) {
            return this.collectEnumSchema(reflectClass);
        }
        if (reflectClass.getName().equals(Integer.class.getCanonicalName()) || reflectClass.getName().equals(Integer.TYPE.getCanonicalName()) || reflectClass.getName().equals(Byte.class.getCanonicalName()) || reflectClass.getName().equals(Byte.TYPE.getCanonicalName()) || reflectClass.getName().equals(Short.class.getCanonicalName()) || reflectClass.getName().equals(Short.TYPE.getCanonicalName()) || reflectClass.getName().equals(Long.class.getCanonicalName()) || reflectClass.getName().equals(Long.TYPE.getCanonicalName()) || reflectClass.getName().equals(Character.class.getCanonicalName()) || reflectClass.getName().equals(Character.TYPE.getCanonicalName())) {
            return this.collectIntegerSchema(reflectClass);
        }
        if (reflectClass.getName().equals(Float.class.getCanonicalName()) || reflectClass.getName().equals(Float.TYPE.getCanonicalName()) || reflectClass.getName().equals(Double.class.getCanonicalName()) || reflectClass.getName().equals(Double.TYPE.getCanonicalName())) {
            return this.collectNumberSchema(reflectClass);
        }
        if (reflectClass.getName().equals(String.class.getCanonicalName())) {
            return this.collectStringSchema(reflectClass);
        }
        if (reflectClass.getName().equals(Boolean.class.getCanonicalName()) || reflectClass.getName().equals(Boolean.TYPE.getCanonicalName())) {
            return this.collectBooleanSchema(reflectClass);
        }
        if (reflectClass.getName().equals(Date.class.getCanonicalName()) || reflectClass.getName().equals(LocalDate.class.getCanonicalName()) || reflectClass.getName().equals(LocalDateTime.class.getCanonicalName())) {
            return this.collectDateSchema(reflectClass);
        }
        if (reflectClass.hasParent(List.class.getCanonicalName(), Iterator.class.getCanonicalName(), Set.class.getCanonicalName())) {
            return this.collectArraySchema(reflectClass, genericClasses);
        }
        return this.collectObjectSchema(reflectClass, genericClasses);
    }

    private Schema collectEnumSchema(ReflectClass<?> reflectClass) {
        SchemaEnum schema = new SchemaEnum();
        schema.setType(SchemaType.ENUM);
        schema.setName(reflectClass.getName());
        schema.setSimpleName(reflectClass.getSimpleName());
        schema.setDescription(reflectClass.getDescription().getText());
        ArrayList enums = new ArrayList();
        reflectClass.getEnumFields().forEach(field -> enums.add(field.getSimpleName()));
        schema.setEnums(enums);
        return schema;
    }

    private Schema collectIntegerSchema(ReflectClass reflectClass) {
        return new SchemaPrimitive(SchemaType.INTEGER);
    }

    private Schema collectNumberSchema(ReflectClass reflectClass) {
        return new SchemaPrimitive(SchemaType.NUMBER);
    }

    private Schema collectStringSchema(ReflectClass reflectClass) {
        return new SchemaPrimitive(SchemaType.STRING);
    }

    private Schema collectBooleanSchema(ReflectClass reflectClass) {
        return new SchemaPrimitive(SchemaType.BOOLEAN);
    }

    private Schema collectDateSchema(ReflectClass reflectClass) {
        return new SchemaPrimitive(SchemaType.DATE);
    }

    private Schema collectArraySchema(ReflectClass reflectClass, List<ReflectGenericClass> genericClasses) {
        SchemaArray schema = new SchemaArray();
        schema.setType(SchemaType.ARRAY);
        if (!genericClasses.isEmpty()) {
            schema.setItems(this.collect(genericClasses.get(0)));
        }
        return schema;
    }

    protected Schema collectObjectSchema(ReflectClass<?> reflectClass, List<ReflectGenericClass> genericClasses) {
        if (reflectClass.hasParent(Map.class.getCanonicalName()) || reflectClass.getName().equals(Object.class.getCanonicalName())) {
            SchemaObject schema = new SchemaObject();
            schema.setType(SchemaType.OBJECT);
            schema.setName(reflectClass.getSimpleName());
            schema.setIgnore(true);
            return schema;
        }
        SchemaDummy dummy = new SchemaDummy();
        dummy.setType(SchemaType.DUMMY);
        this.schemas.put(reflectClass.getName(), dummy);
        SchemaObject schema = new SchemaObject();
        schema.setType(SchemaType.OBJECT);
        schema.setName(reflectClass.getSimpleName());
        schema.setGeneric(this.collectGeneric(genericClasses));
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        for (ReflectField field : reflectClass.getDeclaredFields()) {
            String name = field.getSimpleName();
            List reflectAnnotations = field.getAnnotations().stream().collect(Collectors.toList());
            reflectClass.getDeclaredMethods().stream().filter(method -> name.equalsIgnoreCase("is" + method.getSimpleName()) || name.equalsIgnoreCase("has" + method.getSimpleName()) || name.equalsIgnoreCase("get" + method.getSimpleName()) || name.equalsIgnoreCase("set" + method.getSimpleName())).forEach(method -> reflectAnnotations.addAll(method.getAnnotations()));
            this.collectProperty(properties, name, field.getType(), field.getAnnotations(), field.getDescription());
        }
        schema.setProperties(properties);
        return schema;
    }

    private List<SchemaGenericObject> collectGeneric(List<ReflectGenericClass> genericClasses) {
        if (genericClasses.isEmpty()) {
            return null;
        }
        ArrayList<SchemaGenericObject> generics = new ArrayList<SchemaGenericObject>();
        for (ReflectGenericClass clazz : genericClasses) {
            SchemaGenericObject generic = new SchemaGenericObject();
            generic.setName(clazz.getClassType().getName());
            generic.setSimpleName(clazz.getClassType().getSimpleName());
            generic.setGeneric(this.collectGeneric(clazz.getGenericTypes()));
            generics.add(generic);
        }
        return generics;
    }

    protected void collectProperty(Map<String, Schema> properties, String name, ReflectGenericClass type, List<ReflectAnnotation> annotations, ReflectDescription docs) {
        Schema fieldSchema = this.collect(type);
        properties.put(name, fieldSchema);
    }
}

