/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.builder;

import com.maxxton.microdocs.core.builder.Builder;
import com.maxxton.microdocs.core.domain.schema.SchemaMapping;
import com.maxxton.microdocs.core.domain.schema.SchemaMappings;
import java.util.List;

public class SchemaMappingsBuilder
implements Builder<SchemaMappings> {
    private SchemaMappings mappings;

    private void init() {
        if (this.mappings == null) {
            this.mappings = new SchemaMappings();
        }
    }

    private void initJson() {
        this.init();
        if (this.mappings.getJson() == null) {
            this.mappings.setJson(new SchemaMapping());
        }
    }

    private void initRelational() {
        this.init();
        if (this.mappings.getRelational() == null) {
            this.mappings.setRelational(new SchemaMapping());
        }
    }

    public SchemaMappingsBuilder jsonIgnore(boolean ignore) {
        this.initJson();
        this.mappings.getJson().setIgnore(ignore);
        return this;
    }

    public SchemaMappingsBuilder jsonName(String name) {
        this.initJson();
        this.mappings.getJson().setName(name);
        return this;
    }

    public SchemaMappingsBuilder jsonPrimary(boolean primary) {
        this.initJson();
        this.mappings.getJson().setPrimary(primary);
        return this;
    }

    public SchemaMappingsBuilder jsonTables(List<String> tables) {
        this.initJson();
        this.mappings.getJson().setTables(tables);
        return this;
    }

    public SchemaMappingsBuilder relationalIgnore(boolean ignore) {
        this.initRelational();
        this.mappings.getRelational().setIgnore(ignore);
        return this;
    }

    public SchemaMappingsBuilder relationalName(String name) {
        this.initRelational();
        this.mappings.getRelational().setName(name);
        return this;
    }

    public SchemaMappingsBuilder relationalPrimary(boolean primary) {
        this.initRelational();
        this.mappings.getRelational().setPrimary(primary);
        return this;
    }

    public SchemaMappingsBuilder relationalTables(List<String> tables) {
        this.initRelational();
        this.mappings.getRelational().setTables(tables);
        return this;
    }

    @Override
    public SchemaMappings build() {
        return this.mappings;
    }
}

