/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.publisher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.http.utils.URLParamEncoder;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.maxxton.microdocs.core.domain.check.CheckProblem;
import com.maxxton.microdocs.core.domain.check.CheckResponse;
import com.maxxton.microdocs.crawler.ErrorReporter;
import com.maxxton.microdocs.publisher.ServerConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class MicroDocsPublisher {
    public static CheckResponse publishProject(ServerConfiguration configuration, File microDocsReport, String projectName, String groupName, String version, boolean failOnProblems, String env) throws IOException {
        String report = MicroDocsPublisher.loadReport(microDocsReport);
        String url = configuration.getUrl() + "/api/v1/projects/" + URLParamEncoder.encode((String)projectName);
        ErrorReporter.get().printNotice("PUT " + url);
        MicroDocsPublisher.initObjectMapper();
        HttpResponse response = null;
        try {
            HttpRequestWithBody request = Unirest.put((String)(configuration.getUrl() + "/api/v1/projects/" + URLParamEncoder.encode((String)projectName))).queryString("failOnProblems", (Object)failOnProblems).header("content-type", "application/json").header("accept", "application/json");
            if (groupName != null && !groupName.trim().isEmpty()) {
                request = request.queryString("group", (Object)groupName);
            }
            if (version != null && !version.trim().isEmpty()) {
                request = request.queryString("version", (Object)version);
            }
            if (configuration.getUsername() != null && configuration.getPassword() != null) {
                request = request.basicAuth(configuration.getUsername(), configuration.getPassword());
            }
            if (env != null && !env.trim().isEmpty()) {
                request = request.queryString("env", (Object)env);
            }
            if ((response = request.body(report).asObject(CheckResponse.class)).getStatus() != 200) {
                throw new IOException("Wrong response status " + response.getStatus() + ", expected 200");
            }
        }
        catch (UnirestException e) {
            throw new IOException("Failed to send http request: POST " + url, e);
        }
        return (CheckResponse)response.getBody();
    }

    public static CheckResponse checkProject(ServerConfiguration configuration, File microDocsReport, String projectName, String env) throws IOException {
        String report = MicroDocsPublisher.loadReport(microDocsReport);
        String url = configuration.getUrl() + "/api/v1/check";
        ErrorReporter.get().printNotice("POST " + url);
        MicroDocsPublisher.initObjectMapper();
        HttpResponse response = null;
        try {
            HttpRequestWithBody request = Unirest.post((String)(configuration.getUrl() + "/api/v1/check")).queryString("project", (Object)projectName).header("content-type", "application/json").header("accept", "application/json");
            if (env != null && !env.trim().isEmpty()) {
                request = request.queryString("env", (Object)env);
            }
            if ((response = request.body(report).asObject(CheckResponse.class)).getStatus() != 200) {
                throw new IOException("Wrong response status " + response.getStatus() + ", expected 200");
            }
        }
        catch (UnirestException e) {
            throw new IOException("Failed to send http request: POST " + url, e);
        }
        return (CheckResponse)response.getBody();
    }

    private static String loadReport(File microDocsReport) throws IOException {
        ErrorReporter.get().printNotice("Load " + microDocsReport.getAbsolutePath());
        byte[] encoded = Files.readAllBytes(Paths.get(microDocsReport.toURI()));
        return new String(encoded);
    }

    private static void initObjectMapper() {
        final ObjectMapper jacksonObjectMapper = new ObjectMapper();
        jacksonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return jacksonObjectMapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static boolean printCheckResponse(CheckResponse response, File rootDir) {
        boolean hasProblems = !"ok".equalsIgnoreCase(response.getStatus());
        int errorCount = 0;
        int warningCount = 0;
        int noticeCount = 0;
        if (response.getProblems() != null) {
            for (CheckProblem problem : response.getProblems()) {
                switch (problem.getLevel().toLowerCase()) {
                    case "error": {
                        ++errorCount;
                        break;
                    }
                    case "warning": {
                        ++warningCount;
                        break;
                    }
                    case "notice": {
                        ++noticeCount;
                    }
                }
            }
        }
        String message = "\n";
        if (errorCount + warningCount + noticeCount > 0) {
            message = message + "Project contains problems: ";
            if (errorCount > 0) {
                message = message + String.valueOf(errorCount) + " error" + (errorCount > 1 ? "s" : "") + ",";
            }
            if (warningCount > 0) {
                message = message + String.valueOf(warningCount) + " warning" + (warningCount > 1 ? "s" : "") + ",";
            }
            if (noticeCount > 0) {
                message = message + String.valueOf(noticeCount) + " notice" + (noticeCount > 1 ? "s" : "") + ",";
            }
            if (message.endsWith(",")) {
                message = message.substring(0, message.length() - 1);
            }
        } else {
            message = message + "No problems found";
        }
        if (hasProblems) {
            ErrorReporter.get().printError(message);
        } else {
            ErrorReporter.get().printNotice(message);
        }
        if (response.getProblems() != null) {
            for (CheckProblem problem : response.getProblems()) {
                String msg = "\n";
                String lineNumber = problem.getLineNumber() > 0 ? ":" + String.valueOf(problem.getLineNumber()) : "";
                String sourceFile = new File(rootDir, "src/main/java/" + problem.getPath() + lineNumber).getPath();
                msg = msg + sourceFile + ": " + problem.getLevel() + ": " + problem.getMessage();
                if (problem.getClient() != null) {
                    msg = msg + ("\nBreaking change detected with " + problem.getClient().getTitle() + " (source: " + problem.getClient().getSourceLink() != null ? problem.getClient().getSourceLink() : problem.getClient().getClassName() + " )");
                }
                if (hasProblems) {
                    ErrorReporter.get().printError(msg);
                    continue;
                }
                ErrorReporter.get().printNotice(msg);
            }
        }
        ErrorReporter.get().printError("");
        return !hasProblems;
    }
}

