/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.builder;

import com.maxxton.microdocs.core.builder.Builder;
import com.maxxton.microdocs.core.domain.component.Component;
import com.maxxton.microdocs.core.domain.component.Method;
import com.maxxton.microdocs.core.domain.path.Parameter;
import com.maxxton.microdocs.core.domain.path.Path;
import com.maxxton.microdocs.core.domain.path.Response;
import com.maxxton.microdocs.core.reflect.ReflectClass;
import com.maxxton.microdocs.core.reflect.ReflectMethod;
import com.maxxton.microdocs.core.reflect.ReflectParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathBuilder
implements Builder<Path> {
    private Path endpoint = new Path();
    private String path;
    private String method;

    @Override
    public Path build() {
        return this.endpoint;
    }

    public PathBuilder path(String path) {
        this.path = path;
        return this;
    }

    public String path() {
        return this.path;
    }

    public PathBuilder requestMethod(String method) {
        this.method = method;
        return this;
    }

    public String requestMethod() {
        return this.method;
    }

    public PathBuilder component(ReflectClass controller) {
        return this.component(controller.getSimpleName());
    }

    public PathBuilder component(String controllerName) {
        Component component = new Component();
        component.setReference("#/components/" + controllerName);
        this.endpoint.setController(component);
        return this;
    }

    public PathBuilder method(ReflectMethod method) {
        String methodName = method.getSimpleName() + "(";
        if (!method.getParameters().isEmpty()) {
            for (ReflectParameter parameter : method.getParameters()) {
                methodName = methodName + parameter.getType().getClassType().getSimpleName() + ",";
            }
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        return this.method(methodName + ")");
    }

    public PathBuilder method(String methodName) {
        Method method = new Method();
        method.setReference(this.endpoint.getController().getReference() + "/methods/" + methodName);
        this.endpoint.setMethod(method);
        return this;
    }

    public PathBuilder tags(String ... tags) {
        ArrayList<String> tagList = new ArrayList<String>();
        for (String tag : tags) {
            tagList.add(tag);
        }
        return this.tags(tagList);
    }

    public PathBuilder tags(List<String> tagList) {
        this.endpoint.setTags(tagList);
        return this;
    }

    public PathBuilder summary(String summary) {
        this.endpoint.setSummary(summary);
        return this;
    }

    public PathBuilder description(String description) {
        this.endpoint.setDescription(description);
        return this;
    }

    public PathBuilder operationId(String operationId) {
        this.endpoint.setOperationId(operationId);
        return this;
    }

    public PathBuilder consumes(String ... consumes) {
        ArrayList<String> consumesList = new ArrayList<String>();
        for (String consume : consumes) {
            consumesList.add(consume);
        }
        return this.consumes(consumesList);
    }

    public PathBuilder consumes(List<String> consumes) {
        this.endpoint.setConsumes(consumes);
        return this;
    }

    public PathBuilder produces(String ... produces) {
        ArrayList<String> produceList = new ArrayList<String>();
        for (String produce : produces) {
            produceList.add(produce);
        }
        return this.produces(produceList);
    }

    public PathBuilder produces(List<String> produces) {
        this.endpoint.setProduces(produces);
        return this;
    }

    public PathBuilder parameter(Parameter parameter) {
        this.endpoint.getParameters().add(parameter);
        return this;
    }

    public PathBuilder parameters(List<Parameter> parameters) {
        this.endpoint.setParameters(parameters);
        return this;
    }

    public PathBuilder response(Response response) {
        if (this.endpoint.getResponses() == null) {
            this.endpoint.setResponses(new HashMap<String, Response>());
        }
        this.endpoint.getResponses().put("default", response);
        return this;
    }

    public PathBuilder responses(Map<String, Response> responses) {
        if (this.endpoint.getResponses() == null) {
            this.endpoint.setResponses(new HashMap<String, Response>());
        }
        responses.entrySet().forEach(entry -> this.endpoint.getResponses().put((String)entry.getKey(), (Response)entry.getValue()));
        return this;
    }
}

