/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.reflect;

public class ReflectDescriptionTag {
    private String tagName;
    private String keyword;
    private String description;

    public ReflectDescriptionTag(String tagName, String keyword, String description) {
        this.setTagName(tagName);
        this.setKeyword(keyword);
        this.setDescription(description);
    }

    public ReflectDescriptionTag(String tagName, String text) {
        this.setTagName(tagName);
        String[] split = text.split(" ");
        if (split.length > 0) {
            this.setKeyword(split[0]);
        } else {
            this.setKeyword(null);
        }
        if (split.length > 1) {
            String desc = split[1];
            for (int i = 2; i < split.length; ++i) {
                desc = desc + " " + split[i];
            }
            this.setDescription(desc);
        } else {
            this.setDescription(null);
        }
    }

    public ReflectDescriptionTag(String text) {
        this.setText(text);
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        if (tagName != null && (tagName = tagName.toLowerCase()).startsWith("@")) {
            tagName = tagName.substring(1);
        }
        this.tagName = tagName;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContent() {
        String content = "";
        if (this.getKeyword() != null) {
            content = content + this.getKeyword();
        }
        if (this.getDescription() != null) {
            content = content + " " + this.getDescription();
        }
        return content.trim();
    }

    public void getText() {
        String text = "@" + this.tagName;
        if (this.keyword != null) {
            text = text + this.keyword;
        }
        if (this.description != null) {
            text = text + this.description;
        }
    }

    public void setText(String text) {
        String[] split = text.split(" ");
        this.setTagName(split[0]);
        if (split.length > 1) {
            this.setKeyword(split[1]);
        } else {
            this.setKeyword(null);
        }
        if (split.length > 2) {
            String desc = split[2];
            for (int i = 3; i < split.length; ++i) {
                desc = desc + " " + split[i];
            }
            this.setDescription(desc);
        } else {
            this.setDescription(null);
        }
    }
}

