/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.crawler.spring.collector;

import com.maxxton.microdocs.core.builder.PathBuilder;
import com.maxxton.microdocs.core.collector.Collector;
import com.maxxton.microdocs.core.collector.SchemaCollector;
import com.maxxton.microdocs.core.domain.path.Parameter;
import com.maxxton.microdocs.core.domain.path.ParameterBody;
import com.maxxton.microdocs.core.domain.path.ParameterPlacing;
import com.maxxton.microdocs.core.domain.path.ParameterVariable;
import com.maxxton.microdocs.core.domain.path.Response;
import com.maxxton.microdocs.core.domain.schema.Schema;
import com.maxxton.microdocs.core.domain.schema.SchemaObject;
import com.maxxton.microdocs.core.domain.schema.SchemaType;
import com.maxxton.microdocs.core.logging.Logger;
import com.maxxton.microdocs.core.reflect.ReflectAnnotation;
import com.maxxton.microdocs.core.reflect.ReflectAnnotationValue;
import com.maxxton.microdocs.core.reflect.ReflectClass;
import com.maxxton.microdocs.core.reflect.ReflectDescriptionTag;
import com.maxxton.microdocs.core.reflect.ReflectMethod;
import com.maxxton.microdocs.core.reflect.ReflectParameter;
import com.maxxton.microdocs.crawler.spring.Types;
import com.maxxton.microdocs.crawler.spring.collector.RequestParser;
import com.maxxton.microdocs.crawler.spring.parser.PageableParser;
import com.maxxton.microdocs.crawler.spring.parser.SpecificationsParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PathCollector
implements Collector<PathBuilder> {
    private final String[] defaultConsumes = new String[]{"application/json"};
    private final String[] defaultProduces = new String[]{"application/json"};
    private static final String TYPE_REQUEST_BODY = "org.springframework.web.bind.annotation.RequestBody";
    private static final String TYPE_REQUEST_PARAM = "org.springframework.web.bind.annotation.RequestParam";
    private static final String TYPE_PATH_VARIABLE = "org.springframework.web.bind.annotation.PathVariable";
    private static final String JSON_VIEW = "com.fasterxml.jackson.annotation.JsonView";
    private SchemaCollector schemaCollector;
    private final String[] controllers;
    private final List<String> requestMappers = Arrays.asList(Types.REQUEST_MAPPING.getClassName(), Types.GET_MAPPING.getClassName(), Types.DELETE_MAPPING.getClassName(), Types.PATCH_MAPPING.getClassName(), Types.POST_MAPPING.getClassName(), Types.PUT_MAPPING.getClassName());
    private final RequestParser[] requestParsers = new RequestParser[]{new PageableParser(), new SpecificationsParser()};

    public PathCollector(SchemaCollector schemaCollector, Types ... controllers) {
        this.schemaCollector = schemaCollector;
        this.controllers = new String[controllers.length];
        for (int i = 0; i < controllers.length; ++i) {
            this.controllers[i] = controllers[i].getClassName();
        }
    }

    @Override
    public List<PathBuilder> collect(List<ReflectClass<?>> classes) {
        ArrayList<PathBuilder> pathBuilders = new ArrayList<PathBuilder>();
        classes.stream().filter(reflectClass -> reflectClass.hasAnnotation(this.controllers)).forEach(controller -> {
            Logger.get().debug("Crawl controller: " + controller.getSimpleName());
            String[] mappers = this.requestMappers.toArray(new String[this.requestMappers.size()]);
            controller.getDeclaredMethods().stream().filter(method -> method.hasAnnotation(mappers)).forEach(method -> {
                Logger.get().debug("Crawl controller method: " + method.getSimpleName());
                pathBuilders.addAll(this.collectPaths((ReflectClass<?>)controller, (ReflectMethod)method));
            });
        });
        return pathBuilders;
    }

    /*
     * WARNING - void declaration
     */
    private List<PathBuilder> collectPaths(ReflectClass<?> controller, ReflectMethod method) {
        String path;
        ReflectAnnotation controllerRequestMapping = controller.getAnnotations().stream().filter(annotation -> !this.requestMappers.stream().filter(mapper -> mapper.equals(annotation.getName())).collect(Collectors.toList()).isEmpty()).findFirst().orElse(null);
        ReflectAnnotation methodRequestMapping = method.getAnnotations().stream().filter(annotation -> !this.requestMappers.stream().filter(mapper -> mapper.equals(annotation.getName())).collect(Collectors.toList()).isEmpty()).findFirst().orElse(null);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String controllerPath = this.getPath(controllerRequestMapping);
        String methodPath = this.getPath(methodRequestMapping);
        String fullPath = (controllerPath + "/" + methodPath).replace("\\\\", "/").replace("//", "/");
        if (!fullPath.startsWith("/")) {
            fullPath = "/" + fullPath;
        }
        if (fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        if (fullPath.contains("?")) {
            String[] pathSplit = fullPath.split("\\?");
            path = pathSplit[0];
            if (pathSplit.length >= 2) {
                String[] params;
                String paramsSplit = pathSplit[1];
                String[] stringArray = params = paramsSplit.split("&");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    String[] paramSplit = string.split("=");
                    ParameterVariable parameter = new ParameterVariable();
                    parameter.setIn(ParameterPlacing.QUERY);
                    parameter.setName(paramSplit[0]);
                    parameter.setRequired(true);
                    parameter.setType(SchemaType.ANY);
                    if (paramSplit.length > 1) {
                        parameter.setDefaultValue(paramSplit[1]);
                        parameter.setType(SchemaType.ENUM);
                        ArrayList<String> enums = new ArrayList<String>();
                        enums.add(paramSplit[1]);
                        parameter.setEnums(enums);
                    }
                    parameters.add(parameter);
                }
            }
        } else {
            path = fullPath;
        }
        HashSet<String> methods = new HashSet<String>();
        methods.addAll(this.getMethods(controllerRequestMapping));
        methods.addAll(this.getMethods(methodRequestMapping));
        if (methods.isEmpty()) {
            methods.add("get");
        }
        methods.forEach(requestMethod -> Logger.get().logEndpoint((String)requestMethod, path));
        HashSet<String> produces = new HashSet<String>();
        for (String mime : this.defaultProduces) {
            produces.add(mime);
        }
        produces.addAll(this.getProduces(controllerRequestMapping));
        produces.addAll(this.getProduces(methodRequestMapping));
        HashSet<String> consumes = new HashSet<String>();
        for (String string : this.defaultConsumes) {
            consumes.add(string);
        }
        consumes.addAll(this.getCondumes(controllerRequestMapping));
        consumes.addAll(this.getCondumes(methodRequestMapping));
        for (ReflectParameter parameter : method.getParameters()) {
            ParameterVariable param;
            if (parameter.getType() != null && parameter.getType().getClassType() != null) {
                RequestParser parser = null;
                for (RequestParser requestParser : this.requestParsers) {
                    if (!requestParser.getClassName().equals(parameter.getType().getClassType().getName()) && !requestParser.getClassName().equals(parameter.getType().getClassType().getSimpleName())) continue;
                    parser = requestParser;
                    break;
                }
                if (parser != null) {
                    List<Parameter> list = parser.parse(parameter, controller, method, this.schemaCollector);
                    parameters.addAll(list);
                    continue;
                }
            }
            String name = parameter.getName();
            Schema schema = this.schemaCollector.collect(parameter.getType());
            String description = null;
            for (ReflectDescriptionTag tag2 : method.getDescription().getTags("param")) {
                if (!name.equals(tag2.getKeyword())) continue;
                description = tag2.getDescription();
                break;
            }
            if (parameter.hasAnnotation(TYPE_REQUEST_BODY)) {
                ParameterBody bodyParam = new ParameterBody();
                bodyParam.setSchema(schema);
                bodyParam.setName(name);
                bodyParam.setDescription(description);
                bodyParam.setIn(ParameterPlacing.BODY);
                parameters.add(bodyParam);
                continue;
            }
            if (parameter.hasAnnotation(TYPE_REQUEST_PARAM)) {
                ReflectAnnotation annotation2 = parameter.getAnnotation(TYPE_REQUEST_PARAM);
                param = new ParameterVariable();
                param.setIn(ParameterPlacing.QUERY);
                if (annotation2.has("value")) {
                    name = annotation2.getString("value");
                } else if (annotation2.has("name")) {
                    name = annotation2.getString("name");
                }
                param.setName(name);
                param.setDescription(description);
                param.setRequired(annotation2.getBoolean("required"));
                param.setDefaultValue(annotation2.getObject("defaultValue"));
                param.setType(schema != null ? schema.getType() : null);
                parameters.add(param);
                continue;
            }
            if (!parameter.hasAnnotation(TYPE_PATH_VARIABLE)) continue;
            ReflectAnnotation annotation2 = parameter.getAnnotation(TYPE_PATH_VARIABLE);
            param = new ParameterVariable();
            param.setIn(ParameterPlacing.PATH);
            if (annotation2.has("value")) {
                name = annotation2.getString("value");
            } else if (annotation2.has("name")) {
                name = annotation2.getString("name");
            }
            param.setName(name);
            param.setDescription(description);
            param.setRequired(true);
            param.setType(schema != null ? schema.getType() : null);
            parameters.add(param);
        }
        HashMap<String, Response> responses = new HashMap<String, Response>();
        if (method.getReturnType() != null && method.getReturnType().getClassType() != null && !method.getReturnType().getClassType().getSimpleName().equalsIgnoreCase("void")) {
            void var16_39;
            Response response = new Response();
            Iterator<ReflectDescriptionTag> name = method.getDescription().getTags("return").iterator();
            if (name.hasNext()) {
                ReflectDescriptionTag reflectDescriptionTag = name.next();
                response.setDescription(reflectDescriptionTag.getKeyword() + " " + reflectDescriptionTag.getDescription());
            }
            ArrayList views = new ArrayList();
            method.getAnnotations().stream().filter(annotation -> annotation.getName().equals(JSON_VIEW)).forEach(annotation -> annotation.getList("value").forEach(value -> {
                if (value.getClazz() != null) {
                    views.add(value.getClazz().getName());
                }
            }));
            if (views.isEmpty()) {
                Schema schema = this.schemaCollector.collect(method.getReturnType());
            } else if (views.size() == 1) {
                Schema schema = this.schemaCollector.collect(method.getReturnType(), (String)views.get(0));
            } else {
                SchemaObject schemaObject = new SchemaObject();
                schemaObject.setAnyOf(new ArrayList<Schema>());
                for (String view : views) {
                    Schema subSchema = this.schemaCollector.collect(method.getReturnType(), view);
                    schemaObject.getAnyOf().add(subSchema);
                }
                SchemaObject schemaObject2 = schemaObject;
            }
            response.setSchema((Schema)var16_39);
            responses.put("default", response);
        }
        List<ReflectDescriptionTag> responseTags = method.getDescription().getTags("response");
        responseTags.forEach(tag -> {
            String responseCode = tag.getKeyword();
            Response response = new Response();
            response.setDescription(tag.getDescription());
            responses.put(responseCode, response);
        });
        ArrayList<PathBuilder> pathBuilders = new ArrayList<PathBuilder>();
        for (String requestMethod2 : methods) {
            PathBuilder builder = new PathBuilder();
            builder.path(path);
            builder.requestMethod(requestMethod2);
            builder.component(controller);
            builder.method(method);
            builder.description(method.getDescription().getText());
            builder.operationId(method.getSimpleName());
            builder.parameters(parameters);
            builder.responses(responses);
            builder.consumes(consumes.stream().collect(Collectors.toList()));
            builder.produces(produces.stream().collect(Collectors.toList()));
            pathBuilders.add(builder);
        }
        return pathBuilders;
    }

    private String getPath(ReflectAnnotation requestMapping) {
        String path = "";
        if (requestMapping != null) {
            if (requestMapping.has("value")) {
                if (requestMapping.getList("value") != null) {
                    for (ReflectAnnotationValue p : requestMapping.getList("value")) {
                        path = p.getString();
                    }
                } else {
                    path = requestMapping.getString("value");
                }
            } else if (requestMapping.has("path")) {
                if (requestMapping.getList("path") != null) {
                    for (ReflectAnnotationValue p : requestMapping.getList("path")) {
                        path = p.getString();
                    }
                } else {
                    path = requestMapping.getString("path");
                }
            }
        }
        return path;
    }

    private Set<String> getMethods(ReflectAnnotation requestMapping) {
        HashSet<String> methodSet = new HashSet<String>();
        if (requestMapping != null) {
            if (requestMapping.getName().equals(Types.GET_MAPPING.getClassName())) {
                methodSet.add("get");
            } else if (requestMapping.getName().equals(Types.DELETE_MAPPING.getClassName())) {
                methodSet.add("delete");
            } else if (requestMapping.getName().equals(Types.POST_MAPPING.getClassName())) {
                methodSet.add("post");
            } else if (requestMapping.getName().equals(Types.PUT_MAPPING.getClassName())) {
                methodSet.add("put");
            } else if (requestMapping.getName().equals(Types.PATCH_MAPPING.getClassName())) {
                methodSet.add("patch");
            }
            List<ReflectAnnotationValue> methods = requestMapping.getList("method");
            if (methods != null) {
                for (ReflectAnnotationValue method : methods) {
                    if (!method.getString().startsWith("org.springframework.web.bind.annotation.RequestMethod.")) continue;
                    methodSet.add(method.getString().substring("org.springframework.web.bind.annotation.RequestMethod.".length()).toLowerCase());
                }
            }
        }
        return methodSet;
    }

    private Set<String> getProduces(ReflectAnnotation requestMapping) {
        List<ReflectAnnotationValue> mimes;
        HashSet<String> produces = new HashSet<String>();
        if (requestMapping != null && requestMapping.has("produces") && (mimes = requestMapping.getList("produces")) != null) {
            for (ReflectAnnotationValue mime : mimes) {
                produces.add(mime.getString());
            }
        }
        return produces;
    }

    private Set<String> getCondumes(ReflectAnnotation requestMapping) {
        List<ReflectAnnotationValue> mimes;
        HashSet<String> produces = new HashSet<String>();
        if (requestMapping != null && requestMapping.has("consumes") && (mimes = requestMapping.getList("consumes")) != null) {
            for (ReflectAnnotationValue mime : mimes) {
                produces.add(mime.getString());
            }
        }
        return produces;
    }
}

