/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.collector;

import com.maxxton.microdocs.core.collector.SchemaParser;
import com.maxxton.microdocs.core.domain.schema.Schema;
import com.maxxton.microdocs.core.domain.schema.SchemaArray;
import com.maxxton.microdocs.core.domain.schema.SchemaDummy;
import com.maxxton.microdocs.core.domain.schema.SchemaEnum;
import com.maxxton.microdocs.core.domain.schema.SchemaGenericObject;
import com.maxxton.microdocs.core.domain.schema.SchemaObject;
import com.maxxton.microdocs.core.domain.schema.SchemaPrimitive;
import com.maxxton.microdocs.core.domain.schema.SchemaType;
import com.maxxton.microdocs.core.logging.Logger;
import com.maxxton.microdocs.core.reflect.ClassType;
import com.maxxton.microdocs.core.reflect.ReflectAnnotation;
import com.maxxton.microdocs.core.reflect.ReflectClass;
import com.maxxton.microdocs.core.reflect.ReflectDescription;
import com.maxxton.microdocs.core.reflect.ReflectDescriptionTag;
import com.maxxton.microdocs.core.reflect.ReflectField;
import com.maxxton.microdocs.core.reflect.ReflectGenericClass;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SchemaCollector {
    private Map<String, Schema> schemas = new HashMap<String, Schema>();
    protected Map<String, String> postViews = new HashMap<String, String>();
    private final String[] annotations;
    private final SchemaParser[] schemaParsers;

    public SchemaCollector(String[] annotations, SchemaParser[] schemaParsers) {
        this.annotations = annotations;
        this.schemaParsers = schemaParsers;
    }

    public Map<String, Schema> collect(List<ReflectClass<?>> classes) {
        HashMap<String, ReflectClass> models = new HashMap<String, ReflectClass>();
        classes.stream().filter(clazz -> clazz.hasAnnotation(this.annotations) && !this.schemas.containsKey(this.getSchemaName((ReflectClass<?>)clazz, null))).forEach(clazz -> models.put(clazz.getName(), (ReflectClass)clazz));
        models.forEach((key, value) -> this.schemas.put(this.getSchemaName((ReflectClass<?>)value, null), this.collectSchema((ReflectClass<?>)value, (List<ReflectGenericClass>)new ArrayList<ReflectGenericClass>(), null)));
        ArrayList<Map.Entry<String, String>> entrySet = new ArrayList<Map.Entry<String, String>>(this.postViews.entrySet());
        for (Map.Entry entry2 : entrySet) {
            String className = (String)entry2.getKey();
            String view = (String)entry2.getValue();
            ReflectClass matchClass = classes.stream().filter(clazz -> clazz.getName().equals(className)).findFirst().orElse(null);
            this.collect(matchClass, view);
        }
        return this.schemas.entrySet().stream().filter(entry -> !((Schema)entry.getValue()).getType().equals((Object)SchemaType.DUMMY)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Schema collect(ReflectClass<?> reflectClass) {
        return this.collect(reflectClass, null);
    }

    public Schema collect(ReflectClass<?> reflectClass, String view) {
        Schema schema;
        if (!this.schemas.containsKey(this.getSchemaName(reflectClass, view))) {
            schema = this.collectSchema(reflectClass, new ArrayList<ReflectGenericClass>(), view);
            if (schema.getType() != SchemaType.OBJECT || schema instanceof SchemaObject && ((SchemaObject)schema).isIgnore()) {
                return schema;
            }
            this.schemas.put(this.getSchemaName(reflectClass, view), schema);
        }
        schema = new SchemaPrimitive();
        schema.setReference("#/definitions/" + reflectClass.getName() + (String)(view != null ? "#" + view : ""));
        return schema;
    }

    public Schema collect(ReflectGenericClass reflectGenericClass) {
        return this.collect(reflectGenericClass, null);
    }

    public Schema collect(ReflectGenericClass reflectGenericClass, String view) {
        if (reflectGenericClass.getGenericTypes().isEmpty()) {
            return this.collect(reflectGenericClass.getClassType(), view);
        }
        return this.collectSchema(reflectGenericClass.getClassType(), reflectGenericClass.getGenericTypes(), view);
    }

    private Schema collectSchema(ReflectClass<?> reflectClass, List<ReflectGenericClass> genericClasses, String view) {
        Logger.get().debug("Collect Schema: " + reflectClass.getName());
        for (SchemaParser schemaParser : this.schemaParsers) {
            if (!schemaParser.getClassName().equals(reflectClass.getName())) continue;
            return schemaParser.parse(reflectClass, genericClasses, this);
        }
        if (reflectClass.getType() == ClassType.ENUM) {
            return this.collectEnumSchema(reflectClass);
        }
        if (reflectClass.getName().equals(Integer.class.getCanonicalName()) || reflectClass.getName().equals(Integer.TYPE.getCanonicalName()) || reflectClass.getName().equals(Byte.class.getCanonicalName()) || reflectClass.getName().equals(Byte.TYPE.getCanonicalName()) || reflectClass.getName().equals(Short.class.getCanonicalName()) || reflectClass.getName().equals(Short.TYPE.getCanonicalName()) || reflectClass.getName().equals(Long.class.getCanonicalName()) || reflectClass.getName().equals(Long.TYPE.getCanonicalName()) || reflectClass.getName().equals(Character.class.getCanonicalName()) || reflectClass.getName().equals(Character.TYPE.getCanonicalName())) {
            return this.collectIntegerSchema(reflectClass);
        }
        if (reflectClass.getName().equals(Float.class.getCanonicalName()) || reflectClass.getName().equals(Float.TYPE.getCanonicalName()) || reflectClass.getName().equals(Double.class.getCanonicalName()) || reflectClass.getName().equals(Double.TYPE.getCanonicalName())) {
            return this.collectNumberSchema(reflectClass);
        }
        if (reflectClass.getName().equals(String.class.getCanonicalName())) {
            return this.collectStringSchema(reflectClass);
        }
        if (reflectClass.getName().equals(Boolean.class.getCanonicalName()) || reflectClass.getName().equals(Boolean.TYPE.getCanonicalName())) {
            return this.collectBooleanSchema(reflectClass);
        }
        if (reflectClass.getName().equals(Date.class.getCanonicalName()) || reflectClass.getName().equals(LocalDate.class.getCanonicalName()) || reflectClass.getName().equals(LocalDateTime.class.getCanonicalName())) {
            return this.collectDateSchema(reflectClass);
        }
        if (reflectClass.hasParent(List.class.getCanonicalName(), Iterator.class.getCanonicalName(), Set.class.getCanonicalName())) {
            return this.collectArraySchema(reflectClass, genericClasses, view);
        }
        return this.collectObjectSchema(reflectClass, genericClasses, view);
    }

    private Schema collectEnumSchema(ReflectClass<?> reflectClass) {
        SchemaEnum schema = new SchemaEnum();
        schema.setType(SchemaType.ENUM);
        schema.setName(reflectClass.getName());
        schema.setSimpleName(reflectClass.getSimpleName());
        schema.setDescription(reflectClass.getDescription().getText());
        ArrayList<String> enums = new ArrayList<String>();
        reflectClass.getEnumFields().forEach(field -> enums.add(field.getSimpleName()));
        schema.setEnums(enums);
        return schema;
    }

    private Schema collectIntegerSchema(ReflectClass<?> reflectClass) {
        return new SchemaPrimitive(SchemaType.INTEGER);
    }

    private Schema collectNumberSchema(ReflectClass<?> reflectClass) {
        return new SchemaPrimitive(SchemaType.NUMBER);
    }

    private Schema collectStringSchema(ReflectClass<?> reflectClass) {
        return new SchemaPrimitive(SchemaType.STRING);
    }

    private Schema collectBooleanSchema(ReflectClass<?> reflectClass) {
        return new SchemaPrimitive(SchemaType.BOOLEAN);
    }

    private Schema collectDateSchema(ReflectClass<?> reflectClass) {
        return new SchemaPrimitive(SchemaType.DATE);
    }

    private Schema collectArraySchema(ReflectClass<?> reflectClass, List<ReflectGenericClass> genericClasses, String view) {
        SchemaArray schema = new SchemaArray();
        schema.setType(SchemaType.ARRAY);
        if (!genericClasses.isEmpty()) {
            schema.setItems(this.collect(genericClasses.get(0), view));
        }
        return schema;
    }

    protected Schema collectObjectSchema(ReflectClass<?> reflectClass, List<ReflectGenericClass> genericClasses, String view) {
        if (reflectClass.hasParent(Map.class.getCanonicalName()) || reflectClass.getName().equals(Object.class.getCanonicalName())) {
            SchemaObject schema = new SchemaObject();
            schema.setType(SchemaType.OBJECT);
            schema.setName(reflectClass.getSimpleName());
            schema.setIgnore(true);
            return schema;
        }
        SchemaDummy dummy = new SchemaDummy();
        dummy.setType(SchemaType.DUMMY);
        this.schemas.put(this.getSchemaName(reflectClass, view), dummy);
        SchemaObject schema = new SchemaObject();
        if (reflectClass.getDescription() != null) {
            schema.setDescription(reflectClass.getDescription().getText());
        }
        schema.setType(SchemaType.OBJECT);
        schema.setName(reflectClass.getSimpleName());
        schema.setGeneric(this.collectGeneric(genericClasses));
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        HashMap propertyBuckets = new HashMap();
        reflectClass.getDeclaredMethods().stream().filter(method -> method.getSimpleName().startsWith("is") || method.getSimpleName().startsWith("has") || method.getSimpleName().startsWith("get") || method.getSimpleName().startsWith("set")).forEach(method -> {
            PropertyBucket bucket;
            Object propertyName = method.getSimpleName().startsWith("is") ? method.getSimpleName().substring(2) : method.getSimpleName().substring(3);
            propertyName = ((String)propertyName).substring(0, 1).toLowerCase() + ((String)propertyName).substring(1);
            ReflectGenericClass type = null;
            if (method.getSimpleName().startsWith("set")) {
                if (!method.getParameters().isEmpty()) {
                    type = method.getParameters().get(0).getType();
                }
            } else {
                type = method.getReturnType();
            }
            if (propertyBuckets.containsKey(propertyName)) {
                bucket = (PropertyBucket)propertyBuckets.get(propertyName);
            } else {
                bucket = new PropertyBucket();
                propertyBuckets.put(propertyName, bucket);
            }
            bucket.setType(type);
            bucket.addAnnotations(method.getAnnotations());
            bucket.addDescription(method.getDescription());
        });
        for (ReflectField reflectField : reflectClass.getDeclaredFields()) {
            String propertyName = reflectField.getSimpleName();
            if (!propertyBuckets.containsKey(propertyName)) continue;
            PropertyBucket bucket = (PropertyBucket)propertyBuckets.get(propertyName);
            bucket.setType(reflectField.getType());
            bucket.addAnnotations(reflectField.getAnnotations());
            bucket.addDescription(reflectField.getDescription());
        }
        Logger.get().debug(propertyBuckets.size() + " buckets in " + reflectClass.getSimpleName());
        for (Map.Entry entry : propertyBuckets.entrySet()) {
            Schema propertySchema = this.collectProperty((String)entry.getKey(), ((PropertyBucket)entry.getValue()).getType(), ((PropertyBucket)entry.getValue()).getAnnotations(), ((PropertyBucket)entry.getValue()).getDescription(), view);
            if (!this.matchView(propertySchema, view)) continue;
            properties.put((String)entry.getKey(), propertySchema);
        }
        schema.setProperties(properties);
        if (reflectClass.getSuperClass() != null && reflectClass.getSuperClass().getClassType() != null && !Object.class.getName().equals(reflectClass.getSuperClass().getClassType().getName())) {
            Schema superSchema = this.collect(reflectClass.getSuperClass(), view);
            ArrayList<Schema> arrayList = new ArrayList<Schema>();
            arrayList.add(superSchema);
            schema.setAllOf(arrayList);
        }
        return schema;
    }

    private List<SchemaGenericObject> collectGeneric(List<ReflectGenericClass> genericClasses) {
        if (genericClasses.isEmpty()) {
            return null;
        }
        ArrayList<SchemaGenericObject> generics = new ArrayList<SchemaGenericObject>();
        for (ReflectGenericClass clazz : genericClasses) {
            SchemaGenericObject generic = new SchemaGenericObject();
            generic.setName(clazz.getClassType().getName());
            generic.setSimpleName(clazz.getClassType().getSimpleName());
            generic.setGeneric(this.collectGeneric(clazz.getGenericTypes()));
            generics.add(generic);
        }
        return generics;
    }

    protected Schema collectProperty(String name, ReflectGenericClass type, List<ReflectAnnotation> annotations, ReflectDescription docs, String view) {
        Schema fieldSchema = this.collect(type, view);
        this.getDefaultValue(fieldSchema, docs);
        return fieldSchema;
    }

    protected void getDefaultValue(Schema fieldSchema, ReflectDescription docs) {
        if (docs.getTags("example") != null) {
            docs.getTags("example").forEach(tag -> {
                try {
                    if (fieldSchema.getType() == SchemaType.BOOLEAN) {
                        fieldSchema.setDefaultValue(Boolean.parseBoolean(tag.getContent()));
                    } else if (fieldSchema.getType() == SchemaType.INTEGER) {
                        fieldSchema.setDefaultValue(Integer.parseInt(tag.getContent()));
                    } else if (fieldSchema.getType() == SchemaType.NUMBER) {
                        fieldSchema.setDefaultValue(Float.valueOf(Float.parseFloat(tag.getContent())));
                    } else if (fieldSchema.getType() == SchemaType.DATE) {
                        fieldSchema.setDefaultValue(tag.getContent());
                    } else if (fieldSchema.getType() == SchemaType.STRING) {
                        fieldSchema.setDefaultValue(tag.getContent());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    protected boolean matchView(Schema schema, String view) {
        if (view == null) {
            return true;
        }
        if (schema.getMappings() != null && schema.getMappings().getJson() != null && schema.getMappings().getJson().getViews() != null) {
            return schema.getMappings().getJson().getViews().contains(view);
        }
        return true;
    }

    protected String getSchemaName(ReflectClass<?> reflectClass, String view) {
        return reflectClass.getName() + (String)(view != null ? "#" + view : "");
    }

    private static class PropertyBucket {
        private ReflectGenericClass type;
        private List<ReflectAnnotation> annotations = new ArrayList<ReflectAnnotation>();
        private List<ReflectDescription> descriptions = new ArrayList<ReflectDescription>();

        private PropertyBucket() {
        }

        public ReflectGenericClass getType() {
            return this.type;
        }

        public List<ReflectAnnotation> getAnnotations() {
            return this.annotations;
        }

        public ReflectDescription getDescription() {
            ReflectDescription desc = new ReflectDescription();
            if (!this.descriptions.isEmpty()) {
                for (int i = this.descriptions.size() - 1; i >= 0; --i) {
                    if (this.descriptions.get(i).getText() == null || this.descriptions.get(i).getText().trim().isEmpty()) continue;
                    desc.setText(this.descriptions.get(i).getText());
                    break;
                }
                ArrayList<ReflectDescriptionTag> tags = new ArrayList<ReflectDescriptionTag>();
                this.descriptions.forEach(description -> tags.addAll(description.getTags()));
                desc.setTags(tags);
            }
            return desc;
        }

        public void addDescription(ReflectDescription description) {
            this.descriptions.add(description);
        }

        public void addAnnotations(List<ReflectAnnotation> annotations) {
            this.annotations.addAll(annotations);
        }

        public void setType(ReflectGenericClass type) {
            this.type = type;
        }
    }
}

