/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.common.base.Charsets;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.galaxy.GalaxyConfigModule;
import com.nesscomputing.httpclient.HttpClient;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.guice.HttpClientModule;
import com.nesscomputing.httpclient.response.ContentConverter;
import com.nesscomputing.httpclient.response.ContentResponseHandler;
import com.nesscomputing.httpclient.response.HttpResponse;
import com.nesscomputing.httpclient.response.HttpResponseContentConverter;
import com.nesscomputing.httpserver.HttpServerHandlerBinder;
import com.nesscomputing.httpserver.HttpServerModule;
import com.nesscomputing.httpserver.jetty.ClasspathResourceHandler;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.LifecycleModule;
import com.nesscomputing.testing.lessio.AllowNetworkAccess;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@AllowNetworkListen(ports={0})
@AllowNetworkAccess(endpoints={"127.0.0.1:0"})
public class TestHttpServerSecurityHandler {
    @Inject
    @Named(value="test")
    private final HttpClient httpClient = null;
    @Inject
    private final Lifecycle lifecycle = null;
    private String baseUri = null;
    private int port = 0;

    @Before
    public void setUp() throws Exception {
        this.port = TestHttpServerSecurityHandler.findUnusedPort();
        Assert.assertFalse((this.port == 0 ? 1 : 0) != 0);
        this.baseUri = String.format("http://localhost:%d/foobar", this.port);
        Config config = Config.getFixedConfig((String[])new String[]{"galaxy.internal.port.http", Integer.toString(this.port)});
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigModule(config), new HttpServerModule(config), new HttpClientModule("test"), new LifecycleModule(), new GalaxyConfigModule(), new Module(){

            public void configure(Binder binder) {
                binder.requireExplicitBindings();
                binder.disableCircularProxies();
                HttpServerHandlerBinder.bindHandler((Binder)binder).toInstance((Object)new ClasspathResourceHandler("/foobar", "/test-resources"));
                HttpServerHandlerBinder.bindSecurityHandler((Binder)binder).to(VerbotenHandler.class).in(Scopes.SINGLETON);
            }
        }});
        injector.injectMembers((Object)this);
        this.lifecycle.executeTo(LifecycleStage.START_STAGE);
    }

    @After
    public void teardown() {
        this.lifecycle.executeTo(LifecycleStage.STOP_STAGE);
    }

    @Test
    public void testSimpleGet() throws Exception {
        ContentResponseHandler responseHandler = ContentResponseHandler.forConverter((ContentConverter)new HttpResponseContentConverter());
        HttpResponse response = (HttpResponse)this.httpClient.get(this.baseUri + "/simple-content.txt", (HttpClientResponseHandler)responseHandler).perform();
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Verboten!", (Object)new String(response.getBody(), Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findUnusedPort() throws IOException {
        int port;
        ServerSocket socket = new ServerSocket();
        try {
            socket.bind(new InetSocketAddress(0));
            port = socket.getLocalPort();
        }
        finally {
            socket.close();
        }
        return port;
    }

    @Singleton
    public static class VerbotenHandler
    extends HandlerWrapper {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (baseRequest.isHandled()) {
                return;
            }
            response.setStatus(403);
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write("Verboten!");
            baseRequest.setHandled(true);
        }
    }
}

