/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.syslog;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.galaxy.GalaxyConfig;
import com.nesscomputing.httpserver.log.LogFieldsModule;
import com.nesscomputing.httpserver.log.syslog.SyslogRequestLog;
import com.nesscomputing.httpserver.log.syslog.SyslogRequestLogModule;
import com.nesscomputing.syslog4j.Syslog;
import com.nesscomputing.syslog4j.SyslogConfigIF;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.AbstractSyslogWriter;
import com.nesscomputing.syslog4j.impl.net.AbstractNetSyslog;
import com.nesscomputing.syslog4j.impl.net.AbstractNetSyslogConfig;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.joda.time.DateTimeUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@AllowNetworkListen(ports={0})
public class SyslogRequestLogTest
extends EasyMockSupport {
    @Inject
    private SyslogRequestLog syslogRequestLog;

    @After
    public void tearDown() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void testInvalidLogPatternBadSpecifier() {
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.syslog.enabled", "true", "ness.httpserver.request-log.syslog.fields", "remoteAddr,foo"});
        try {
            Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new SyslogRequestLogModule(config)});
            inj.injectMembers((Object)this);
            Assert.fail();
        }
        catch (CreationException ce) {
            Assert.assertEquals(IllegalArgumentException.class, ce.getCause().getClass());
            Assert.assertEquals((Object)"Invalid log pattern: unknown field <foo>", (Object)ce.getCause().getMessage());
        }
    }

    @Test
    public void testInvalidLogPatternTooManyColons() {
        try {
            Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.syslog.enabled", "true", "ness.httpserver.request-log.syslog.fields", "remoteAddr,cookie:no-here:bar"});
            Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new SyslogRequestLogModule(config)});
            inj.injectMembers((Object)this);
            Assert.fail();
        }
        catch (CreationException ce) {
            Assert.assertEquals(IllegalArgumentException.class, ce.getCause().getClass());
            Assert.assertEquals((Object)"Bad specifier \"cookie:no-here:bar\" has too many colons", (Object)ce.getCause().getMessage());
        }
    }

    @Test
    public void testDefaultConfigWorks() {
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.syslog.enabled", "true"});
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new SyslogRequestLogModule(config)});
        inj.injectMembers((Object)this);
        Assert.assertNotNull((Object)this.syslogRequestLog);
    }

    @Test
    public void testDisabledByDefault() {
        Config config = Config.getEmptyConfig();
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new SyslogRequestLogModule(config)});
        Assert.assertNull((Object)inj.getExistingBinding(Key.get(SyslogRequestLog.class)));
    }

    @Test
    public void testMockRequestWithNullGalaxy() {
        this.testMockRequest(new Module(){

            public void configure(Binder binder) {
            }
        });
    }

    @Test
    public void testMockRequestWithEmptyGalaxyConfig() {
        this.testMockRequest((Module)new AbstractModule(){

            protected void configure() {
                this.bind(GalaxyConfig.class);
            }
        });
    }

    private void testMockRequest(Module extra) {
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.syslog.enabled", "true", "ness.httpserver.request-log.syslog.protocol", "fake"});
        Syslog.createInstance((String)"fake", (SyslogConfigIF)new AbstractNetSyslogConfig(){

            public Class<? extends SyslogIF> getSyslogClass() {
                return FakeSyslog.class;
            }
        });
        FakeSyslog fakeSyslog = (FakeSyslog)((Object)FakeSyslog.class.cast(Syslog.getInstance((String)"fake")));
        Assert.assertNotNull((Object)((Object)fakeSyslog));
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new SyslogRequestLogModule(config), new ConfigModule(config), extra});
        inj.injectMembers((Object)this);
        Assert.assertNotNull((Object)this.syslogRequestLog);
        Request req = (Request)this.createMock(Request.class);
        Response resp = (Response)this.createMock(Response.class);
        StringBuffer sb = new StringBuffer("/foo");
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)sb.toString()).anyTimes();
        EasyMock.expect((Object)req.getRequestURL()).andReturn((Object)sb).anyTimes();
        EasyMock.expect((Object)req.getTimeStamp()).andReturn((Object)10000L).anyTimes();
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"1.2.3.4").anyTimes();
        EasyMock.expect((Object)req.getHeader("Authorization")).andReturn((Object)"omgwtfbbq").anyTimes();
        EasyMock.expect((Object)req.getMethod()).andReturn((Object)"GET").anyTimes();
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)"bar=baz").anyTimes();
        EasyMock.expect((Object)resp.getStatus()).andReturn((Object)200).anyTimes();
        EasyMock.expect((Object)resp.getHeader("X-Trumpet-Track")).andReturn((Object)"12345678-1234-1234-1234-0123456789ab").anyTimes();
        EasyMock.expect((Object)resp.getHeader("Content-Length")).andReturn((Object)"42").anyTimes();
        this.replayAll();
        DateTimeUtils.setCurrentMillisFixed((long)11500L);
        this.syslogRequestLog.log(req, resp);
        this.verifyAll();
        Assert.assertEquals((long)1L, (long)fakeSyslog.getMessages().size());
        List<SyslogLevel> levels = fakeSyslog.getLevels();
        Assert.assertNotNull(levels);
        Assert.assertEquals((long)1L, (long)levels.size());
        Assert.assertEquals((Object)SyslogLevel.INFO, (Object)levels.get(0));
        Syslog.destroyInstance((String)"fake");
    }

    private Module disableStuff() {
        return new Module(){

            public void configure(Binder binder) {
                binder.disableCircularProxies();
                binder.requireExplicitBindings();
            }
        };
    }

    public static class FakeSyslog
    extends AbstractNetSyslog
    implements SyslogIF {
        final List<SyslogLevel> logLevels = Lists.newArrayList();
        final List<String> logMessages = Lists.newArrayList();

        public void flush() throws SyslogRuntimeException {
        }

        public void shutdown() throws SyslogRuntimeException {
        }

        protected synchronized void write(SyslogLevel level, byte[] message) throws SyslogRuntimeException {
            this.logLevels.add(level);
            this.logMessages.add(new String(message, this.getConfig().getCharSet()));
        }

        public AbstractSyslogWriter getWriter() {
            throw new UnsupportedOperationException();
        }

        public void returnWriter(AbstractSyslogWriter syslogWriter) {
            throw new UnsupportedOperationException();
        }

        public List<String> getMessages() {
            return this.logMessages;
        }

        public List<SyslogLevel> getLevels() {
            return this.logLevels;
        }
    }
}

