/*
 * Copyright 2017 @ursful.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ursful.framework.orm.support;

import com.ursful.framework.orm.query.QueryUtils;
import com.ursful.framework.orm.utils.ORMUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Columns implements Serializable {

    //as

	private List<Column> columns = new ArrayList<Column>();

    public Columns(){}

    private String alias;
    private String [] names;
    private String [] asNames;
    private String [] fieldNames;

    private String asNamePrefix;

    public String getAsNamePrefix() {
        return asNamePrefix;
    }

    public void setAsNamePrefix(String asNamePrefix) {
        this.asNamePrefix = asNamePrefix;
    }

    public Columns(String alias){
        this.alias = alias;
    }

	public Columns(String alias, String ... names){
        this.alias = alias;
        this.names = names;
    }


    public Columns names(String ... names){
        this.names = names;
        return this;
    }

    public <T,R> Columns lambdaQueryNames(LambdaQuery<T,R> ... lambdaQueries){
        this.names = QueryUtils.getColumns(lambdaQueries);
        return this;
    }

    public Columns asNames(String ... asNames){
        this.asNames = asNames;
        return this;
    }

    public Columns asNamePrefix(String asNamePrefix){
        this.asNamePrefix = asNamePrefix;
        return this;
    }

    public Columns fieldNames(String ... fieldNames){
        this.fieldNames = fieldNames;
        return this;
    }

    public Columns c(Column column){
        if(column != null){
           if(ORMUtils.isEmpty(column.getAlias()) && !ORMUtils.isEmpty(alias)){
               column.setAlias(alias);
           }
           columns.add(column);
        }
        return this;
    }

    public List<Column> getColumnList() {
        List<Column> columnList = new ArrayList<Column>();
        if(names != null && alias != null){
            String prefix = asNamePrefix == null?"":asNamePrefix;
            if(asNames == null){
                if(fieldNames == null) {
                    for (String name : names) {
                        if(ORMUtils.isEmpty(prefix)) {
                            columnList.add(new Column(alias, name));
                        }else{
                            columnList.add(new Column(alias, name).as(prefix + name));
                        }
                    }
                }else{
                    if(names.length == fieldNames.length){
                        for(int i = 0; i < names.length; i++){
                            if(ORMUtils.isEmpty(prefix)) {
                                columnList.add(new Column(alias, names[i]).fieldName(fieldNames[i]));
                            }else{
                                columnList.add(new Column(alias, names[i]).as(prefix + names[i]).fieldName(fieldNames[i]));
                            }
                        }
                    }else{
                        throw new RuntimeException("TABLE_QUERY_NAMES_AS_NOT_EQUAL, names length: " +
                                names.length + ", fieldNames length : " + fieldNames.length);
                    }
                }
            }else{
                if(names.length == asNames.length){
                    if(fieldNames != null) {
                        if (names.length == fieldNames.length) {
                            for (int i = 0; i < names.length; i++) {
                                columnList.add(new Column(alias, names[i], prefix + asNames[i]).fieldName(fieldNames[i]));
                            }
                        } else {
                            throw new RuntimeException("TABLE_QUERY_NAMES_AS_NOT_EQUAL, names length: " +
                                    names.length + ", fieldNames length : " + fieldNames.length);
                        }
                    }else {
                        for (int i = 0; i < names.length; i++) {
                            columnList.add(new Column(alias, names[i], prefix + asNames[i]));
                        }
                    }
                }else{
                    throw new RuntimeException("TABLE_QUERY_NAMES_AS_NOT_EQUAL, names length: " +
                            names.length + ", asNames length : " + asNames.length);
                }
            }
        }
        columnList.addAll(columns);
        return columnList;
    }

}