/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.query;

import com.objectsql.IQuery;
import com.objectsql.handler.IQueryConvert;
import com.objectsql.query.QueryUtils;
import com.objectsql.support.Condition;
import com.objectsql.support.ConditionObject;
import com.objectsql.support.Expression;
import com.objectsql.support.ExpressionType;
import com.objectsql.support.Options;
import com.objectsql.support.Order;
import com.objectsql.support.Pageable;
import com.objectsql.support.TextTransformType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class QueryImpl
implements IQuery {
    private String id;
    private Pageable pageable;
    protected boolean distinct = false;
    protected List<Condition> conditions = new ArrayList<Condition>();
    protected List<Condition> havings = new ArrayList<Condition>();
    protected boolean dataPermission = true;
    protected List<Order> orders = new ArrayList<Order>();
    protected TextTransformType textTransformType = TextTransformType.UPPER;
    protected boolean lessDatePlus = false;
    protected boolean lessEqualDatePlus = false;
    protected Options options;
    private IQueryConvert queryConvert;

    @Override
    public IQueryConvert getQueryConvert() {
        return this.queryConvert;
    }

    @Override
    public void setQueryConvert(IQueryConvert queryConvert) {
        this.queryConvert = queryConvert;
    }

    protected void addCondition(Condition condition) {
        if (condition != null) {
            this.resetLessOrLessEqualDate(condition);
            this.conditions.add(condition);
        }
    }

    protected void addHaving(Condition condition) {
        if (condition != null) {
            this.resetLessOrLessEqualDate(condition);
            this.havings.add(condition);
        }
    }

    private void resetLessOrLessEqualDate(Condition condition) {
        List<ConditionObject> conditionObjects = condition.getConditions();
        for (ConditionObject conditionObject : conditionObjects) {
            Expression[] expressions;
            Object object = conditionObject.getObject();
            if (object instanceof Condition) {
                this.resetLessOrLessEqualDate((Condition)object);
                continue;
            }
            if (object instanceof Expression) {
                this.resetLessOrLessEqualDate((Expression)object);
                continue;
            }
            if (!(object instanceof Expression[])) continue;
            for (Expression expression : expressions = (Expression[])object) {
                this.resetLessOrLessEqualDate(expression);
            }
        }
    }

    private void resetLessOrLessEqualDate(Expression expression) {
        if (expression != null) {
            if (expression.getType() == ExpressionType.CDT_LESS) {
                if (this.isLessDatePlus235959() && expression.getValue() instanceof Date) {
                    expression.setValue(QueryUtils.plusDate235959((Date)expression.getValue()));
                }
            } else if (expression.getType() == ExpressionType.CDT_LESS_EQUAL && this.isLessEqualDatePlus235959() && expression.getValue() instanceof Date) {
                expression.setValue(QueryUtils.plusDate235959((Date)expression.getValue()));
            }
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<Condition> getHavings() {
        return this.havings;
    }

    @Override
    public List<Order> getOrders() {
        return this.orders;
    }

    @Override
    public void setDataPermission(boolean allowed) {
        this.dataPermission = allowed;
    }

    @Override
    public boolean dataPermission() {
        return this.dataPermission;
    }

    @Override
    public TextTransformType textTransformType() {
        return this.textTransformType;
    }

    @Override
    public void setTextTransformType(TextTransformType textTransformType) {
        this.textTransformType = textTransformType;
    }

    @Override
    public boolean isLessEqualDatePlus235959() {
        return this.lessEqualDatePlus;
    }

    @Override
    public boolean isLessDatePlus235959() {
        return this.lessDatePlus;
    }

    @Override
    public void enableLessOrLessEqualDatePlus235959() {
        this.lessDatePlus = true;
        this.lessEqualDatePlus = true;
    }

    @Override
    public void enableLessDatePlus235959() {
        this.lessDatePlus = true;
    }

    @Override
    public void enableLessEqualDatePlus235959() {
        this.lessEqualDatePlus = true;
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    @Override
    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

