/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.utils;

import com.objectsql.annotation.RdColumn;
import com.objectsql.annotation.RdId;
import com.objectsql.annotation.RdObject;
import com.objectsql.annotation.RdTable;
import com.objectsql.exception.ORMException;
import com.objectsql.support.ColumnInfo;
import com.objectsql.support.ColumnType;
import com.objectsql.support.DebugHandler;
import com.objectsql.support.LambdaQuery;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.annotation.AnnotationUtils;

public class ORMUtils {
    private static boolean isTrim = false;
    private static boolean lowerCaseSql = false;
    private static int runningMode = -1;
    private static DebugHandler debugHandler;
    private static Map<Class, List<ColumnInfo>> columnInfoCache;
    private static Map<Class, String> tableNameCache;
    private static Map<Class, RdTable> rdTableCache;
    private static Map<Class, List<ColumnInfo>> extendFieldCache;

    public static void handleDebugInfo(Class<?> clazz, String msg, Object ... object) {
        if (debugHandler != null) {
            debugHandler.handle(clazz, msg, object);
        }
    }

    public static void registerDebugHandler(DebugHandler handler) {
        debugHandler = handler;
    }

    public static void setRunningMode(int runningMode) {
    }

    public static int getRunningMode() {
        return runningMode;
    }

    public static void enableLowerCaseSql(boolean lowerCase) {
        lowerCaseSql = lowerCase;
    }

    public static boolean isLowerCaseSql() {
        return lowerCaseSql;
    }

    public static String convertSQL(String sql) {
        if (sql != null) {
            if (lowerCaseSql) {
                return sql.toLowerCase(Locale.ROOT);
            }
            return sql.toUpperCase(Locale.ROOT);
        }
        return sql;
    }

    public static boolean isTrim() {
        return isTrim;
    }

    public static void enableTrim(boolean trim) {
        isTrim = trim;
    }

    public static String getTableName(Class clazz) {
        if (tableNameCache.containsKey(clazz)) {
            return tableNameCache.get(clazz);
        }
        RdTable table = (RdTable)AnnotationUtils.findAnnotation((Class)clazz, RdTable.class);
        if (table == null) {
            throw new ORMException("Table not found Class(" + clazz.getName() + ")");
        }
        String tableName = table.name();
        rdTableCache.put(clazz, table);
        tableNameCache.put(clazz, tableName);
        return tableName;
    }

    public static RdTable getRdTable(Class clazz) {
        if (rdTableCache.containsKey(clazz)) {
            return rdTableCache.get(clazz);
        }
        RdTable table = (RdTable)AnnotationUtils.findAnnotation((Class)clazz, RdTable.class);
        if (table == null) {
            return null;
        }
        String tableName = table.name();
        rdTableCache.put(clazz, table);
        tableNameCache.put(clazz, tableName);
        return table;
    }

    public static void setFieldValue(Object object, ColumnInfo info, Object value) {
        ORMUtils.setFieldValue(object, info.getField(), value);
    }

    public static void setFieldValue(Object object, Field field, Object value) {
        if (object == null || value == null || field == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new ORMException("Set value to [" + object + "] error, value[" + value + "]");
        }
    }

    public static void setFieldNullValue(Object object, Field field) {
        if (object == null || field == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(object, null);
        }
        catch (IllegalAccessException e) {
            throw new ORMException("Set value to [" + object + "] error, value[NULL]");
        }
    }

    public static Object getFieldValue(Object object, Field field) {
        if (object == null || field == null) {
            return null;
        }
        Object result = null;
        try {
            field.setAccessible(true);
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new ORMException("Get value from [" + object + "] error!");
        }
        return result;
    }

    public static Object getFieldValue(Object object, ColumnInfo info) {
        return ORMUtils.getFieldValue(object, info.getField());
    }

    public static void whenEmpty(Object object, String message) {
        if (ORMUtils.isEmpty(object)) {
            throw new ORMException(message);
        }
    }

    public static void whenTrue(boolean flag, String message) {
        if (flag) {
            throw new ORMException(message);
        }
    }

    private static List<ColumnInfo> analyze(Class<?> clazz) {
        ArrayList<ColumnInfo> infoList = new ArrayList<ColumnInfo>();
        List<Field> fields = ORMUtils.getDeclaredFields(clazz);
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            RdColumn column = field.getAnnotation(RdColumn.class);
            if (column == null || fieldNames.contains(field.getName())) continue;
            fieldNames.add(field.getName());
            ColumnInfo info = new ColumnInfo();
            info.setField(field);
            info.setOrder(column.order());
            info.setName(field.getName());
            info.setColumnName(column.name());
            info.setColumnType(column.type());
            info.setType(field.getType().getSimpleName());
            RdId id = field.getAnnotation(RdId.class);
            if (id != null) {
                info.setPrimaryKey(true);
                infoList.add(0, info);
                continue;
            }
            infoList.add(info);
        }
        infoList.sort(new Comparator<ColumnInfo>(){

            @Override
            public int compare(ColumnInfo o1, ColumnInfo o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        columnInfoCache.put(clazz, infoList);
        return infoList;
    }

    public static <T> List<T> newList(T ... ts) {
        ArrayList<T> temp = new ArrayList<T>();
        if (ts == null) {
            return temp;
        }
        for (T t : ts) {
            temp.add(t);
        }
        return temp;
    }

    private static Type[] getTypes(Type type) {
        Type[] types = null;
        if (type instanceof ParameterizedType) {
            types = ((ParameterizedType)type).getActualTypeArguments();
        } else {
            Type[] temp = ((Class)type).getGenericInterfaces();
            if (temp.length > 0) {
                types = ORMUtils.getTypes(temp[0]);
            }
        }
        return types;
    }

    public static boolean isTheSameClass(Class<?> thisClass, Class<?> clazz) {
        RdObject object = (RdObject)AnnotationUtils.findAnnotation(clazz, RdObject.class);
        if (object != null) {
            String[] prefixes;
            String[] patterns;
            Class<?>[] classes = object.classes();
            if (classes != null) {
                for (Class<?> c : classes) {
                    if (!thisClass.isAssignableFrom(c)) continue;
                    return true;
                }
            }
            if ((patterns = object.patterns()) != null) {
                for (String pattern : patterns) {
                    if (thisClass.getName().startsWith(pattern)) {
                        return true;
                    }
                    Pattern p = Pattern.compile(pattern);
                    Matcher matcher = p.matcher(thisClass.getName());
                    if (!matcher.find()) continue;
                    return true;
                }
            }
            if ((prefixes = object.prefixes()) != null) {
                for (String prefix : prefixes) {
                    if (!thisClass.getName().startsWith(prefix)) continue;
                    return true;
                }
            }
            return false;
        }
        Type[] ts = clazz.getGenericInterfaces();
        if (ts.length > 0) {
            try {
                Type[] types = ORMUtils.getTypes(ts[0]);
                if (types.length > 0) {
                    Class tp = (Class)types[0];
                    if (thisClass.isAssignableFrom(tp)) {
                        return true;
                    }
                    if (Object.class.getName().equals(tp.getName())) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if ("".equals(object.toString())) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        return false;
    }

    public static String join(String[] words, String key) {
        StringBuffer sb = new StringBuffer();
        if (words != null) {
            for (String word : words) {
                if (ORMUtils.isEmpty(word)) continue;
                if (sb.length() == 0) {
                    sb.append(word);
                    continue;
                }
                sb.append(key + word);
            }
        }
        return sb.toString();
    }

    public static String join(List<String> words, String key) {
        StringBuffer sb = new StringBuffer();
        if (words != null) {
            for (String word : words) {
                if (ORMUtils.isEmpty(word)) continue;
                if (sb.length() == 0) {
                    sb.append(word);
                    continue;
                }
                sb.append(key + word);
            }
        }
        return sb.toString();
    }

    public static Map<String, ColumnType> getColumnType(Class<?> clazz) {
        HashMap<String, ColumnType> temp = new HashMap<String, ColumnType>();
        List<ColumnInfo> infoList = columnInfoCache.get(clazz);
        if (infoList == null) {
            infoList = ORMUtils.analyze(clazz);
        }
        if (infoList != null) {
            for (ColumnInfo info : infoList) {
                temp.put(info.getColumnName(), info.getColumnType());
            }
        }
        return temp;
    }

    public static Map<String, String> getFieldColumn(Class<?> clazz) {
        HashMap<String, String> temp = new HashMap<String, String>();
        List<ColumnInfo> infoList = columnInfoCache.get(clazz);
        if (infoList == null) {
            infoList = ORMUtils.analyze(clazz);
        }
        if (infoList != null) {
            for (ColumnInfo info : infoList) {
                temp.put(info.getName(), info.getColumnName());
            }
        }
        return temp;
    }

    public static String getFieldByColumn(Class<?> clazz, String columnName) {
        Map<String, String> map = ORMUtils.getColumnField(clazz);
        return map.get(columnName);
    }

    public static <T, R> String getFieldByColumn(Class<?> clazz, LambdaQuery<T, R> lambdaQuery) {
        if (lambdaQuery != null) {
            Map<String, String> map = ORMUtils.getColumnField(clazz);
            return map.get(lambdaQuery.getColumnName());
        }
        return null;
    }

    public static Map<String, String> getColumnField(Class<?> clazz) {
        HashMap<String, String> temp = new HashMap<String, String>();
        List<ColumnInfo> infoList = columnInfoCache.get(clazz);
        if (infoList == null) {
            infoList = ORMUtils.analyze(clazz);
        }
        if (infoList != null) {
            for (ColumnInfo info : infoList) {
                temp.put(info.getColumnName(), info.getName());
            }
        }
        return temp;
    }

    public static void copyPropertiesWhenUpdateNull(Object from, Object to, String ... columns) {
        if (from == null || to == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (columns != null && columns.length > 0) {
            list.addAll(Arrays.asList(columns));
        }
        if (from.getClass() == to.getClass()) {
            Class<?> clazz = to.getClass();
            List<ColumnInfo> columnInfos = ORMUtils.getColumnInfo(clazz);
            ORMUtils.whenTrue(columnInfos == null, "Get columns cache is empty.");
            for (ColumnInfo info : columnInfos) {
                Object fromValue = ORMUtils.getFieldValue(from, info);
                if (ORMUtils.isEmpty(fromValue)) {
                    if (!list.contains(info.getColumnName())) continue;
                    ORMUtils.setFieldNullValue(to, info.getField());
                    continue;
                }
                ORMUtils.setFieldValue(to, info, fromValue);
            }
        }
    }

    public static List<String> getFields(Class<?> clazz) {
        ArrayList<String> temp = new ArrayList<String>();
        List<ColumnInfo> infoList = columnInfoCache.get(clazz);
        if (infoList == null) {
            infoList = ORMUtils.analyze(clazz);
        }
        if (infoList != null) {
            for (ColumnInfo info : infoList) {
                temp.add(info.getName());
            }
        }
        return temp;
    }

    public static Map<String, ColumnInfo> getFieldColumnInfo(Class<?> clazz) {
        HashMap<String, ColumnInfo> result = new HashMap<String, ColumnInfo>();
        List<ColumnInfo> columnInfoList = ORMUtils.getColumnInfo(clazz);
        if (columnInfoList != null) {
            for (ColumnInfo columnInfo : columnInfoList) {
                result.put(columnInfo.getName(), columnInfo);
            }
        }
        return result;
    }

    public static Map<String, ColumnInfo> getColumnColumnInfo(Class<?> clazz) {
        HashMap<String, ColumnInfo> result = new HashMap<String, ColumnInfo>();
        List<ColumnInfo> columnInfoList = ORMUtils.getColumnInfo(clazz);
        if (columnInfoList != null) {
            for (ColumnInfo columnInfo : columnInfoList) {
                result.put(columnInfo.getColumnName(), columnInfo);
            }
        }
        return result;
    }

    public static List<ColumnInfo> getColumnInfo(Class<?> clazz) {
        List<ColumnInfo> infoList = columnInfoCache.get(clazz);
        if (infoList == null) {
            infoList = ORMUtils.analyze(clazz);
        }
        return infoList;
    }

    public static List<String> getColumns(Class<?> clazz) {
        ArrayList<String> temp = new ArrayList<String>();
        List<ColumnInfo> infoList = columnInfoCache.get(clazz);
        if (infoList == null) {
            infoList = ORMUtils.analyze(clazz);
        }
        if (infoList != null) {
            for (ColumnInfo info : infoList) {
                temp.add(info.getColumnName());
            }
        }
        return temp;
    }

    public static List<Field> getDeclaredFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<Field> temp = new ArrayList<Field>();
        if (clazz == null) {
            return temp;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            RdColumn column = field.getAnnotation(RdColumn.class);
            if (column == null) continue;
            temp.add(field);
        }
        Class<?> tmp = clazz.getSuperclass();
        temp.addAll(ORMUtils.getDeclaredFields(tmp));
        return temp;
    }

    public static List<ColumnInfo> getExtendFields(Class<?> clazz) {
        List<ColumnInfo> infoList = extendFieldCache.get(clazz);
        if (infoList == null) {
            List<Field> fields = ORMUtils.getDeclaredExtendFields(clazz);
            infoList = new ArrayList<ColumnInfo>();
            for (Field field : fields) {
                ColumnInfo info = new ColumnInfo();
                info.setField(field);
                info.setName(field.getName());
                info.setType(field.getType().getSimpleName());
                infoList.add(info);
            }
            extendFieldCache.put(clazz, infoList);
        }
        return infoList;
    }

    public static List<Field> getDeclaredExtendFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<Field> temp = new ArrayList<Field>();
        if (clazz == null) {
            return temp;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            RdColumn column = field.getAnnotation(RdColumn.class);
            if (column != null) continue;
            temp.add(field);
        }
        Class<?> tmp = clazz.getSuperclass();
        temp.addAll(ORMUtils.getDeclaredExtendFields(tmp));
        return temp;
    }

    static {
        columnInfoCache = new ConcurrentHashMap<Class, List<ColumnInfo>>();
        tableNameCache = new ConcurrentHashMap<Class, String>();
        rdTableCache = new ConcurrentHashMap<Class, RdTable>();
        extendFieldCache = new ConcurrentHashMap<Class, List<ColumnInfo>>();
    }
}

