/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.option;

import com.objectsql.annotation.RdColumn;
import com.objectsql.annotation.RdForeignKey;
import com.objectsql.annotation.RdId;
import com.objectsql.annotation.RdTable;
import com.objectsql.annotation.RdUniqueKey;
import com.objectsql.exception.ORMException;
import com.objectsql.helper.SQLHelper;
import com.objectsql.option.AbstractOptions;
import com.objectsql.query.IQuery;
import com.objectsql.query.MultiQuery;
import com.objectsql.support.ColumnInfo;
import com.objectsql.support.ColumnType;
import com.objectsql.support.Condition;
import com.objectsql.support.DataType;
import com.objectsql.support.MultiOrder;
import com.objectsql.support.OperatorType;
import com.objectsql.support.Pageable;
import com.objectsql.support.Pair;
import com.objectsql.support.QueryInfo;
import com.objectsql.support.Table;
import com.objectsql.support.TableColumn;
import com.objectsql.support.TextTransformType;
import com.objectsql.utils.ORMUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class SQLServerOptions
extends AbstractOptions {
    @Override
    public String keyword() {
        return "server";
    }

    @Override
    public boolean preSetParameter(PreparedStatement ps, Connection connection, String databaseType, int i, Pair pair) throws SQLException {
        Object obj = pair.getValue();
        ColumnType columnType = pair.getColumnType();
        DataType type = DataType.getDataType(pair.getType());
        if (type == DataType.DATE && columnType != ColumnType.LONG && columnType != ColumnType.DATETIME && obj != null) {
            ps.setTimestamp(i + 1, null);
            return true;
        }
        return false;
    }

    @Override
    public String getColumnWithOperator(OperatorType operatorType, String name, String value) {
        String result = null;
        switch (operatorType) {
            case XOR: {
                result = "(" + name + "+" + value + " - 2*(" + name + "&" + value + "))";
                break;
            }
            case LL: {
                result = "(" + name + "*POWER(2," + value + "))";
                break;
            }
            case RR: {
                result = "FLOOR(" + name + "/POWER(2," + value + ")";
            }
        }
        return result;
    }

    @Override
    public String getColumnWithOperatorAndFunction(String function, boolean inFunction, OperatorType operatorType, String name, String value) {
        String result = null;
        switch (operatorType) {
            case XOR: {
                if (inFunction) {
                    result = function + "(" + name + "+" + value + " - 2*(" + name + "&" + value + "))";
                    break;
                }
                result = "(" + function + "(" + name + ")+" + value + " - 2*(" + function + "(" + name + ")&" + value + "))";
                break;
            }
            case LL: {
                if (inFunction) {
                    result = function + "(" + name + "*POWER(2," + value + "))";
                    break;
                }
                result = "(" + function + "(" + name + ")*POWER(2," + value + "))";
                break;
            }
            case RR: {
                result = inFunction ? function + "(FLOOR(" + name + "/POWER(2," + value + "))" : "FLOOR(" + function + "(" + name + ")/POWER(2," + value + ")";
            }
        }
        if (result == null) {
            result = inFunction ? function + "(" + name + operatorType.getOperator() + value + ")" : "(" + function + "(" + name + ")" + operatorType.getOperator() + value + ")";
        }
        return result;
    }

    @Override
    public String databaseType() {
        return "SQLServer";
    }

    @Override
    public String nanoTimeSQL() {
        return "SELECT GETDATE()";
    }

    private List<String> tableConstraints(Connection connection) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String sql = "SELECT NAME AS INDEX_NAME FROM SYS.ALL_OBJECTS WHERE TYPE='UQ' OR TYPE='F' OR TYPE='PK'";
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) continue;
                names.add(indexName.toUpperCase(Locale.ROOT));
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return names;
    }

    @Override
    public QueryInfo doQuery(IQuery query, Pageable page) {
        QueryInfo info = new QueryInfo();
        ArrayList<Pair> values = new ArrayList<Pair>();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        HashMap<String, String> asNames = new HashMap<String, String>();
        sb.append(this.selectColumns(query, null, asNames, values));
        String group = this.groups(query, null);
        if (page != null && ORMUtils.isEmpty(group)) {
            String byOrders = this.orders(query, null, asNames);
            if (!ORMUtils.isEmpty(byOrders)) {
                sb.append(" ,row_number() over(" + byOrders + ") rn_ ");
            } else {
                sb.append(" ,row_number() over(order by (select 0)) rn_ ");
            }
        }
        sb.append(" FROM ");
        sb.append(this.tables(query, values, null));
        if (query instanceof MultiQuery) {
            sb.append(this.joins((MultiQuery)query, values));
        }
        sb.append(this.wheres(query, values, null));
        sb.append(this.groups(query, null));
        sb.append(this.havings(query, values, null));
        if (page != null) {
            String tempSQL = sb.toString();
            sb = new StringBuffer("SELECT TOP " + page.getSize() + " * ");
            sb.append(" FROM (");
            if (ORMUtils.isEmpty(group)) {
                sb.append(tempSQL);
            } else {
                sb.append("SELECT sqlserver_.*, ROW_NUMBER() OVER(ORDER BY (SELECT 0)) RN_ FROM (" + tempSQL + ") as sqlserver_ ");
            }
            sb.append(") ms_ ");
            sb.append(" WHERE ms_.rn_ > " + page.getOffset() + " ");
        } else {
            sb.append(this.orders(query, null, asNames));
        }
        info.setClazz(query.getReturnClass());
        info.setSql(sb.toString());
        info.setValues(values);
        info.setColumns(query.getFinalReturnColumns());
        if (TextTransformType.LOWER == query.textTransformType()) {
            info.setSql(info.getSql().toLowerCase(Locale.ROOT));
        } else if (TextTransformType.UPPER == query.textTransformType()) {
            info.setSql(info.getSql().toUpperCase(Locale.ROOT));
        }
        return info;
    }

    @Override
    public SQLHelper doQuery(Class<?> clazz, String schema, String[] names, Condition condition, MultiOrder multiOrder, Integer start, Integer size) {
        String conditions;
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("SELECT ");
        String nameStr = ORMUtils.join(names, ",");
        if (ORMUtils.isEmpty(nameStr)) {
            sql.append("*");
        } else {
            sql.append(nameStr);
        }
        if (start != null && size != null) {
            String orders;
            String byOrders = null;
            if (multiOrder != null && !ORMUtils.isEmpty(orders = this.getOrders(multiOrder.getOrders(), clazz))) {
                byOrders = orders;
            }
            if (byOrders != null) {
                sql.append(" ,row_number() over(order by " + byOrders + ") rn_ ");
            } else {
                sql.append(" ,row_number() over(order by (select 0)) rn_ ");
            }
        }
        sql.append(" FROM " + tableName);
        ArrayList<Pair> values = new ArrayList<Pair>();
        if (condition != null && !ORMUtils.isEmpty(conditions = this.getConditions(clazz, ORMUtils.newList(condition), values))) {
            sql.append(" WHERE " + conditions);
        }
        if (size != null && size > 0) {
            if (start == null) {
                start = 0;
            }
            String tempSQL = sql.toString();
            sql = new StringBuffer("SELECT TOP " + size + " * ");
            sql.append(" FROM (");
            sql.append(tempSQL);
            sql.append(") ms_ ");
            sql.append(" WHERE ms_.rn_ > " + (Math.max(1, start) - 1) * size + " ");
        } else {
            String orders;
            String byOrders = null;
            if (multiOrder != null && !ORMUtils.isEmpty(orders = this.getOrders(multiOrder.getOrders(), clazz))) {
                byOrders = " ORDER BY " + orders;
            }
            if (byOrders != null) {
                sql.append(byOrders);
            }
        }
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(values);
        return helper;
    }

    @Override
    public boolean tableExists(Connection connection, String schema, String tableName) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            String schemaName = connection.getSchema();
            String sql = String.format("select * from %s.sysobjects where id = object_id('%s') and type = 'U'", schemaName, tableName);
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public Table table(Connection connection, String schema, RdTable rdTable) throws ORMException {
        String tableName = this.getTableName(rdTable);
        Table table = new Table(tableName);
        table.setSensitive(rdTable.sensitive());
        return this.table(connection, schema, table);
    }

    @Override
    public Table table(Connection connection, String schema, Table tab) {
        Statement ps = null;
        ResultSet rs = null;
        Table table = null;
        String tableName = this.getCaseSensitive(tab.getName(), tab.getSensitive());
        try {
            String schemaName = connection.getSchema();
            String sql = String.format("select name from %s.sysobjects where id = object_id('%s') and type = 'U'", schemaName, tableName);
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                table = new Table(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (table != null) {
            try {
                String sql = String.format(" SELECT o.name, p.value FROM sys.extended_properties p         LEFT JOIN sysobjects o ON p.major_id= o.id        WHERE  p.minor_id=0 and o.name= '%s'", tableName);
                ps = connection.prepareStatement(sql);
                rs = ps.executeQuery();
                if (rs.next()) {
                    table.setComment(rs.getString(2));
                }
            }
            catch (SQLException e) {
                throw new ORMException(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return table;
    }

    @Override
    public List<TableColumn> columns(Connection connection, String schema, RdTable rdTable) {
        String tableName = this.getCaseSensitive(rdTable.name(), rdTable.sensitive());
        return this.columns(connection, schema, tableName);
    }

    @Override
    public List<TableColumn> columns(Connection connection, String schema, String tableName) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        Statement ps = null;
        ResultSet rs = null;
        String primaryKey = null;
        try {
            String sql = String.format("SELECT colm.name FROM sys.columns colm, sys.indexes idx, sys.index_columns ic where idx.index_id = ic.index_id and colm.column_id  = ic.column_id  and idx.object_id = ic.object_id and colm.object_id = idx.object_id and idx.is_primary_key = 1  and idx.object_id = OBJECT_ID('%s') ", tableName);
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                primaryKey = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            String schemaName = connection.getSchema();
            String sql = String.format("select g.value AS COMMENT,e.text as VALUE,b.name AS TYPE, a.colorder, a.name,a.prec, a.scale, a.isnullable, a.xprec, a.xscale from dbo.syscolumns a left join sys.extended_properties g on a.id=g.major_id and a.colid=g.minor_id left join syscomments e on a.cdefault=e.id left join systypes b on a.xusertype=b.xusertype where a.id = object_id('%s') ", tableName);
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                TableColumn tableColumn = new TableColumn(tableName, rs.getString("NAME"));
                tableColumn.setType(rs.getString("TYPE"));
                tableColumn.setLength(rs.getLong("PREC"));
                tableColumn.setPrecision(rs.getInt("XPREC"));
                tableColumn.setScale(rs.getInt("XSCALE"));
                tableColumn.setNullable("1".equalsIgnoreCase(rs.getString("ISNULLABLE")));
                tableColumn.setOrder(rs.getInt("COLORDER"));
                tableColumn.setDefaultValue(rs.getString("VALUE"));
                tableColumn.setComment(rs.getString("COMMENT"));
                tableColumn.setIsPrimaryKey(tableColumn.getColumn().equalsIgnoreCase(primaryKey));
                columns.add(tableColumn);
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return columns;
    }

    @Override
    public List<String> createOrUpdateSqls(Connection connection, String schema, RdTable table, List<ColumnInfo> infos, boolean tableExisted, List<TableColumn> tableColumns) {
        String tableName = this.getCaseSensitive(table.name(), table.sensitive());
        ArrayList<String> sqls = new ArrayList<String>();
        List<String> constraints = this.tableConstraints(connection);
        if (table.dropped()) {
            if (tableExisted) {
                sqls.add(String.format("DROP TABLE %s", tableName));
            }
        } else if (tableExisted) {
            HashMap<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
            for (TableColumn column : tableColumns) {
                columnMap.put(column.getColumn(), column);
            }
            for (ColumnInfo info : infos) {
                String foreignSQL;
                String uniqueSQL;
                String columnName = this.getCaseSensitive(info.getColumnName(), table.sensitive());
                TableColumn tableColumn = (TableColumn)columnMap.get(columnName);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                String comment = this.columnComment(rdColumn);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                if (tableColumn != null) {
                    if (rdColumn.dropped()) {
                        sqls.add(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName));
                    } else {
                        boolean needUpdate = false;
                        boolean isNumber = false;
                        if ("NVARCHAR".equalsIgnoreCase(tableColumn.getType()) || "NCHAR".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getLength() == null) continue;
                            if (tableColumn.getLength().intValue() != rdColumn.length()) {
                                needUpdate = true;
                            }
                        } else if ("DECIMAL".equalsIgnoreCase(tableColumn.getType())) {
                            isNumber = true;
                            if (tableColumn.getPrecision() == null || tableColumn.getScale() == null) continue;
                            if ("Date".equalsIgnoreCase(info.getType())) {
                                if (tableColumn.getPrecision().intValue() != rdColumn.precision() || tableColumn.getScale() != 0) {
                                    needUpdate = true;
                                }
                            } else if (tableColumn.getPrecision().intValue() != rdColumn.precision() || tableColumn.getScale().intValue() != rdColumn.scale()) {
                                needUpdate = true;
                            }
                        } else {
                            String type = this.getColumnType(info, rdColumn).toUpperCase(Locale.ROOT);
                            if (!type.startsWith(tableColumn.getType().toUpperCase(Locale.ROOT))) {
                                needUpdate = true;
                            }
                        }
                        if (!needUpdate && !ORMUtils.isEmpty(tableColumn.getDefaultValue())) {
                            String defaultValue = tableColumn.getDefaultValue();
                            if (defaultValue.startsWith("('") && defaultValue.endsWith("')")) {
                                defaultValue = defaultValue.substring(2, defaultValue.length() - 2);
                            }
                            if (isNumber) {
                                needUpdate = ORMUtils.isEmpty(rdColumn.defaultValue()) ? true : new BigDecimal(tableColumn.getDefaultValue()).compareTo(new BigDecimal(rdColumn.defaultValue())) != 0;
                            } else if (!defaultValue.equals(rdColumn.defaultValue())) {
                                needUpdate = true;
                            }
                        }
                        RdId rdId = info.getField().getAnnotation(RdId.class);
                        if (!needUpdate && tableColumn.isNullable() != rdColumn.nullable() && !tableColumn.isPrimaryKey() && rdId == null) {
                            needUpdate = true;
                        }
                        if (needUpdate) {
                            String temp = this.columnString(info, table.sensitive(), rdColumn, false);
                            sqls.add(String.format("ALTER TABLE %s ALTER COLUMN %s", tableName, temp));
                            if (!ORMUtils.isEmpty(comment) && !comment.equals(tableColumn.getComment())) {
                                sqls.add(String.format("EXECUTE sp_addextendedproperty N'MS_Description',N'%s',N'user',N'dbo',N'table',N'%s',N'column',N'%s'", comment, tableName, columnName));
                            }
                        }
                    }
                } else if (!rdColumn.dropped()) {
                    String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                    sqls.add(String.format("ALTER TABLE %s ADD %s", tableName, temp));
                    if (!ORMUtils.isEmpty(comment)) {
                        sqls.add(String.format("EXECUTE sp_addextendedproperty N'MS_Description',N'%s',N'user',N'dbo',N'table',N'%s',N'column',N'%s'", comment, tableName, columnName));
                    }
                }
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    sqls.add("ALTER TABLE " + tableName + " ADD " + uniqueSQL);
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                sqls.add("ALTER TABLE " + tableName + " ADD " + foreignSQL);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE " + tableName + "(");
            ArrayList<String> columnSQL = new ArrayList<String>();
            ArrayList<String> comments = new ArrayList<String>();
            for (int i = 0; i < infos.size(); ++i) {
                String foreignSQL;
                String uniqueSQL;
                ColumnInfo info = infos.get(i);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                String comment = this.columnComment(rdColumn);
                String columnName = this.getCaseSensitive(rdColumn.name(), table.sensitive());
                if (!ORMUtils.isEmpty(comment)) {
                    comments.add(String.format("EXECUTE sp_addextendedproperty N'MS_Description',N'%s',N'user',N'dbo',N'table',N'%s',N'column',N'%s'", comment, tableName, columnName));
                }
                columnSQL.add(temp.toString());
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    columnSQL.add(uniqueSQL);
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                columnSQL.add(foreignSQL);
            }
            sql.append(ORMUtils.join(columnSQL, ","));
            sql.append(")");
            sql.append(";");
            sqls.add(sql.toString());
            String comment = table.comment();
            if (!ORMUtils.isEmpty(comment)) {
                sqls.add(String.format("EXECUTE sp_addextendedproperty N'MS_Description',N'%s',N'user',N'dbo',N'table',N'%s',NULL,NULL", comment, tableName));
            }
            sqls.addAll(comments);
        }
        return sqls;
    }

    @Override
    public String dropTable(String schema, Table table) {
        return String.format("DROP TABLE %s", table.getName());
    }

    @Override
    public List<String> createOrUpdateSqls(Connection connection, String schema, Table table, List<TableColumn> columns, List<TableColumn> tableColumns, boolean tableExisted) {
        String tableName = this.getCaseSensitive(table.getName(), table.getSensitive());
        ArrayList<String> sqls = new ArrayList<String>();
        List<String> constraints = this.tableConstraints(connection);
        if (tableExisted) {
            HashMap<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
            for (TableColumn column : tableColumns) {
                columnMap.put(column.getColumn(), column);
            }
            for (TableColumn tc : columns) {
                String columnName = this.getCaseSensitive(tc.getColumn(), table.getSensitive());
                TableColumn tableColumn = (TableColumn)columnMap.get(columnName);
                String comment = tc.getComment();
                if (tableColumn != null) {
                    if (tc.isDropped()) {
                        sqls.add(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName));
                        continue;
                    }
                    boolean needUpdate = false;
                    if ("NVARCHAR".equalsIgnoreCase(tableColumn.getType()) || "NCHAR".equalsIgnoreCase(tableColumn.getType())) {
                        if (tableColumn.getLength() == null) continue;
                        if ((long)tableColumn.getLength().intValue() != tc.getLength()) {
                            needUpdate = true;
                        }
                    } else if ("DECIMAL".equalsIgnoreCase(tableColumn.getType())) {
                        if (tableColumn.getPrecision() == null || tableColumn.getScale() == null) continue;
                        if ("Date".equalsIgnoreCase(tc.getType())) {
                            if (tableColumn.getPrecision().intValue() != tc.getPrecision().intValue() || tableColumn.getScale() != 0) {
                                needUpdate = true;
                            }
                        } else if (tableColumn.getPrecision().intValue() != tc.getPrecision().intValue() || tableColumn.getScale().intValue() != tc.getScale().intValue()) {
                            needUpdate = true;
                        }
                    } else {
                        String type = this.getColumnType(tc).toUpperCase(Locale.ROOT);
                        if (!type.startsWith(tableColumn.getType().toUpperCase(Locale.ROOT))) {
                            needUpdate = true;
                        }
                    }
                    if (!needUpdate && !ORMUtils.isEmpty(tableColumn.getDefaultValue())) {
                        String defaultValue = tableColumn.getDefaultValue();
                        if (defaultValue.startsWith("('") && defaultValue.endsWith("')")) {
                            defaultValue = defaultValue.substring(2, defaultValue.length() - 2);
                        }
                        if (!defaultValue.equals(tc.getDefaultValue())) {
                            needUpdate = true;
                        }
                    }
                    if (!(needUpdate || tableColumn.isNullable() == tc.isNullable() || tableColumn.isPrimaryKey() || tc.isPrimaryKey())) {
                        needUpdate = true;
                    }
                    if (!needUpdate) continue;
                    String temp = this.columnString(tc, table.getSensitive(), false);
                    sqls.add(String.format("ALTER TABLE %s ALTER COLUMN %s", tableName, temp));
                    if (ORMUtils.isEmpty(comment) || comment.equals(tableColumn.getComment())) continue;
                    sqls.add(String.format("EXECUTE sp_addextendedproperty N'MS_Description',N'%s',N'user',N'dbo',N'table',N'%s',N'column',N'%s'", comment, tableName, columnName));
                    continue;
                }
                if (tc.isDropped()) continue;
                String temp = this.columnString(tc, table.getSensitive(), true);
                sqls.add(String.format("ALTER TABLE %s ADD %s", tableName, temp));
                if (ORMUtils.isEmpty(comment)) continue;
                sqls.add(String.format("EXECUTE sp_addextendedproperty N'MS_Description',N'%s',N'user',N'dbo',N'table',N'%s',N'column',N'%s'", comment, tableName, columnName));
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE " + tableName + "(");
            ArrayList<String> columnSQL = new ArrayList<String>();
            ArrayList<String> comments = new ArrayList<String>();
            for (int i = 0; i < columns.size(); ++i) {
                TableColumn tc = columns.get(i);
                String temp = this.columnString(tc, table.getSensitive(), true);
                String comment = tc.getComment();
                String columnName = this.getCaseSensitive(tc.getColumn(), table.getSensitive());
                if (!ORMUtils.isEmpty(comment)) {
                    comments.add(String.format("EXECUTE sp_addextendedproperty N'MS_Description',N'%s',N'user',N'dbo',N'table',N'%s',N'column',N'%s'", comment, tableName, columnName));
                }
                columnSQL.add(temp.toString());
            }
            sql.append(ORMUtils.join(columnSQL, ","));
            sql.append(")");
            sql.append(";");
            sqls.add(sql.toString());
            String comment = table.getComment();
            if (!ORMUtils.isEmpty(comment)) {
                sqls.add(String.format("EXECUTE sp_addextendedproperty N'MS_Description',N'%s',N'user',N'dbo',N'table',N'%s',NULL,NULL", comment, tableName));
            }
            sqls.addAll(comments);
        }
        return sqls;
    }

    protected String columnString(ColumnInfo info, int sensitive, RdColumn rdColumn, boolean addKey) {
        RdId rdId;
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(info.getColumnName(), sensitive);
        temp.append(cname);
        String type = this.getColumnType(info, rdColumn);
        temp.append(" " + type);
        if (!ORMUtils.isEmpty(rdColumn.defaultValue())) {
            temp.append(" DEFAULT '" + rdColumn.defaultValue() + "'");
        }
        if (!rdColumn.nullable()) {
            temp.append(" NOT NULL");
        } else if ("timestamp".equalsIgnoreCase(type)) {
            temp.append(" NULL");
        }
        if (info.getPrimaryKey().booleanValue() && addKey) {
            temp.append(" PRIMARY KEY");
        }
        if ((rdId = info.getField().getAnnotation(RdId.class)) != null && rdId.autoIncrement()) {
            temp.append(" IDENTITY");
        }
        return temp.toString();
    }

    protected String columnString(TableColumn tc, int sensitive, boolean addKey) {
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(tc.getColumn(), sensitive);
        temp.append(cname);
        String type = this.getColumnType(tc);
        temp.append(" " + type);
        if (!ORMUtils.isEmpty(tc.getDefaultValue())) {
            temp.append(" DEFAULT '" + tc.getDefaultValue() + "'");
        }
        if (!tc.isNullable()) {
            temp.append(" NOT NULL");
        } else if ("timestamp".equalsIgnoreCase(type)) {
            temp.append(" NULL");
        }
        if (tc.isPrimaryKey() && addKey) {
            temp.append(" PRIMARY KEY");
        }
        if (tc.isPrimaryKey() && tc.isAutoIncrement()) {
            temp.append(" IDENTITY");
        }
        return temp.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getColumnType(ColumnInfo info, RdColumn rdColumn) {
        String type = "";
        String infoType = info.getField().getType().getName();
        if (String.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.TEXT) return "TEXT";
            if (info.getColumnType() == ColumnType.MEDIUM_TEXT) return "TEXT";
            if (info.getColumnType() == ColumnType.LONG_TEXT) {
                return "TEXT";
            }
            if (info.getColumnType() == ColumnType.BLOB) {
                return "IMAGE";
            }
            if (info.getColumnType() == ColumnType.CLOB) {
                return "TEXT";
            }
            if (info.getColumnType() == ColumnType.BINARY) {
                return "VARBINARY(" + rdColumn.length() + ")";
            }
            if (info.getColumnType() != ColumnType.CHAR) return "NVARCHAR(" + rdColumn.length() + ")";
            return "NCHAR(" + rdColumn.length() + ")";
        }
        if (Integer.class.getName().equals(infoType)) {
            return "INT";
        }
        if (Date.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.LONG) {
                return "DECIMAL(" + (rdColumn.precision() > 0 ? rdColumn.precision() : 15) + ", 0)";
            }
            if (info.getColumnType() == ColumnType.TIMESTAMP) {
                return "TIMESTAMP";
            }
            if (info.getColumnType() != ColumnType.DATETIME) throw new ORMException("Not support type : " + infoType + "," + info.getColumnType().name());
            return "DATETIME";
        }
        if (Long.class.getName().equals(infoType)) {
            return "BIGINT";
        }
        if (Double.class.getName().equals(infoType)) {
            return "DECIMAL(" + rdColumn.precision() + "," + rdColumn.scale() + ")";
        }
        if (Float.class.getName().equals(infoType)) {
            if (info.getColumnType() != ColumnType.REAL) return "FLOAT";
            return "REAL";
        }
        if (BigDecimal.class.getName().equals(infoType)) {
            return "DECIMAL(" + rdColumn.precision() + "," + rdColumn.scale() + ")";
        }
        if (!byte[].class.getName().equals(infoType)) throw new ORMException("Not support type : " + infoType + "," + info.getColumnType().name());
        return "VARBINARY(" + rdColumn.length() + ")";
    }

    @Override
    public String getColumnType(TableColumn column) {
        String type = "";
        if ("TEXT".equalsIgnoreCase(column.getType()) || "IMAGE".equalsIgnoreCase(column.getType()) || "INT".equalsIgnoreCase(column.getType()) || "TIMESTAMP".equalsIgnoreCase(column.getType()) || "DATETIME".equalsIgnoreCase(column.getType()) || "BIGINT".equalsIgnoreCase(column.getType()) || "REAL".equalsIgnoreCase(column.getType()) || "FLOAT".equalsIgnoreCase(column.getType())) {
            return column.getType().toUpperCase(Locale.ROOT);
        }
        type = "NCHAR".equalsIgnoreCase(column.getType()) || "CHAR".equalsIgnoreCase(column.getType()) || "NVARCHAR".equalsIgnoreCase(column.getType()) || "VARCHAR".equalsIgnoreCase(column.getType()) || "VARBINARY".equalsIgnoreCase(column.getType()) ? column.getType().toUpperCase(Locale.ROOT) + "(" + column.getLength() + ")" : ("DECIMAL".equalsIgnoreCase(column.getType()) ? "DECIMAL(" + column.getPrecision() + "," + column.getScale() + ")" : this.getColumnTypeByClassName(column));
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getColumnTypeByClassName(TableColumn column) {
        String type = "";
        String className = column.getColumnClass();
        if (String.class.getName().equals(className)) {
            if (column.getColumnType() == ColumnType.TEXT) {
                return "TEXT";
            }
            if (column.getColumnType() == ColumnType.BLOB) {
                return "IMAGE";
            }
            if (column.getColumnType() == ColumnType.CLOB) {
                return "TEXT";
            }
            if (column.getColumnType() == ColumnType.BINARY) {
                return "VARBINARY(" + column.getLength() + ")";
            }
            if (column.getColumnType() != ColumnType.CHAR) return "NVARCHAR(" + column.getLength() + ")";
            return "NCHAR(" + column.getLength() + ")";
        }
        if (Integer.class.getName().equals(className)) {
            return "INT";
        }
        if (Date.class.getName().equals(className)) {
            if (column.getColumnType() == ColumnType.LONG) {
                return "DECIMAL(" + column.getPrecision() + ", 0)";
            }
            if (column.getColumnType() == ColumnType.TIMESTAMP) {
                return "TIMESTAMP";
            }
            if (column.getColumnType() != ColumnType.DATETIME) throw new ORMException("Not support type : " + className + "," + (Object)((Object)column.getColumnType()));
            return "DATETIME";
        }
        if (Long.class.getName().equals(className)) {
            return "BIGINT";
        }
        if (Double.class.getName().equals(className)) {
            return "DECIMAL(" + column.getPrecision() + "," + column.getScale() + ")";
        }
        if (Float.class.getName().equals(className)) {
            if (column.getColumnType() != ColumnType.REAL) return "FLOAT";
            return "REAL";
        }
        if (BigDecimal.class.getName().equals(className)) {
            return "DECIMAL(" + column.getPrecision() + "," + column.getScale() + ")";
        }
        if (!byte[].class.getName().equals(className)) throw new ORMException("Not support type : " + className + "," + (Object)((Object)column.getColumnType()));
        return "VARBINARY(" + column.getLength() + ")";
    }

    @Override
    public String getClassName(TableColumn column) {
        if ("TEXT".equalsIgnoreCase(column.getType()) || "IMAGE".equalsIgnoreCase(column.getType()) || "VARBINARY".equalsIgnoreCase(column.getType()) || "NCHAR".equalsIgnoreCase(column.getType()) || "NVARCHAR".equalsIgnoreCase(column.getType()) || "CHAR".equalsIgnoreCase(column.getType()) || "VARCHAR".equalsIgnoreCase(column.getType())) {
            return String.class.getName();
        }
        if ("INT".equalsIgnoreCase(column.getType())) {
            return Integer.class.getName();
        }
        if ("BIGINT".equalsIgnoreCase(column.getType())) {
            return Long.class.getName();
        }
        if ("REAL".equalsIgnoreCase(column.getType()) || "FLOAT".equalsIgnoreCase(column.getType())) {
            return Float.class.getName();
        }
        if ("TIMESTAMP".equalsIgnoreCase(column.getType()) || "DATETIME".equalsIgnoreCase(column.getType())) {
            return Date.class.getName();
        }
        if ("DECIMAL".equalsIgnoreCase(column.getType())) {
            if (column.getScale() != null && column.getScale() == 0) {
                if (column.getPrecision() != null && column.getPrecision() <= 9) {
                    return Integer.class.getName();
                }
                if (column.getPrecision() != null && column.getPrecision() < 18 && column.getPrecision() >= 10) {
                    return Long.class.getName();
                }
                return BigDecimal.class.getName();
            }
            return Double.class.getName();
        }
        throw new ORMException("Not support type : " + column.getColumn() + "," + column.getType());
    }

    @Override
    public String getCaseSensitive(String name, int sensitive) {
        if (name == null) {
            return name;
        }
        if (2 == sensitive) {
            return name.toLowerCase(Locale.ROOT);
        }
        if (1 == sensitive) {
            return name.toUpperCase(Locale.ROOT);
        }
        if (3 == sensitive) {
            return name;
        }
        return name;
    }

    @Override
    public List<Table> tables(Connection connection, String schema, String keyword) {
        ArrayList<Table> temp = new ArrayList<Table>();
        Statement ps = null;
        ResultSet rs = null;
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            String sql = " SELECT o.name, p.value FROM sys.extended_properties p         LEFT JOIN sysobjects o ON p.major_id= o.id        WHERE  p.minor_id=0 ";
            if (!ORMUtils.isEmpty(keyword)) {
                sql = sql + "and o.name like ? ";
            }
            ps = connection.prepareStatement(sql);
            if (!ORMUtils.isEmpty(keyword)) {
                ps.setString(1, "%" + keyword + "%");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                info.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            String schemaName = connection.getSchema();
            String sql = String.format("select name from %s.sysobjects where type = 'U' ", schemaName);
            if (!ORMUtils.isEmpty(keyword)) {
                sql = sql + "and name like ? ";
            }
            ps = connection.prepareStatement(sql);
            if (!ORMUtils.isEmpty(keyword)) {
                ps.setString(1, "%" + keyword + "%");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                temp.add(new Table(tableName, (String)info.get(tableName)));
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return temp;
    }
}

