/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.spring;

import com.objectsql.handler.DebugHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHandler
implements DebugHandler {
    private final Logger logger = LoggerFactory.getLogger(LogHandler.class);

    @Override
    public void handle(Class<?> clazz, String msg, Object ... objects) {
        if (objects != null && objects.length > 0) {
            LoggerFactory.getLogger(clazz).info("{}, {}", (Object)msg, objects[0]);
            if (objects.length > 1) {
                List params = Arrays.stream(objects).collect(Collectors.toList());
                params.remove(0);
                Object last = params.get(params.size() - 1);
                if (last instanceof Throwable) {
                    params.remove(last);
                } else {
                    last = null;
                }
                if (params.isEmpty()) {
                    LoggerFactory.getLogger(clazz).info("Other params: {}", params);
                }
                if (last != null) {
                    LoggerFactory.getLogger(clazz).info("Exception", (Throwable)last);
                }
            }
        } else {
            LoggerFactory.getLogger(clazz).info("{}", (Object)msg);
        }
    }
}

