/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.option;

import com.objectsql.option.OracleOptions;
import com.objectsql.support.ColumnType;
import com.objectsql.support.DataType;
import com.objectsql.support.Pair;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;

public class DMOptions
extends OracleOptions {
    @Override
    public String keyword() {
        return "dm";
    }

    @Override
    public String databaseType() {
        return "DM";
    }

    @Override
    public boolean preSetParameter(PreparedStatement ps, Connection connection, String databaseType, int i, Pair pair) throws SQLException {
        Object obj = pair.getValue();
        ColumnType columnType = pair.getColumnType();
        DataType type = DataType.getDataType(pair.getType());
        boolean hasSet = false;
        switch (type) {
            case STRING: {
                if (columnType != ColumnType.BLOB) break;
                if (obj != null) {
                    try {
                        ps.setBinaryStream(i + 1, new ByteArrayInputStream(obj.toString().getBytes(this.getCoding(pair))));
                        hasSet = true;
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ps.setBinaryStream(i + 1, null);
                break;
            }
            case DOUBLE: {
                ps.setDouble(i + 1, (Double)obj);
                hasSet = true;
                break;
            }
        }
        return hasSet;
    }

    @Override
    public String getCaseSensitive(String name, int sensitive) {
        if (name == null) {
            return name;
        }
        if (2 == sensitive) {
            return name.toLowerCase(Locale.ROOT);
        }
        if (1 == sensitive) {
            return name.toUpperCase(Locale.ROOT);
        }
        if (3 == sensitive) {
            return name;
        }
        return name.toUpperCase(Locale.ROOT);
    }
}

