/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.AbstractWebDriverFactory;
import com.seleniumtests.browserfactory.HtmlUnitCapabilitiesFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.driver.DriverConfig;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class HtmlUnitDriverFactory
extends AbstractWebDriverFactory
implements IWebDriverFactory {
    public HtmlUnitDriverFactory(DriverConfig cfg) {
        super(cfg);
    }

    @Override
    public WebDriver createWebDriver() {
        DriverConfig cfg = this.getWebDriverConfig();
        this.driver = new HtmlUnitDriver((Capabilities)new HtmlUnitCapabilitiesFactory().createCapabilities(cfg));
        this.setImplicitWaitTimeout(cfg.getImplicitWaitTimeout());
        if (cfg.getPageLoadTimeout() >= 0) {
            TestLogging.log("htmlunit doesn't support pageLoadTimeout");
        }
        this.setWebDriver(this.driver);
        return this.driver;
    }
}

