/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.driver;

import com.seleniumtests.core.TestLogging;
import com.seleniumtests.driver.BrowserType;
import com.seleniumtests.driver.WebUIDriver;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public class WebUtility {
    private WebDriver driver;

    public WebUtility(WebDriver driver) {
        this.driver = driver;
    }

    public void resizeWindow(int width, int height) {
        try {
            TestLogging.logWebStep(null, "Resize browser window to width " + width + " height " + height, false);
            Dimension size = new Dimension(width, height);
            this.driver.manage().window().setPosition(new Point(0, 0));
            this.driver.manage().window().setSize(size);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void maximizeWindow() {
        try {
            BrowserType browser = BrowserType.getBrowserType(WebUIDriver.getWebUIDriver().getBrowser());
            if (browser == BrowserType.Android || browser == BrowserType.IPad || browser == BrowserType.IPhone) {
                return;
            }
            this.driver.manage().window().maximize();
        }
        catch (Exception ex) {
            try {
                ((JavascriptExecutor)this.driver).executeScript("if (window.screen){window.moveTo(0, 0);window.resizeTo(window.screen.availWidth,window.screen.availHeight);}", new Object[0]);
            }
            catch (Exception ignore) {
                TestLogging.log("Unable to maximize browser window. Exception occured: " + ignore.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        WebUIDriver.getWebUIDriver().setMode("ExistingGrid");
        WebUIDriver.getWebUIDriver().setHubUrl(" ");
        WebDriver driver = WebUIDriver.getWebDriver(true);
        System.out.print(driver.manage().window().getSize().width + ":" + driver.manage().window().getSize().height);
    }
}

