/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.util;

import com.seleniumtests.core.Filter;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.customexception.CustomSeleniumTestsException;
import com.seleniumtests.util.SpreadSheetHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CSVHelper {
    private static Logger logger = TestLogging.getLogger(CSVHelper.class);
    public static final String DOUBLE_QUOTE = "\"";
    public static final String DELIM_CHAR = ",";
    public static final String TAB_CHAR = "\t";

    public static Iterator<Object[]> getDataFromCSVFile(Class<?> clazz, String filename, Filter filter, boolean readHeaders, boolean supportDPFilter) {
        return CSVHelper.getDataFromCSVFile(clazz, filename, filter, readHeaders, null, supportDPFilter);
    }

    public static Iterator<Object[]> getDataFromCSVFile(Class<?> clazz, String filename, Filter filter, boolean readHeaders, String delimiter, boolean supportDPFilter) {
        InputStream is = null;
        try {
            Filter dpFilter;
            StringBuilder sbBlank;
            is = clazz != null ? clazz.getResourceAsStream(filename) : new FileInputStream(filename);
            if (is == null) {
                Iterator<Object[]> iterator = new ArrayList().iterator();
                return iterator;
            }
            String[][] csvData = CSVHelper.read(is, delimiter);
            ArrayList<Object[]> sheetData = new ArrayList<Object[]>();
            if (readHeaders) {
                ArrayList<String> rowData = new ArrayList<String>();
                for (int j = 0; j < csvData[0].length; ++j) {
                    rowData.add(csvData[0][j]);
                }
                sheetData.add(rowData.toArray(new Object[rowData.size()]));
            }
            if ((sbBlank = new StringBuilder()).length() > 0) {
                sbBlank.deleteCharAt(sbBlank.length() - 1);
                throw new CustomSeleniumTestsException("Blank TestTitle found on Row(s) " + sbBlank.toString() + ".");
            }
            if (supportDPFilter && (dpFilter = SpreadSheetHelper.getDPFilter()) != null) {
                filter = filter == null ? dpFilter : Filter.and(filter, dpFilter);
            }
            for (int i = 1; i < csvData.length; ++i) {
                int j;
                HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
                ArrayList<String> rowData = new ArrayList<String>();
                for (j = 0; j < csvData[i].length; ++j) {
                    rowDataMap.put(csvData[0][j], csvData[i][j]);
                }
                for (j = 0; j < csvData[0].length; ++j) {
                    if (csvData[i].length > j) {
                        rowData.add(csvData[i][j]);
                        continue;
                    }
                    rowData.add(null);
                }
                if (supportDPFilter) {
                    SpreadSheetHelper.formatDPTags(rowDataMap);
                }
                if (filter != null && !filter.match(rowDataMap)) continue;
                sheetData.add(rowData.toArray(new Object[rowData.size()]));
            }
            if (!readHeaders && sheetData.isEmpty() || readHeaders && sheetData.size() <= 1) {
                logger.warn((Object)("No matching data found on csv file: " + filename + " with filter criteria: " + filter.toString()));
            }
            Iterator<Object[]> iterator = sheetData.iterator();
            return iterator;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ArrayList<String> getHeaderFromCSVFile(Class<?> clazz, String filename, String delimiter) {
        if (delimiter == null) {
            delimiter = DELIM_CHAR;
        }
        InputStream is = null;
        try {
            is = clazz != null ? clazz.getResourceAsStream(filename) : new FileInputStream(filename);
            if (is == null) {
                ArrayList<String> arrayList = null;
                return arrayList;
            }
            String[][] csvData = CSVHelper.read(is, delimiter);
            ArrayList<String> rowData = new ArrayList<String>();
            for (int j = 0; j < csvData[0].length; ++j) {
                rowData.add(csvData[0][j]);
            }
            ArrayList<String> arrayList = rowData;
            return arrayList;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String[] parseLine(String line, String delim) {
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        String[] result = null;
        String[] tokens = line.split(delim);
        int count = 0;
        while (count < tokens.length) {
            if (tokens[count] == null || tokens[count].length() == 0) {
                tokenList.add("");
                ++count;
                continue;
            }
            if (tokens[count].startsWith(DOUBLE_QUOTE)) {
                StringBuilder sbToken = new StringBuilder(tokens[count].substring(1));
                while (count < tokens.length && !tokens[count].endsWith(DOUBLE_QUOTE)) {
                    sbToken.append(DELIM_CHAR).append(tokens[++count]);
                }
                sbToken.deleteCharAt(sbToken.length() - 1);
                tokenList.add(sbToken.toString());
            } else {
                tokenList.add(tokens[count]);
            }
            ++count;
        }
        if (tokenList.size() > 0) {
            result = new String[tokenList.size()];
            tokenList.toArray(result);
        }
        return result;
    }

    public static String[][] read(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return CSVHelper.read(fis);
    }

    public static String[][] read(InputStream is) throws IOException {
        return CSVHelper.read(is, null);
    }

    public static String[][] read(InputStream is, String delim) throws IOException {
        String inputLine;
        String[][] result = null;
        ArrayList<String[]> list = new ArrayList<String[]>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((inputLine = reader.readLine()) != null) {
            try {
                String[] item = delim == null ? CSVHelper.parseLine(inputLine, DELIM_CHAR) : CSVHelper.parseLine(inputLine, delim);
                if (item == null) continue;
                list.add(item);
            }
            catch (Exception e) {}
        }
        reader.close();
        if (list.size() > 0) {
            result = new String[list.size()][];
            list.toArray((T[])result);
        }
        return result;
    }

    public static String[][] read(URL url) throws IOException {
        URLConnection con = url.openConnection();
        return CSVHelper.read(con.getInputStream());
    }
}

