/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.webelements;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.seleniumtests.core.CustomAssertion;
import com.seleniumtests.core.SeleniumTestsContextManager;
import com.seleniumtests.core.SeleniumTestsPageListener;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.customexception.CustomSeleniumTestsException;
import com.seleniumtests.customexception.NotCurrentPageException;
import com.seleniumtests.driver.ScreenShot;
import com.seleniumtests.driver.ScreenshotUtil;
import com.seleniumtests.driver.WebUIDriver;
import com.seleniumtests.driver.WebUtility;
import com.seleniumtests.helper.WaitHelper;
import com.seleniumtests.webelements.BasePage;
import com.seleniumtests.webelements.HtmlElement;
import com.seleniumtests.webelements.IPage;
import com.seleniumtests.webelements.LinkElement;
import com.seleniumtests.webelements.WebPageSection;
import com.thoughtworks.selenium.Wait;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.testng.Assert;

public class PageObject
extends BasePage
implements IPage {
    private static final Logger logger = Logger.getLogger(PageObject.class);
    private static final int MAX_WAIT_TIME_FOR_REDIRECTION = 3;
    private boolean frameFlag = false;
    private HtmlElement pageIdentifierElement = null;
    private String popupWindowName = null;
    private String windowHandle = null;
    private String title = null;
    private String url = null;
    private String bodyText = null;
    private String htmlSource = null;
    private String htmlSavedToPath = null;
    private String suiteName = null;
    private String outputDirectory = null;
    private String htmlFilePath = null;
    private String imageFilePath = null;

    public PageObject() throws Exception {
        this(null, null);
    }

    public PageObject(HtmlElement pageIdentifierElement) throws Exception {
        this(pageIdentifierElement, null);
    }

    public PageObject(HtmlElement pageIdentifierElement, String url) throws Exception {
        Calendar start = Calendar.getInstance();
        start.setTime(new Date());
        if (SeleniumTestsContextManager.getGlobalContext() != null && SeleniumTestsContextManager.getGlobalContext().getTestNGContext() != null) {
            this.suiteName = SeleniumTestsContextManager.getGlobalContext().getTestNGContext().getSuite().getName();
            this.outputDirectory = SeleniumTestsContextManager.getGlobalContext().getTestNGContext().getOutputDirectory();
        }
        this.pageIdentifierElement = pageIdentifierElement;
        this.driver = WebUIDriver.getWebDriver();
        if (url != null) {
            this.open(url);
        }
        if (SeleniumTestsContextManager.isWebTest()) {
            this.waitForPageToLoad();
        }
        this.assertCurrentPage(false);
        try {
            this.windowHandle = this.driver.getWindowHandle();
        }
        catch (Exception ex) {
            // empty catch block
        }
        SeleniumTestsPageListener.informPageLoad(this);
        Calendar end = Calendar.getInstance();
        start.setTime(new Date());
        long startTime = start.getTimeInMillis();
        long endTime = end.getTimeInMillis();
        if ((endTime - startTime) / 1000L > 0L) {
            TestLogging.log("Open web page in :" + (endTime - startTime) / 1000L + "seconds");
        }
    }

    public void assertCookiePresent(String name) {
        TestLogging.logWebStep(null, "assert cookie " + name + " is present.", false);
        this.assertHTML(this.getCookieByName(name) != null, "Cookie: {" + name + "} not found.");
    }

    @Override
    protected void assertCurrentPage(boolean log) throws NotCurrentPageException {
        if (this.pageIdentifierElement != null && !this.isElementPresent(this.pageIdentifierElement.getBy())) {
            try {
                if (!SeleniumTestsContextManager.getThreadContext().getCaptureSnapshot()) {
                    new ScreenshotUtil(this.driver).capturePageSnapshotOnException();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new NotCurrentPageException(this.getClass().getCanonicalName() + " is not the current page.\nPageIdentifierElement " + this.pageIdentifierElement.toString() + " is not found.");
        }
        if (log) {
            TestLogging.logWebStep(null, "assert \"" + this.getClass().getSimpleName() + "\" is the current page" + (this.pageIdentifierElement != null ? " (assert PageIdentifierElement " + this.pageIdentifierElement.toHTML() + " is present)." : "."), false);
        }
    }

    public void assertHtmlSource(String text) {
        TestLogging.logWebStep(null, "assert text \"" + text + "\" is present in page source.", false);
        this.assertHTML(this.getHtmlSource().contains(text), "Text: {" + text + "} not found on page source.");
    }

    public void assertKeywordNotPresent(String text) {
        TestLogging.logWebStep(null, "assert text \"" + text + "\" is present in page source.", false);
        Assert.assertFalse((boolean)this.getHtmlSource().contains(text), (String)("Text: {" + text + "} not found on page source."));
    }

    public void assertLocation(String urlPattern) {
        TestLogging.logWebStep(null, "assert location \"" + urlPattern + "\".", false);
        this.assertHTML(this.getLocation().contains(urlPattern), "Pattern: {" + urlPattern + "} not found on page location.");
    }

    public void assertPageSectionPresent(WebPageSection pageSection) {
        TestLogging.logWebStep(null, "assert pagesection \"" + pageSection.getName() + "\"  is present.", false);
        this.assertElementPresent(new HtmlElement(pageSection.getName(), pageSection.getBy()));
    }

    public void assertTitle(String text) {
        TestLogging.logWebStep(null, "assert text \"" + text + "\"  is present on title.", false);
        this.assertHTML(this.getTitle().contains(text), "Text: {" + text + "} not found on page title.");
    }

    @Override
    public void capturePageSnapshot() {
        ScreenShot screenShot = new ScreenshotUtil(this.driver).captureWebPageSnapshot();
        this.title = screenShot.getTitle();
        if (screenShot.getHtmlSourcePath() != null) {
            this.htmlFilePath = screenShot.getHtmlSourcePath().replace(this.suiteName, this.outputDirectory);
            this.htmlSavedToPath = screenShot.getHtmlSourcePath();
        }
        if (screenShot.getImagePath() != null) {
            this.imageFilePath = screenShot.getImagePath().replace(this.suiteName, this.outputDirectory);
        }
        TestLogging.logWebOutput(this.url, this.title + " (" + TestLogging.buildScreenshotLog(screenShot) + ")", false);
    }

    public final void close() throws NotCurrentPageException {
        if (WebUIDriver.getWebDriver() == null) {
            return;
        }
        SeleniumTestsPageListener.informPageUnload(this);
        TestLogging.log("close web page");
        boolean isMultipleWindow = false;
        if (this.driver.getWindowHandles().size() > 1) {
            isMultipleWindow = true;
        }
        try {
            this.driver.close();
        }
        catch (WebDriverException ignore) {
            // empty catch block
        }
        if (WebUIDriver.getWebUIDriver().getMode().equalsIgnoreCase("LOCAL")) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            if (isMultipleWindow) {
                this.selectWindow();
            } else {
                WebUIDriver.setWebDriver(null);
            }
        }
        catch (UnreachableBrowserException ex) {
            WebUIDriver.setWebDriver(null);
        }
    }

    public void dragAndDrop(HtmlElement element, int offsetX, int offsetY) {
        TestLogging.logWebStep(null, "dragAndDrop " + element.toHTML() + " to offset(x,y): (" + offsetX + "," + offsetY + ")", false);
        element.captureSnapshot("before draging");
        new Actions(this.driver).dragAndDropBy(element.getElement(), offsetX, offsetY).perform();
        element.captureSnapshot("after dropping");
    }

    @Override
    public String getBodyText() {
        return this.bodyText;
    }

    public final String getCookieByName(String name) {
        if (this.driver.manage().getCookieNamed(name) == null) {
            return null;
        }
        return this.driver.manage().getCookieNamed(name).getValue();
    }

    public final int getElementCount(HtmlElement element) throws CustomSeleniumTestsException {
        return this.driver.findElements(element.getBy()).size();
    }

    public String getEval(String expression) {
        CustomAssertion.assertTrue(false, "focus not implemented yet");
        return null;
    }

    public String getHtmlFilePath() {
        return this.htmlFilePath;
    }

    @Override
    public String getHtmlSavedToPath() {
        return this.htmlSavedToPath;
    }

    @Override
    public String getHtmlSource() {
        return this.htmlSource;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    @Override
    public String getJSErrors() {
        List<JavaScriptError> jsErrorList;
        if (WebUIDriver.getWebUIDriver().isAddJSErrorCollectorExtension() && !(jsErrorList = JavaScriptError.readErrors(this.driver)).isEmpty()) {
            String jsErrors = "";
            for (JavaScriptError aJsErrorList : jsErrorList) {
                jsErrors = jsErrors + aJsErrorList.getLineNumber() + ", " + aJsErrorList.getErrorMessage() + ", " + aJsErrorList.getSourceName() + "; ";
            }
            return jsErrors;
        }
        return null;
    }

    @Override
    public String getLocation() {
        return this.driver.getCurrentUrl();
    }

    public String getPopupWindowName() {
        return this.popupWindowName;
    }

    public int getTimeout() {
        return SeleniumTestsContextManager.getThreadContext().getWebSessionTimeout();
    }

    @Override
    public String getTitle() {
        return this.driver.getTitle();
    }

    public String getUrl() {
        return this.url;
    }

    public String getCanonicalURL() {
        return new LinkElement("Canonical URL", By.cssSelector((String)"link[rel=canonical]")).getAttribute("href");
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public final void goBack() {
        TestLogging.logWebStep(null, "goBack", false);
        this.driver.navigate().back();
        this.frameFlag = false;
    }

    public final void goForward() {
        TestLogging.logWebStep(null, "goForward", false);
        this.driver.navigate().forward();
        this.frameFlag = false;
    }

    public final boolean isCookiePresent(String name) {
        return this.getCookieByName(name) != null;
    }

    @Override
    public boolean isFrame() {
        return this.frameFlag;
    }

    public final void maximizeWindow() {
        new WebUtility(this.driver).maximizeWindow();
    }

    private void open(String url) throws Exception {
        if (this.getDriver() == null) {
            TestLogging.logWebStep(url, "Launch application", false);
            this.driver = this.webUXDriver.createWebDriver();
        }
        this.setUrl(url);
        try {
            if (SeleniumTestsContextManager.isWebTest()) {
                this.driver.navigate().to(url);
            }
        }
        catch (UnreachableBrowserException e) {
            TestLogging.logWebStep(url, "Launch application", false);
            this.driver = this.webUXDriver.createWebDriver();
            this.maximizeWindow();
            this.driver.navigate().to(url);
        }
        catch (UnsupportedCommandException e) {
            TestLogging.log("get UnsupportedCommandException, retry");
            this.driver = this.webUXDriver.createWebDriver();
            this.maximizeWindow();
            this.driver.navigate().to(url);
        }
        catch (TimeoutException ex) {
            TestLogging.log("got time out when loading " + url + ", ignored");
        }
        catch (UnhandledAlertException ex) {
            TestLogging.log("got UnhandledAlertException, retry");
            this.driver.navigate().to(url);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CustomSeleniumTestsException(e);
        }
    }

    private void populateAndCapturePageSnapshot() {
        try {
            this.setTitle(this.driver.getTitle());
            this.htmlSource = this.driver.getPageSource();
            try {
                this.bodyText = this.driver.findElement(By.tagName((String)"body")).getText();
            }
            catch (StaleElementReferenceException ignore) {
                logger.warn((Object)"StaleElementReferenceException got in populateAndCapturePageSnapshot");
                this.bodyText = this.driver.findElement(By.tagName((String)"body")).getText();
            }
        }
        catch (UnreachableBrowserException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (WebDriverException e) {
            throw e;
        }
        this.capturePageSnapshot();
    }

    public final void refresh() throws NotCurrentPageException {
        TestLogging.logWebStep(null, "refresh", false);
        try {
            this.driver.navigate().refresh();
        }
        catch (TimeoutException ex) {
            TestLogging.log("got time out customexception, ignore");
        }
    }

    public final void resizeTo(int width, int height) {
        new WebUtility(this.driver).resizeWindow(width, height);
    }

    public final void selectFrame(int index) {
        TestLogging.logWebStep(null, "select frame using index" + index, false);
        this.driver.switchTo().frame(index);
        this.frameFlag = true;
    }

    @Override
    public final void selectFrame(By by) {
        TestLogging.logWebStep(null, "select frame, locator={\"" + by.toString() + "\"}", false);
        this.driver.switchTo().frame(this.driver.findElement(by));
        this.frameFlag = true;
    }

    public final void selectFrame(String locator) {
        TestLogging.logWebStep(null, "select frame, locator={\"" + locator + "\"}", false);
        this.driver.switchTo().frame(locator);
        this.frameFlag = true;
    }

    public final void selectWindow() throws NotCurrentPageException {
        TestLogging.logWebStep(null, "select window, locator={\"" + this.getPopupWindowName() + "\"}", false);
        this.driver.switchTo().window((String)this.driver.getWindowHandles().toArray()[0]);
        this.waitForSeconds(1);
        this.assertCurrentPage(true);
    }

    public final void selectWindow(int index) throws NotCurrentPageException {
        TestLogging.logWebStep(null, "select window, locator={\"" + index + "\"}", false);
        this.driver.switchTo().window((String)this.driver.getWindowHandles().toArray()[index]);
    }

    public final void selectNewWindow() throws NotCurrentPageException {
        TestLogging.logWebStep(null, "select new window", false);
        this.driver.switchTo().window((String)this.driver.getWindowHandles().toArray()[1]);
        this.waitForSeconds(1);
    }

    protected void setHtmlSavedToPath(String htmlSavedToPath) {
        this.htmlSavedToPath = htmlSavedToPath;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setUrl(String openUrl) {
        this.url = openUrl;
    }

    public void switchToDefaultContent() {
        try {
            this.driver.switchTo().defaultContent();
        }
        catch (UnhandledAlertException unhandledAlertException) {
            // empty catch block
        }
    }

    private void waitForPageToLoad() throws Exception {
        try {
            new Wait(){

                public boolean until() {
                    try {
                        PageObject.this.driver.switchTo().defaultContent();
                        return true;
                    }
                    catch (UnhandledAlertException ex) {
                        WaitHelper.waitForSeconds(2);
                    }
                    catch (WebDriverException webDriverException) {
                        // empty catch block
                    }
                    return false;
                }
            }.wait(String.format("Timed out waiting for page to load", new Object[0]), (long)WebUIDriver.getWebUIDriver().getWebSessionTimeout());
        }
        catch (Wait.WaitTimedOutException ex) {
            // empty catch block
        }
        this.populateAndCapturePageSnapshot();
    }

    public WebElement getElement(By by, String elementName) {
        WebElement element = null;
        try {
            element = this.driver.findElement(by);
        }
        catch (ElementNotFoundException e) {
            TestLogging.errorLogger(elementName + " is not found with locator - " + by.toString());
            throw e;
        }
        return element;
    }

    public String getElementUrl(By by, String name) {
        return this.getElement(by, name).getAttribute("href");
    }

    public String getElementText(By by, String name) {
        return this.getElement(by, name).getText();
    }

    public String getElementSrc(By by, String name) {
        return this.getElement(by, name).getAttribute("src");
    }
}

