/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.Comparator;
import com.seleniumtests.xmldog.Config;
import com.seleniumtests.xmldog.Differences;
import com.seleniumtests.xmldog.FileUtil;
import com.seleniumtests.xmldog.XMLDogConstants;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLDog
implements XMLDogConstants {
    private Config _config = null;
    private DocumentBuilderFactory _factory = null;
    private DocumentBuilder _parser = null;

    public XMLDog() throws ParserConfigurationException {
        this(new Config());
    }

    public XMLDog(Config config) throws ParserConfigurationException {
        this.setConfig(config);
    }

    public Differences compare(String controlFilename, String testFilename) throws SAXException, IOException {
        File control = new File(controlFilename);
        File test = new File(testFilename);
        return this.compare(control, test);
    }

    public void setConfig(Config config) throws ParserConfigurationException {
        this._config = config;
        this._factory = DocumentBuilderFactory.newInstance();
        this._factory.setExpandEntityReferences(this._config.isExpandingEntityRefs());
        this._factory.setIgnoringComments(this._config.isIgnoringComments());
        this._factory.setIgnoringElementContentWhitespace(this._config.isIgnoringWhitespace());
        this._factory.setCoalescing(true);
        this._factory.setNamespaceAware(this._config.isNamespaceAware());
        this._parser = this._factory.newDocumentBuilder();
    }

    public Differences compare(File controlFile, File testFile) throws SAXException, IOException {
        Document control = this._parser.parse(controlFile);
        Document test = this._parser.parse(testFile);
        Comparator comparator = new Comparator(control, test, this._config);
        return comparator.compare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compareDir(String controlDirPath, String testDirPath, String resultDirPath, String suffix) throws SAXException, IOException {
        block6: {
            File[] controlFiles = null;
            File controlDir = null;
            File testDir = null;
            File resultDir = null;
            try {
                controlDir = new File(controlDirPath);
                testDir = new File(testDirPath);
                resultDir = new File(resultDirPath);
                if (controlDir.isDirectory() && testDir.isDirectory() && resultDir.isDirectory()) {
                    if (!resultDir.exists() || !resultDir.isDirectory()) {
                        resultDir.mkdirs();
                    }
                    FilenameFilter filter = new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".xml");
                        }
                    };
                    controlFiles = controlDir.listFiles(filter);
                    Object testFile = null;
                    Object controlFile = null;
                    String controlFilename = null;
                    String testFilename = null;
                    String diffFilename = null;
                    for (int i = 0; i < controlFiles.length; ++i) {
                        controlFilename = controlFiles[i].getName();
                        diffFilename = resultDirPath + File.separator + FileUtil.getPrefix(controlFilename) + "_diff.txt";
                        testFilename = testDirPath + File.separator + controlFilename + (suffix == null ? "" : suffix);
                        XMLDog.log("Diff file name: " + diffFilename);
                        XMLDog.log("Control XML filename: " + controlFilename);
                        XMLDog.log("Test XML filename: " + testFilename);
                        FileUtil.writeListAsStr(diffFilename, this.compare(controlFiles[i].getAbsolutePath(), testFilename));
                    }
                    break block6;
                }
                throw new IOException("One of the input paths is not a directory");
            }
            finally {
                controlFiles = null;
                controlDir = null;
                testDir = null;
                resultDir = null;
            }
        }
    }

    public Document getDocument(String xmlFilePath) throws SAXException, IOException {
        return this._parser.parse(new File(xmlFilePath));
    }

    public static void log(String msg) {
    }

    public static void log(String msg, Throwable t) {
    }

    public static void main(String[] args) {
        try {
            Config config = new Config();
            config.addExcludedElement("StartTime");
            config.addExcludedElement("EndTime");
            config.addExcludedElement("URL");
            config.addExcludedElement("DateLong");
            config.addExcludedElement("TimeLong");
            config.addExcludedElement("TimeShort");
            config.addExcludedElement("TimeMedium");
            config.addExcludedElement("DateMedium");
            config.addExcludedElement("DateShort");
            config.addExcludedElement("Hours");
            config.addExcludedElement("Seconds");
            config.addExcludedElement("Minutes");
            config.addExcludedElement("Days");
            config.setCustomDifference(false);
            config.setApplyEListToSiblings(true);
            config.setIgnoringOrder(false);
            XMLDog dog = new XMLDog(config);
            long t1 = System.currentTimeMillis();
            Differences diff = dog.compare("c:\\test\\1.xml", "c:\\test\\2.xml");
            System.out.println(diff.toString());
            long t2 = System.currentTimeMillis();
            System.out.println("Time to compare the docs " + (t2 - t1) + " millisecs");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

