/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.seleniumtests.core.TearDownService;
import com.seleniumtests.driver.ScreenShot;
import com.seleniumtests.driver.TestType;
import com.seleniumtests.reporter.PluginsHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class SeleniumTestsContext {
    public static final String TEST_CONFIGURATION = "testConfig";
    public static final String APP_URL = "appURL";
    public static final String WEB_SESSION_TIME_OUT = "webSessionTimeOut";
    public static final String IMPLICIT_WAIT_TIME_OUT = "implicitWaitTimeOut";
    public static final String EXPLICIT_WAIT_TIME_OUT = "explicitWaitTimeOut";
    public static final String PAGE_LOAD_TIME_OUT = "pageLoadTimeout";
    public static final String WEB_DRIVER_GRID = "webDriverGrid";
    public static final String RUN_MODE = "runMode";
    public static final String BROWSER = "browser";
    public static final String BROWSER_VERSION = "browserVersion";
    public static final String WEB_PLATFORM = "webPlatform";
    public static final String FIREFOX_USER_PROFILE_PATH = "firefoxUserProfilePath";
    public static final String USE_DEFAULT_FIREFOX_PROFILE = "useFirefoxDefaultProfile";
    public static final String OPERA_USER_PROFILE_PATH = "operaUserProfilePath";
    public static final String FIREFOX_BINARY_PATH = "firefoxBinaryPath";
    public static final String CHROME_DRIVER_PATH = "chromeDriverPath";
    public static final String CHROME_BINARY_PATH = "chromeBinaryPath";
    public static final String IE_DRIVER_PATH = "ieDriverPath";
    public static final String USER_AGENT = "userAgent";
    public static final String Set_Assume_Untrusted_Certificate_Issuer = "setAssumeUntrustedCertificateIssuer";
    public static final String Set_Accept_Untrusted_Certificates = "setAcceptUntrustedCertificates";
    public static final String ENABLE_JAVASCRIPT = "enableJavascript";
    public static final String EVENT_FIRING_WEB_DRIVER = "eventFiringWebDriver";
    public static final String NTLM_AUTH_TRUSTED_URIS = "ntlmAuthTrustedUris";
    public static final String BROWSER_DOWNLOAD_DIR = "browserDownloadDir";
    public static final String BROWSER_WINDOW_SIZE = "browserWindowSize";
    public static final String WEB_PROXY_ENABLED = "webProxyEnabled";
    public static final String WEB_PROXY_TYPE = "webProxyType";
    public static final String WEB_PROXY_ADDRESS = "webProxyAddress";
    public static final String TEST_ENTITY = "testEntity";
    public static final String REPORT_GENERATION_CONFIG = "reportGenerationConfig";
    public static final String OPEN_REPORT_IN_BROWSER = "openReportInBrowser";
    public static final String CAPTURE_SNAPSHOT = "captureSnapshot";
    public static final String ENABLE_EXCEPTION_LISTENER = "enableExceptionListener";
    public static final String DP_TAGS_INCLUDE = "dpTagsInclude";
    public static final String DP_TAGS_EXCLUDE = "dpTagsExclude";
    public static final String SSH_COMMAND_WAIT = "sshCommandWait";
    public static final String SOFT_ASSERT_ENABLED = "softAssertEnabled";
    public static final String OUTPUT_DIRECTORY = "outputDirectory";
    public static final String WEB_DRIVER_LISTENER = "webDriverListener";
    public static final String TEST_METHOD_SIGNATURE = "testMethodSignature";
    public static final String PLUGIN_CONFIG_PATH = "pluginConfigPath";
    public static final String TEST_DATA_FILE = "testDataFile";
    public static final String TEST_TYPE = "testType";
    public static final String APPIUM_SERVER_URL = "appiumServerURL";
    public static final String AUTOMATION_NAME = "automationName";
    public static final String MOBILE_PLATFORM_NAME = "platformName";
    public static final String MOBILE_PLATFORM_VERSION = "mobilePlatformVersion";
    public static final String DEVICE_NAME = "deviceName";
    public static final String APP = "app";
    public static final String BROWSER_NAME = "browserName";
    public static final String APP_PACKAGE = "appPackage";
    public static final String APP_ACTIVITY = "appActivity";
    public static final String NEW_COMMAND_TIMEOUT = "newCommandTimeout";
    public static final String VERSION = "version";
    public static final String PLATFORM = "platform";
    public static final String SAUCELABS_URL = "sauceLabsURL";
    private LinkedList<TearDownService> tearDownServices = new LinkedList();
    private Map<ITestResult, List<Throwable>> verificationFailuresMap = new HashMap<ITestResult, List<Throwable>>();
    private Map<String, Object> contextDataMap = Collections.synchronizedMap(new HashMap());
    private ITestContext testNGContext = null;
    private LinkedList<ScreenShot> screenshots = new LinkedList();

    public LinkedList<ScreenShot> getScreenshots() {
        return this.screenshots;
    }

    public void addScreenShot(ScreenShot screenShot) {
        this.deleteExceptionSnapshots();
        this.screenshots.addLast(screenShot);
    }

    private void deleteExceptionSnapshots() {
        try {
            int size = this.screenshots.size();
            if (size == 0) {
                return;
            }
            ScreenShot screenShot = this.screenshots.get(size - 1);
            if (screenShot.isException() && screenShot.getFullImagePath() != null) {
                new File(screenShot.getFullImagePath()).delete();
                this.screenshots.remove(size - 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ScreenShot getExceptionScreenShot() {
        if (this.screenshots.size() > 0 && this.screenshots.getLast().isException()) {
            return this.screenshots.getLast();
        }
        return null;
    }

    public SeleniumTestsContext(ITestContext context) {
        this.testNGContext = context;
        this.setContextAttribute(context, TEST_DATA_FILE, System.getProperty(TEST_DATA_FILE), "testCase");
        this.setContextAttribute(context, TEST_TYPE, System.getProperty(TEST_TYPE), TestType.WEB.toString());
        this.setContextAttribute(context, WEB_SESSION_TIME_OUT, System.getProperty(WEB_SESSION_TIME_OUT), "90000");
        this.setContextAttribute(context, IMPLICIT_WAIT_TIME_OUT, System.getProperty(IMPLICIT_WAIT_TIME_OUT), "5");
        this.setContextAttribute(context, EXPLICIT_WAIT_TIME_OUT, System.getProperty(EXPLICIT_WAIT_TIME_OUT), "15");
        this.setContextAttribute(context, PAGE_LOAD_TIME_OUT, System.getProperty(PAGE_LOAD_TIME_OUT), "90");
        this.setContextAttribute(context, WEB_DRIVER_GRID, System.getProperty(WEB_DRIVER_GRID), null);
        this.setContextAttribute(context, RUN_MODE, System.getProperty(RUN_MODE), "LOCAL");
        this.setContextAttribute(context, BROWSER, System.getProperty(BROWSER), "*firefox");
        this.setContextAttribute(context, BROWSER_VERSION, System.getProperty(BROWSER_VERSION), null);
        this.setContextAttribute(context, WEB_PLATFORM, System.getProperty(WEB_PLATFORM), null);
        this.setContextAttribute(context, FIREFOX_USER_PROFILE_PATH, System.getProperty(FIREFOX_USER_PROFILE_PATH), null);
        this.setContextAttribute(context, USE_DEFAULT_FIREFOX_PROFILE, System.getProperty(USE_DEFAULT_FIREFOX_PROFILE), "true");
        this.setContextAttribute(context, OPERA_USER_PROFILE_PATH, System.getProperty(OPERA_USER_PROFILE_PATH), null);
        this.setContextAttribute(context, FIREFOX_BINARY_PATH, System.getProperty(FIREFOX_BINARY_PATH), null);
        this.setContextAttribute(context, CHROME_DRIVER_PATH, System.getProperty(CHROME_DRIVER_PATH), null);
        this.setContextAttribute(context, IE_DRIVER_PATH, System.getProperty(IE_DRIVER_PATH), null);
        this.setContextAttribute(context, USER_AGENT, System.getProperty(USER_AGENT), null);
        this.setContextAttribute(context, Set_Assume_Untrusted_Certificate_Issuer, System.getProperty(Set_Assume_Untrusted_Certificate_Issuer), null);
        this.setContextAttribute(context, Set_Accept_Untrusted_Certificates, System.getProperty(Set_Accept_Untrusted_Certificates), null);
        this.setContextAttribute(context, ENABLE_JAVASCRIPT, System.getProperty(ENABLE_JAVASCRIPT), null);
        this.setContextAttribute(context, NTLM_AUTH_TRUSTED_URIS, System.getProperty(NTLM_AUTH_TRUSTED_URIS), null);
        this.setContextAttribute(context, BROWSER_DOWNLOAD_DIR, System.getProperty(BROWSER_DOWNLOAD_DIR), null);
        this.setContextAttribute(context, BROWSER_WINDOW_SIZE, System.getProperty(BROWSER_WINDOW_SIZE), null);
        this.setContextAttribute(context, WEB_PROXY_ENABLED, System.getProperty(WEB_PROXY_ENABLED), "false");
        this.setContextAttribute(context, WEB_PROXY_TYPE, System.getProperty(WEB_PROXY_TYPE), null);
        this.setContextAttribute(context, WEB_PROXY_ADDRESS, System.getProperty(WEB_PROXY_ADDRESS), null);
        this.setContextAttribute(context, REPORT_GENERATION_CONFIG, System.getProperty(REPORT_GENERATION_CONFIG), "summaryPerSuite");
        this.setContextAttribute(context, OPEN_REPORT_IN_BROWSER, System.getProperty(OPEN_REPORT_IN_BROWSER), null);
        this.setContextAttribute(context, CAPTURE_SNAPSHOT, System.getProperty(CAPTURE_SNAPSHOT), null);
        this.setContextAttribute(context, ENABLE_EXCEPTION_LISTENER, System.getProperty(ENABLE_EXCEPTION_LISTENER), "true");
        this.setContextAttribute(context, DP_TAGS_INCLUDE, System.getProperty(DP_TAGS_INCLUDE), null);
        this.setContextAttribute(context, DP_TAGS_EXCLUDE, System.getProperty(DP_TAGS_EXCLUDE), null);
        this.setContextAttribute(context, SSH_COMMAND_WAIT, System.getProperty(SSH_COMMAND_WAIT), "5000");
        this.setContextAttribute(context, SOFT_ASSERT_ENABLED, System.getProperty(SOFT_ASSERT_ENABLED), "false");
        this.setContextAttribute(context, WEB_DRIVER_LISTENER, System.getProperty(WEB_DRIVER_LISTENER), null);
        this.setContextAttribute(context, APPIUM_SERVER_URL, System.getProperty(APPIUM_SERVER_URL), null);
        this.setContextAttribute(context, AUTOMATION_NAME, System.getProperty(AUTOMATION_NAME), "Appium");
        this.setContextAttribute(context, MOBILE_PLATFORM_NAME, System.getProperty(MOBILE_PLATFORM_NAME), "Android");
        this.setContextAttribute(context, MOBILE_PLATFORM_VERSION, System.getProperty(MOBILE_PLATFORM_VERSION), null);
        this.setContextAttribute(context, DEVICE_NAME, System.getProperty(DEVICE_NAME), null);
        this.setContextAttribute(context, APP, System.getProperty(APP), "");
        this.setContextAttribute(context, BROWSER_NAME, System.getProperty(BROWSER_NAME), "Browser");
        this.setContextAttribute(context, APP_PACKAGE, System.getProperty(APP_PACKAGE), null);
        this.setContextAttribute(context, APP_ACTIVITY, System.getProperty(APP_ACTIVITY), null);
        this.setContextAttribute(context, NEW_COMMAND_TIMEOUT, System.getProperty(NEW_COMMAND_TIMEOUT), "120");
        this.setContextAttribute(context, VERSION, System.getProperty(VERSION), null);
        this.setContextAttribute(context, PLATFORM, System.getProperty(PLATFORM), null);
        this.setContextAttribute(context, SAUCELABS_URL, System.getProperty(SAUCELABS_URL), null);
        if (context != null) {
            File configFile;
            this.setContextAttribute(OUTPUT_DIRECTORY, null, context.getOutputDirectory(), null);
            this.setContextAttribute(context);
            new File(context.getOutputDirectory() + "/screenshots").mkdirs();
            new File(context.getOutputDirectory() + "/htmls").mkdirs();
            new File(context.getOutputDirectory() + "/xmls").mkdirs();
            new File(context.getOutputDirectory() + "/textfiles/").mkdirs();
            String path = (String)this.getAttribute(PLUGIN_CONFIG_PATH);
            if (path != null && path.trim().length() > 0 && (configFile = new File(path)).exists()) {
                PluginsHelper.getInstance().loadPlugins(configFile);
            }
        }
    }

    public void addTearDownService(TearDownService tearDown) {
        this.tearDownServices.add(tearDown);
    }

    public void addVerificationFailures(ITestResult result, List<Throwable> failures) {
        this.verificationFailuresMap.put(result, failures);
    }

    public void addVerificationFailures(ITestResult result, Throwable failure) {
        if (this.verificationFailuresMap.get(result) != null) {
            this.verificationFailuresMap.get(result).add(failure);
        } else {
            ArrayList<Throwable> failures = new ArrayList<Throwable>();
            failures.add(failure);
            this.addVerificationFailures(result, failures);
        }
    }

    public Object getAttribute(String name) {
        Object obj = this.contextDataMap.get(name);
        return obj == null ? null : obj;
    }

    public String getBrowserDownloadDir() {
        if (this.getAttribute(BROWSER_DOWNLOAD_DIR) != null) {
            return (String)this.getAttribute(BROWSER_DOWNLOAD_DIR);
        }
        return this.getOutputDirectory() + "\\downloads\\";
    }

    public String getBrowserWindowSize() {
        return (String)this.getAttribute(BROWSER_WINDOW_SIZE);
    }

    public boolean getCaptureSnapshot() {
        if (this.getAttribute(CAPTURE_SNAPSHOT) == null) {
            if (this.getWebRunMode().equalsIgnoreCase("ExistingGrid") && (this.getWebRunBrowser().contains("iexplore") || this.getWebRunBrowser().contains("safari"))) {
                this.setAttribute(CAPTURE_SNAPSHOT, "false");
            } else {
                this.setAttribute(CAPTURE_SNAPSHOT, "true");
            }
        }
        return Boolean.parseBoolean((String)this.getAttribute(CAPTURE_SNAPSHOT));
    }

    public boolean getEnableExceptionListener() {
        return Boolean.parseBoolean((String)this.getAttribute(ENABLE_EXCEPTION_LISTENER));
    }

    public String getChromeBinPath() {
        return (String)this.getAttribute(CHROME_BINARY_PATH);
    }

    public String getChromeDriverPath() {
        return (String)this.getAttribute(CHROME_DRIVER_PATH);
    }

    public String getDPTagsExclude() {
        return (String)this.getAttribute(DP_TAGS_EXCLUDE);
    }

    public String getDPTagsInclude() {
        return (String)this.getAttribute(DP_TAGS_INCLUDE);
    }

    public int getExplicitWaitTimeout() {
        Integer timeout;
        try {
            timeout = Integer.parseInt((String)this.getAttribute(EXPLICIT_WAIT_TIME_OUT));
        }
        catch (Exception e) {
            timeout = 15;
        }
        if ((double)timeout.intValue() < this.getImplicitWaitTimeout()) {
            return (int)this.getImplicitWaitTimeout();
        }
        return timeout;
    }

    public String getFirefoxBinPath() {
        return (String)this.getAttribute(FIREFOX_BINARY_PATH);
    }

    public String getFirefoxUserProfilePath() {
        return (String)this.getAttribute(FIREFOX_USER_PROFILE_PATH);
    }

    public String getIEDriverPath() {
        return (String)this.getAttribute(IE_DRIVER_PATH);
    }

    public double getImplicitWaitTimeout() {
        try {
            return Double.parseDouble((String)this.getAttribute(IMPLICIT_WAIT_TIME_OUT));
        }
        catch (Exception e) {
            return 5.0;
        }
    }

    public String getNtlmAuthTrustedUris() {
        return (String)this.getAttribute(NTLM_AUTH_TRUSTED_URIS);
    }

    public String getReportGenerationConfig() {
        return (String)this.getAttribute(REPORT_GENERATION_CONFIG);
    }

    public String getOpenReportInBrowser() {
        return (String)this.getAttribute(OPEN_REPORT_IN_BROWSER);
    }

    public String getOperaUserProfilePath() {
        return (String)this.getAttribute(OPERA_USER_PROFILE_PATH);
    }

    public String getOutputDirectory() {
        return (String)this.getAttribute(OUTPUT_DIRECTORY);
    }

    public int getPageLoadTimeout() {
        try {
            return Integer.parseInt((String)this.getAttribute(PAGE_LOAD_TIME_OUT));
        }
        catch (Exception e) {
            return 90;
        }
    }

    public String getWebPlatform() {
        return (String)this.getAttribute(WEB_PLATFORM);
    }

    public String getAppURL() {
        return (String)this.getAttribute(APP_URL);
    }

    public int getSshCommandWait() {
        try {
            return Integer.parseInt((String)this.getAttribute(SSH_COMMAND_WAIT));
        }
        catch (Exception e) {
            return 5000;
        }
    }

    public String getSuiteParameter(String key) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        return this.getTestNGContext().getSuite().getParameter(key);
    }

    public LinkedList<TearDownService> getTearDownServices() {
        return this.tearDownServices;
    }

    public String getTestDataFile() {
        return (String)this.getAttribute(TEST_DATA_FILE);
    }

    public String getTestType() {
        return (String)this.getAttribute(TEST_TYPE);
    }

    public String getTestMethodSignature() {
        return (String)this.getAttribute(TEST_METHOD_SIGNATURE);
    }

    public ITestContext getTestNGContext() {
        return this.testNGContext;
    }

    public Object getTestEntity() {
        return this.getAttribute(TEST_ENTITY);
    }

    public String getWebDriverListener() {
        return (String)this.getAttribute(WEB_DRIVER_LISTENER);
    }

    public String getUserAgent() {
        return (String)this.getAttribute(USER_AGENT);
    }

    public List<Throwable> getVerificationFailures(ITestResult result) {
        ArrayList verificationFailures = this.verificationFailuresMap.get(result);
        return verificationFailures == null ? new ArrayList() : verificationFailures;
    }

    public String getWebBrowserVersion() {
        return (String)this.getAttribute(BROWSER_VERSION);
    }

    public String getWebDriverGrid() {
        return (String)this.getAttribute(WEB_DRIVER_GRID);
    }

    public String getWebProxyAddress() {
        return (String)this.getAttribute(WEB_PROXY_ADDRESS);
    }

    public String getWebProxyType() {
        return (String)this.getAttribute(WEB_PROXY_TYPE);
    }

    public String getWebRunBrowser() {
        return (String)this.getAttribute(BROWSER);
    }

    public String getWebRunMode() {
        return (String)this.getAttribute(RUN_MODE);
    }

    public int getWebSessionTimeout() {
        try {
            return Integer.parseInt((String)this.getAttribute(WEB_SESSION_TIME_OUT));
        }
        catch (Exception e) {
            return 90000;
        }
    }

    public String getAppiumServerURL() {
        return (String)this.getAttribute(APPIUM_SERVER_URL);
    }

    public String getAutomationName() {
        return (String)this.getAttribute(AUTOMATION_NAME);
    }

    public String getMobilePlatformName() {
        return (String)this.getAttribute(MOBILE_PLATFORM_NAME);
    }

    public String getMobilePlatformVersion() {
        return (String)this.getAttribute(MOBILE_PLATFORM_VERSION);
    }

    public String getDeviceName() {
        return (String)this.getAttribute(DEVICE_NAME);
    }

    public String getApp() {
        return (String)this.getAttribute(APP);
    }

    public String getBrowserName() {
        return (String)this.getAttribute(BROWSER_NAME);
    }

    public String getAppPackage() {
        return (String)this.getAttribute(APP_PACKAGE);
    }

    public String getAppActivity() {
        return (String)this.getAttribute(APP_ACTIVITY);
    }

    public String getNewCommandTimeout() {
        return (String)this.getAttribute(NEW_COMMAND_TIMEOUT);
    }

    public String getVersion() {
        return (String)this.getAttribute(VERSION);
    }

    public String getPlatform() {
        return (String)this.getAttribute(PLATFORM);
    }

    public String getSaucelabsURL() {
        return (String)this.getAttribute(SAUCELABS_URL);
    }

    public boolean isUseFirefoxDefaultProfile() {
        try {
            return Boolean.parseBoolean((String)this.getAttribute(USE_DEFAULT_FIREFOX_PROFILE));
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean isSoftAssertEnabled() {
        try {
            return Boolean.parseBoolean((String)this.getAttribute(SOFT_ASSERT_ENABLED));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isWebProxyEnabled() {
        try {
            return Boolean.parseBoolean((String)this.getAttribute(WEB_PROXY_ENABLED));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setAttribute(String name, Object value) {
        this.contextDataMap.put(name, value);
    }

    private void setContextAttribute(ITestContext context) {
        if (context != null) {
            Map testParameters = context.getSuite().getXmlSuite().getParameters();
            for (Map.Entry entry : testParameters.entrySet()) {
                String attributeName = (String)entry.getKey();
                if (this.contextDataMap.get(entry.getKey()) != null) continue;
                String sysPropertyValue = System.getProperty((String)entry.getKey());
                String suiteValue = (String)entry.getValue();
                this.setContextAttribute(attributeName, sysPropertyValue, suiteValue, null);
            }
        }
    }

    private void setContextAttribute(ITestContext context, String attributeName, String sysPropertyValue, String defaultValue) {
        String suiteValue = null;
        if (context != null) {
            suiteValue = context.getSuite().getParameter(attributeName);
        }
        this.contextDataMap.put(attributeName, sysPropertyValue != null ? sysPropertyValue : (suiteValue != null ? suiteValue : defaultValue));
    }

    private void setContextAttribute(String attributeName, String sysPropertyValue, String suiteValue, String defaultValue) {
        this.contextDataMap.put(attributeName, sysPropertyValue != null ? sysPropertyValue : (suiteValue != null ? suiteValue : defaultValue));
    }

    public void setExplicitWaitTimeout(double timeout) {
        this.setAttribute(EXPLICIT_WAIT_TIME_OUT, timeout);
    }

    public void setImplicitWaitTimeout(double timeout) {
        this.setAttribute(IMPLICIT_WAIT_TIME_OUT, timeout);
    }

    public void setPageLoadTimeout(int timeout) {
        this.setAttribute(PAGE_LOAD_TIME_OUT, timeout);
    }

    public void setTestDataFile(String testDataFile) {
        this.setAttribute(TEST_DATA_FILE, testDataFile);
    }

    public void setTestType(String testType) {
        this.setAttribute(TEST_TYPE, testType);
    }
}

