/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.AbstractWebDriverFactory;
import com.seleniumtests.browserfactory.AndroidCapabilitiesFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.driver.DriverConfig;
import io.appium.java_client.android.AndroidDriver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;

public class AndroidDriverFactory
extends AbstractWebDriverFactory
implements IWebDriverFactory {
    public AndroidDriverFactory(DriverConfig webDriverConfig) {
        super(webDriverConfig);
    }

    protected WebDriver createNativeDriver() throws MalformedURLException {
        return new AndroidDriver(new URL(this.webDriverConfig.getAppiumServerURL()), (Capabilities)new AndroidCapabilitiesFactory().createCapabilities(this.webDriverConfig));
    }

    @Override
    public WebDriver createWebDriver() throws IOException {
        DriverConfig cfg = this.getWebDriverConfig();
        this.driver = this.createNativeDriver();
        this.setImplicitWaitTimeout(cfg.getImplicitWaitTimeout());
        if (cfg.getPageLoadTimeout() >= 0) {
            this.setPageLoadTimeout(cfg.getPageLoadTimeout());
        }
        this.setWebDriver(this.driver);
        return this.driver;
    }

    protected void setPageLoadTimeout(long timeout) {
        try {
            this.driver.manage().timeouts().pageLoadTimeout(timeout, TimeUnit.SECONDS);
        }
        catch (UnsupportedCommandException unsupportedCommandException) {
            // empty catch block
        }
    }
}

