/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.AbstractWebDriverFactory;
import com.seleniumtests.browserfactory.IPhoneCapabilitiesFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.driver.DriverConfig;
import io.appium.java_client.ios.IOSDriver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;

public class IPhoneDriverFactory
extends AbstractWebDriverFactory
implements IWebDriverFactory {
    public IPhoneDriverFactory(DriverConfig webDriverConfig) {
        super(webDriverConfig);
    }

    protected WebDriver createNativeDriver() throws MalformedURLException {
        return new IOSDriver(new URL(this.webDriverConfig.getAppiumServerURL()), (Capabilities)new IPhoneCapabilitiesFactory().createCapabilities(this.webDriverConfig));
    }

    @Override
    public WebDriver createWebDriver() throws IOException {
        DriverConfig cfg = this.getWebDriverConfig();
        this.driver = this.createNativeDriver();
        this.setImplicitWaitTimeout(cfg.getImplicitWaitTimeout());
        if (cfg.getPageLoadTimeout() >= 0) {
            this.setPageLoadTimeout(cfg.getPageLoadTimeout());
        }
        this.setWebDriver(this.driver);
        return this.driver;
    }

    protected void setPageLoadTimeout(long timeout) {
        try {
            this.driver.manage().timeouts().pageLoadTimeout(timeout, TimeUnit.SECONDS);
        }
        catch (UnsupportedCommandException unsupportedCommandException) {
            // empty catch block
        }
    }
}

