/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.seleniumtests.core.SeleniumTestsContextManager;
import com.seleniumtests.core.TearDownService;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.core.TestRetryAnalyzer;
import com.seleniumtests.driver.WebUIDriver;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.xml.XmlTest;

public abstract class SeleniumTestPlan {
    private static final Logger logger = TestLogging.getLogger(SeleniumTestPlan.class);
    private Date start;

    @BeforeSuite(alwaysRun=true)
    public void beforeTestSuite(ITestContext testContext) throws IOException {
        System.out.println("####################################################");
        System.out.println("####################################################");
        System.out.println("####################################################");
        System.out.println("WWW.SELENIUMTESTS.COM");
        System.out.println("WWW.SELENIUMTESTS.COM");
        System.out.println("WWW.SELENIUMTESTS.COM");
        System.out.println("####################################################");
        System.out.println("####################################################");
        System.out.println("####################################################");
        this.start = new Date();
        SeleniumTestsContextManager.initGlobalContext(testContext);
        SeleniumTestsContextManager.initThreadContext(testContext, null);
    }

    @BeforeTest(alwaysRun=true)
    public void beforeTest(ITestContext testContext, XmlTest xmlTest) {
        SeleniumTestsContextManager.initTestLevelContext(testContext, xmlTest);
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeTestMethod(Object[] parameters, Method method, ITestContext testContex, XmlTest xmlTest) {
        logger.info((Object)(Thread.currentThread() + " Start method " + method.getName()));
        SeleniumTestsContextManager.initThreadContext(testContex, xmlTest);
        if (method != null) {
            SeleniumTestsContextManager.getThreadContext().setAttribute("testMethodSignature", this.buildMethodSignature(method, parameters));
        }
    }

    @AfterSuite(alwaysRun=true)
    public void afterTestSuite() {
        logger.info((Object)("Test Suite Execution Time: " + (new Date().getTime() - this.start.getTime()) / 1000L / 60L + " minutes."));
    }

    @AfterMethod(alwaysRun=true)
    public void afterTestMethod(Object[] parameters, Method method, ITestContext testContex, XmlTest xmlTest) {
        LinkedList<TearDownService> serviceList = SeleniumTestsContextManager.getThreadContext().getTearDownServices();
        if (serviceList != null && !serviceList.isEmpty()) {
            for (TearDownService service : serviceList) {
                service.tearDown();
            }
        }
        WebUIDriver.cleanUp();
        logger.info((Object)(Thread.currentThread() + " Finish method " + method.getName()));
    }

    @AfterClass(alwaysRun=true)
    public void afterTest() {
        TestRetryAnalyzer.resetCount();
    }

    private String buildMethodSignature(Method method, Object[] parameters) {
        return method.getDeclaringClass().getCanonicalName() + "." + method.getName() + "(" + this.buildParameterString(parameters) + ")";
    }

    private String buildParameterString(Object[] parameters) {
        StringBuffer parameter = new StringBuffer();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) {
                    parameter.append("null, ");
                    continue;
                }
                if (parameters[i] instanceof String) {
                    parameter.append("\"").append(parameters[i]).append("\", ");
                    continue;
                }
                parameter.append(parameters[i]).append(", ");
            }
        }
        if (parameter.length() > 0) {
            parameter.delete(parameter.length() - 2, parameter.length() - 1);
        }
        return parameter.toString();
    }
}

