/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.seleniumtests.core.TestLogging;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class TestRetryAnalyzer
implements IRetryAnalyzer {
    public static final int MAX_RETRY_COUNT = 3;
    private static int count = 3;

    public int getCount() {
        return count;
    }

    private boolean isRetryAvailable() {
        return count > 0;
    }

    public static void resetCount() {
        count = 3;
    }

    public boolean retry(ITestResult result) {
        boolean retry = false;
        if (this.isRetryAvailable()) {
            TestLogging.log("<br> Going to retry test case: " + result.getMethod() + ", " + (3 - count + 1) + " out of " + 3 + "</br>");
            retry = true;
            --count;
        }
        return retry;
    }
}

