/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.reporter;

import com.seleniumtests.core.CustomAssertion;
import com.seleniumtests.core.SeleniumTestsContext;
import com.seleniumtests.core.SeleniumTestsContextManager;
import com.seleniumtests.core.SeleniumTestsPageListener;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.core.TestRetryAnalyzer;
import com.seleniumtests.driver.ScreenShot;
import com.seleniumtests.driver.ScreenshotUtil;
import com.seleniumtests.driver.TestType;
import com.seleniumtests.driver.WebUIDriver;
import com.seleniumtests.helper.StringUtility;
import com.seleniumtests.reporter.ElaborateLog;
import com.seleniumtests.reporter.PluginsHelper;
import com.seleniumtests.reporter.ShortTestResult;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.Type;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.internal.ResultMap;
import org.testng.internal.Utils;
import org.testng.xml.XmlSuite;

public class SeleniumTestsReporter
implements IReporter,
ITestListener,
IInvokedMethodListener {
    private static final Logger logger = TestLogging.getLogger(SeleniumTestsReporter.class);
    private final Map<String, Boolean> isRetryHandleNeeded = new HashMap<String, Boolean>();
    private final Map<String, IResultMap> failedTests = new HashMap<String, IResultMap>();
    private final Map<String, IResultMap> skippedTests = new HashMap<String, IResultMap>();
    protected PrintWriter m_out;
    private String uuid = new GregorianCalendar().getTime().toString();
    private int m_treeId = 0;
    private String outputDirectory;
    private String resources;
    private JavaDocBuilder builder = null;
    private File report;
    Map<String, ITestResult> methodsByGroup = null;

    protected static String escape(String string) {
        if (null == string) {
            return string;
        }
        return string.replaceAll("\n", "<br/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResourceToFile(File file, String resourceName, Class<?> aClass) throws IOException {
        InputStream inputStream = aClass.getResourceAsStream("/" + resourceName);
        if (inputStream == null) {
            logger.error((Object)("can not find resource on the class path: " + resourceName));
        } else {
            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                try {
                    int i;
                    byte[] buffer = new byte[4096];
                    while (0 < (i = inputStream.read(buffer))) {
                        outputStream.write(buffer, 0, i);
                    }
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    private void addAllTestResults(Set<ITestResult> testResults, IResultMap resultMap) {
        if (resultMap != null) {
            testResults.addAll(resultMap.getAllResults());
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult result) {
        Reporter.setCurrentTestResult((ITestResult)result);
        if (method.isTestMethod()) {
            List<Throwable> verificationFailures = CustomAssertion.getVerificationFailures();
            int size = verificationFailures.size();
            if (size == 0) {
                return;
            }
            if (result.getStatus() == 2) {
                return;
            }
            result.setStatus(2);
            if (size == 1) {
                result.setThrowable(verificationFailures.get(0));
            } else {
                StringBuilder failureMessage = new StringBuilder("!!! Many Test Failures (").append(size).append(")\n");
                for (int i = 0; i < size - 1; ++i) {
                    failureMessage.append("Failure ").append(i + 1).append(" of ").append(size).append("\n");
                    Throwable t = verificationFailures.get(i);
                    String fullStackTrace = Utils.stackTrace((Throwable)t, (boolean)false)[1];
                    failureMessage.append(fullStackTrace).append("\n");
                }
                Throwable last = verificationFailures.get(size - 1);
                failureMessage.append("Failure ").append(size).append(" of ").append(size).append(":n");
                failureMessage.append(last.toString());
                Throwable merged = new Throwable(failureMessage.toString());
                merged.setStackTrace(last.getStackTrace());
                result.setThrowable(merged);
            }
        }
    }

    public void beforeInvocation(IInvokedMethod arg0, ITestResult arg1) {
    }

    protected void copyResources() throws Exception {
        new File(this.outputDirectory + File.separator + "resources").mkdir();
        new File(this.outputDirectory + File.separator + "resources" + File.separator + "css").mkdir();
        new File(this.outputDirectory + File.separator + "resources" + File.separator + "images").mkdir();
        new File(this.outputDirectory + File.separator + "resources" + File.separator + "images" + File.separator + "lightbox").mkdir();
        new File(this.outputDirectory + File.separator + "resources" + File.separator + "images" + File.separator + "mktree").mkdir();
        new File(this.outputDirectory + File.separator + "resources" + File.separator + "images" + File.separator + "yukontoolbox").mkdir();
        new File(this.outputDirectory + File.separator + "resources" + File.separator + "js").mkdir();
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("reporter" + File.separator + "css" + File.separator + "report.css");
        resources.add("reporter" + File.separator + "css" + File.separator + "jquery.lightbox-0.5.css");
        resources.add("reporter" + File.separator + "css" + File.separator + "mktree.css");
        resources.add("reporter" + File.separator + "images" + File.separator + "lightbox" + File.separator + "seleniumtests_lightbox-blank.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "lightbox" + File.separator + "seleniumtests_lightbox-btn-close.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "lightbox" + File.separator + "seleniumtests_lightbox-btn-next.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "lightbox" + File.separator + "seleniumtests_lightbox-btn-prev.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "lightbox" + File.separator + "seleniumtests_lightbox-ico-loading.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "mktree" + File.separator + "seleniumtests_bullet.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "mktree" + File.separator + "seleniumtests_minus.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "mktree" + File.separator + "seleniumtests_plus.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "mktree" + File.separator + "seleniumtests_test1.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "mktree" + File.separator + "seleniumtests_test2.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "mktree" + File.separator + "seleniumtests_test3.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "mktree" + File.separator + "seleniumtests_test3.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_footer_grad.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_grey_bl.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_grey_br.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_hovertab_l.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_hovertab_r.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_tabbed_nav_goldgradbg.png");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_table_sep_left.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_table_sep_right.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_table_zebrastripe_left.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_table_zebrastripe_right.gif");
        resources.add("reporter" + File.separator + "images" + File.separator + "yukontoolbox" + File.separator + "seleniumtests_yellow_tr.gif");
        resources.add("reporter" + File.separator + "js" + File.separator + "jquery-1.10.2.min.js");
        resources.add("reporter" + File.separator + "js" + File.separator + "jquery.lightbox-0.5.min.js");
        resources.add("reporter" + File.separator + "js" + File.separator + "mktree.js");
        resources.add("reporter" + File.separator + "js" + File.separator + "report.js");
        resources.add("reporter" + File.separator + "js" + File.separator + "browserdetect.js");
        for (String resourceName : resources) {
            File f = new File(this.outputDirectory, resourceName.replace("reporter", "resources"));
            resourceName = resourceName.replaceAll("\\\\", "/");
            logger.debug((Object)("Begin to write resource " + resourceName + " to file " + f.getAbsolutePath()));
            SeleniumTestsReporter.writeResourceToFile(f, resourceName, SeleniumTestsReporter.class);
        }
    }

    protected PrintWriter createWriter(String outDir) throws IOException, FileNotFoundException {
        System.setProperty("file.encoding", "UTF8");
        this.uuid = this.uuid.replaceAll(" ", "-").replaceAll(":", "-");
        File f = new File(outDir, "SeleniumTestReport.html");
        logger.info((Object)("generating report " + f.getAbsolutePath()));
        this.report = f;
        FileOutputStream out = new FileOutputStream(f);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "utf-8"));
        return new PrintWriter(writer);
    }

    protected void endHtml(PrintWriter out) {
        out.println("</body></html>");
    }

    public void executeCmd(String browserPath, String theUrl) {
        String osName = System.getProperty("os.name");
        String cmdLine = osName.startsWith("Windows") ? "rundll32 SHELL32.DLL,ShellExec_RunDLL " + browserPath + " " + theUrl : (osName.startsWith("Mac") ? "open " + theUrl : "open " + browserPath + " " + theUrl);
        try {
            Runtime.getRuntime().exec(cmdLine);
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    protected void generateExceptionReport(Throwable exception, ITestNGMethod method, String title, StringBuffer contentBuffer, String lastLine) {
        this.generateTheStackTrace(exception, method, title, contentBuffer, lastLine);
    }

    protected void generateExceptionReport(Throwable exception, ITestNGMethod method, StringBuffer contentBuffer, String lastline) {
        Throwable fortile = exception;
        String title = fortile.getMessage();
        if (title == null) {
            try {
                title = fortile.getCause().getMessage();
            }
            catch (Throwable e) {
                title = e.getMessage();
            }
        }
        this.generateExceptionReport(exception, method, title, contentBuffer, lastline);
    }

    protected void generateGlobalErrorHTML(ITestContext testContext, StringBuffer errorCountTabs, StringBuffer errorCountHtmls) {
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"class");
            ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.init();
            List<SeleniumTestsPageListener> pageListenersList = PluginsHelper.getInstance().getPageListeners();
            for (SeleniumTestsPageListener abstractPageListener : pageListenersList) {
                if (!abstractPageListener.isTestResultEffected()) continue;
                errorCountTabs.append("<li class='tab' id='" + abstractPageListener.getClass().getSimpleName() + "'><a href='#'><span>").append(abstractPageListener.getTitle() != null ? abstractPageListener.getTitle() : abstractPageListener.getClass().getSimpleName()).append(" ( <font color='red'>");
                errorCountHtmls.append("<div class='" + abstractPageListener.getClass().getSimpleName() + "' style='width: 98%;margin-left:15px;'>");
                this.generateGlobalErrorsPanel(abstractPageListener, ve, errorCountHtmls, "failed", testContext, errorCountTabs);
                errorCountHtmls.append("</div>");
                errorCountTabs.append("</font> )</span></a></li>");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void generateGlobalErrorsPanel(SeleniumTestsPageListener abstractPageListener, VelocityEngine ve, StringBuffer res, String style, ITestContext tc, StringBuffer sbCalcount) {
        int pageCount = 0;
        HashSet<ITestResult> testResults = new HashSet<ITestResult>();
        this.addAllTestResults(testResults, tc.getPassedTests());
        this.addAllTestResults(testResults, this.failedTests.get(tc.getName()));
        this.addAllTestResults(testResults, tc.getFailedButWithinSuccessPercentageTests());
        Map<String, Map<String, List<String>>> pageListenerLogMap = TestLogging.getPageListenerLog(abstractPageListener.getClass().getCanonicalName());
        if (pageListenerLogMap == null || pageListenerLogMap.isEmpty()) {
            res.append("<div class='method passed'><div class='yuk_goldgrad_tl'><div class='yuk_goldgrad_tr'><div class='yuk_goldgrad_m'></div></div></div><h3 class='yuk_grad_ltitle_passed'>No Errors found.</h3><div class='yuk_pnl_footerbar'></div><div class='yuk_grey_bm_footer'><div class='yuk_grey_br'><div class='yuk_grey_bl'></div></div></div></div>");
        } else {
            for (Map.Entry<String, Map<String, List<String>>> pageEntry : pageListenerLogMap.entrySet()) {
                StringBuilder contentBuffer = new StringBuilder();
                contentBuffer.append("<table  class='ex' width='90%'><thead><tr><th>TestMethod</th><th>Errors</th></thead><tbody>");
                Map<String, List<String>> errorMap = pageEntry.getValue();
                boolean found = false;
                for (ITestResult testResult : testResults) {
                    Method method = testResult.getMethod().getMethod();
                    String methodInstance = StringUtility.constructMethodSignature(method, testResult.getParameters());
                    if (!errorMap.containsKey(methodInstance)) continue;
                    found = true;
                    contentBuffer.append("<tr><td>" + methodInstance + "</td><td>");
                    for (String message : errorMap.get(methodInstance)) {
                        contentBuffer.append(message);
                        contentBuffer.append("<br>");
                    }
                    contentBuffer.append("</td><tr>");
                }
                if (!found) continue;
                contentBuffer.append("</tbody></table>");
                try {
                    Template t = ve.getTemplate("/templates/report.part.singlePageError.html");
                    VelocityContext context = new VelocityContext();
                    context.put("status", (Object)style);
                    context.put("pageName", (Object)pageEntry.getKey());
                    context.put("content", (Object)contentBuffer.toString());
                    StringWriter writer = new StringWriter();
                    t.merge((Context)context, (Writer)writer);
                    res.append(writer.toString());
                }
                catch (Exception e) {
                    logger.error((Object)("errorLogger creating a singlePageError." + e.getMessage()));
                }
                ++pageCount;
            }
        }
        sbCalcount.append(pageCount);
    }

    protected String generateHTML(ITestContext tc, boolean envt, ISuite suite, ITestContext ctx) {
        StringBuffer res = new StringBuffer();
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"class");
            ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.init();
            if (envt) {
                if (tc.getFailedConfigurations().getAllResults().size() > 0) {
                    this.generatePanel(ve, tc.getFailedConfigurations(), res, "failed", suite, ctx, envt);
                }
                this.generatePanel(ve, this.failedTests.get(tc.getName()), res, "failed", suite, ctx, envt);
                if (tc.getFailedConfigurations().getAllResults().size() > 0) {
                    this.generatePanel(ve, tc.getSkippedConfigurations(), res, "skipped", suite, ctx, envt);
                }
                this.generatePanel(ve, this.skippedTests.get(tc.getName()), res, "skipped", suite, ctx, envt);
                this.generatePanel(ve, tc.getPassedTests(), res, "passed", suite, ctx, envt);
            } else {
                this.generatePanel(ve, this.failedTests.get(tc.getName()), res, "failed", suite, ctx, envt);
                this.generatePanel(ve, this.skippedTests.get(tc.getName()), res, "skipped", suite, ctx, envt);
                this.generatePanel(ve, tc.getPassedTests(), res, "passed", suite, ctx, envt);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return res.toString();
    }

    protected void generatePanel(VelocityEngine ve, IResultMap map, StringBuffer res, String style, ISuite suite, ITestContext ctx, boolean envt) {
        Collection<ITestNGMethod> methodSet = this.getMethodSet(map);
        for (ITestNGMethod method : methodSet) {
            boolean methodIsValid;
            if (envt) {
                methodIsValid = Arrays.asList(method.getGroups()).contains("envt");
            } else {
                boolean bl = methodIsValid = !Arrays.asList(method.getGroups()).contains("envt");
            }
            if (!methodIsValid) continue;
            Collection<ITestResult> resultSet = this.getResultSet(map, method);
            for (ITestResult ans : resultSet) {
                boolean hasThrowable;
                StringBuffer contentBuffer = new StringBuffer();
                String testName = "";
                if (ans.getMethod().getXmlTest() != null) {
                    testName = ans.getMethod().getXmlTest().getName();
                } else {
                    try {
                        testName = ans.getTestContext().getCurrentXmlTest().getName();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                SeleniumTestsContext testLevelContext = SeleniumTestsContextManager.getTestLevelContext(testName);
                if (testLevelContext != null) {
                    String appURL = testLevelContext.getAppURL();
                    String executionURL = testLevelContext.getExecutionURL();
                    String browser = testLevelContext.getWebRunBrowser();
                    String app = testLevelContext.getApp();
                    String appPackage = testLevelContext.getAppPackage();
                    String appActivity = testLevelContext.getAppActivity();
                    String testType = testLevelContext.getTestType();
                    String browserVersion = (String)testLevelContext.getAttribute("browserVersion");
                    if (browser != null) {
                        browser = browser.replace("*", "");
                    }
                    if (browserVersion != null) {
                        browser = browser + " " + browserVersion;
                    }
                    if (testType.equalsIgnoreCase(TestType.WEB.getTestType())) {
                        contentBuffer.append("<div><i>").append("<b><a target=\"_blank\" rel=\"noopener noreferrer\" href=").append(appURL).append(">App URL,</a></b>").append(" Browser: <b>").append(browser).append(", ").append("</b> <b> <a target=\"_blank\" rel=\"noopener noreferrer\" href=").append(executionURL).append(">Execution URL</a></b>").append("</i></div>");
                    } else if (testType.equalsIgnoreCase(TestType.APP.getTestType())) {
                        if (StringUtils.isNotBlank((String)app)) {
                            contentBuffer.append("<div><i>App:  <b>" + app + "</b></i></div>");
                        } else if (StringUtils.isNotBlank((String)appPackage)) {
                            contentBuffer.append("<div><i>App Package: <b>" + appPackage + "</b>, App Activity:  <b>" + (String)appActivity + "</b></i></div>");
                        }
                    } else if (testType.equalsIgnoreCase(TestType.NON_GUI.getTestType())) {
                        contentBuffer.append("<div><i></i></div>");
                    } else {
                        contentBuffer.append("<div><i>Invalid Test Type</i></div>");
                    }
                }
                Object[] parameters = ans.getParameters();
                List msgs = Reporter.getOutput((ITestResult)ans);
                boolean hasReporterOutput = msgs.size() > 0;
                Throwable exception = ans.getThrowable();
                boolean bl = hasThrowable = exception != null;
                if (hasReporterOutput || hasThrowable) {
                    contentBuffer.append("<div class='leftContent' style='float: left; width: 100%;'>");
                    contentBuffer.append("<h4><a href='javascript:void(0);' class='testloglnk'>Test Steps " + (style.equals("passed") ? "[+]" : "[ - ]") + "</a></h4>");
                    contentBuffer.append("<div class='testlog' " + (style.equals("passed") ? "style='display:none'" : "") + ">");
                    contentBuffer.append("<ol>");
                    for (String line : msgs) {
                        ElaborateLog logLine = new ElaborateLog(line, this.outputDirectory);
                        String htmllog = logLine.getHref() != null ? "<a href='" + logLine.getHref() + "' title='" + logLine.getLocation() + "' >" + logLine.getMsg() + "</a>" : logLine.getMsg();
                        htmllog = htmllog.replaceAll("@@lt@@", "<").replace("^^greaterThan^^", ">");
                        contentBuffer.append(htmllog);
                        if (htmllog.contains("<br>")) continue;
                        contentBuffer.append("<br/>");
                    }
                    contentBuffer.append("</ol>");
                    String lastLine = "";
                    for (int lastIdx = msgs.size() - 1; lastIdx >= 0 && (lastLine = ((String)msgs.get(lastIdx)).replaceAll("@@lt@@", "<").replace("^^greaterThan^^", ">")).indexOf(">screenshot</a>") == -1; --lastIdx) {
                    }
                    if (hasThrowable) {
                        this.generateExceptionReport(exception, method, contentBuffer, lastLine);
                    }
                    contentBuffer.append("</div></div>");
                }
                String treeId = "tree" + this.m_treeId;
                ++this.m_treeId;
                if (ans.getStatus() == 3) {
                    contentBuffer.append("<br>method skipped, because of its dependencies :<br>");
                    this.takeCareOfDirectDependencies(suite, method, 0, ctx, treeId, contentBuffer);
                }
                contentBuffer.append("<div class='clear_both'></div>");
                String content = contentBuffer.toString();
                try {
                    Template t = ve.getTemplate("/templates/report.part.singleTest.html");
                    VelocityContext context = new VelocityContext();
                    context.put("status", (Object)style);
                    String javadoc = this.getJavadocComments(method);
                    String desc = method.getDescription();
                    String toDisplay = "neither javadoc nor description for this method.";
                    if (!"".equals(javadoc) && javadoc != null) {
                        toDisplay = javadoc;
                    } else if (!"".equals(desc) && desc != null) {
                        toDisplay = desc;
                    }
                    String methodSignature = StringUtility.constructMethodSignature(method.getMethod(), parameters);
                    if (methodSignature.length() > 500) {
                        context.put("methodName", (Object)(methodSignature.substring(0, 500) + "..."));
                    } else {
                        context.put("methodName", (Object)methodSignature);
                    }
                    context.put("desc", (Object)toDisplay.replaceAll("\r\n\r\n", "\r\n").replaceAll("\n\n", "\n"));
                    context.put("content", (Object)content);
                    context.put("time", (Object)("Time: " + (ans.getEndMillis() - ans.getStartMillis()) / 1000L + "sec."));
                    StringWriter writer = new StringWriter();
                    t.merge((Context)context, (Writer)writer);
                    res.append(writer.toString());
                }
                catch (Exception e) {
                    logger.error((Object)("Exception creating a singleTest." + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
    }

    public void generateReport(List<XmlSuite> xml, List<ISuite> suites, String outdir) {
        ITestContext testCtx = SeleniumTestsContextManager.getGlobalContext().getTestNGContext();
        if (testCtx == null) {
            logger.error((Object)"Looks like your class does not extend from SeleniumTestPlan!");
            return;
        }
        File f = new File(SeleniumTestsContextManager.getGlobalContext().getOutputDirectory());
        this.setOutputDirectory(f.getParentFile().getAbsolutePath());
        this.setResources(this.getOutputDirectory() + "\\resources");
        try {
            this.m_out = this.createWriter(this.getOutputDirectory());
            this.startHtml(testCtx, this.m_out);
            if ("summaryPerSuite".equalsIgnoreCase(SeleniumTestsContextManager.getGlobalContext().getReportGenerationConfig())) {
                ArrayList<ISuite> singleSuiteList;
                for (ISuite suite : suites) {
                    singleSuiteList = new ArrayList<ISuite>();
                    singleSuiteList.add(suite);
                    this.generateSuiteSummaryReport(singleSuiteList, suite.getName());
                }
                for (ISuite suite : suites) {
                    singleSuiteList = new ArrayList();
                    singleSuiteList.add(suite);
                    this.generateReportsSection(singleSuiteList);
                }
            } else {
                this.generateSuiteSummaryReport(suites, xml.get(0).getName());
                this.generateReportsSection(suites);
            }
            this.endHtml(this.m_out);
            this.m_out.flush();
            this.m_out.close();
            this.copyResources();
            logger.info((Object)"Completed Report Generation.");
            String browserPath = (String)SeleniumTestsContextManager.getGlobalContext().getAttribute("openReportInBrowser");
            if (browserPath != null && browserPath.trim().length() > 0) {
                this.executeCmd(browserPath, this.getReportLocation().getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.error((Object)"output file", (Throwable)e);
        }
    }

    protected void generateReportDetailsContainer(String name, int envtp, int envtf, int envts, int testp, int testf, int tests, String envthtml, String testhtml, String globalErrorTabs, String globalErrorHtmls) {
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"class");
            ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.init();
            Template t = ve.getTemplate("/templates/report.part.testDetail.html");
            VelocityContext context = new VelocityContext();
            context.put("testId", (Object)StringUtility.md5(name));
            context.put("testName", (Object)name);
            context.put("envtp", (Object)envtp);
            context.put("envtf", (Object)envtf);
            context.put("envts", (Object)envts);
            context.put("testp", (Object)testp);
            context.put("testf", (Object)testf);
            context.put("tests", (Object)tests);
            context.put("envthtml", (Object)envthtml);
            context.put("testhtml", (Object)testhtml);
            context.put("globalerrortabs", (Object)globalErrorTabs);
            context.put("globalerrorhtmls", (Object)globalErrorHtmls);
            StringWriter writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
            this.m_out.write(writer.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    protected void generateReportsSection(List<ISuite> suites) {
        this.m_out.println("<div id='reports'>");
        for (ISuite suite : suites) {
            Map r = suite.getResults();
            for (ISuiteResult r2 : r.values()) {
                ITestContext tc = r2.getTestContext();
                int envtp = this.getNbInstanceForGroup(true, tc.getPassedTests());
                int envtf = this.getNbInstanceForGroup(true, this.failedTests.get(tc.getName()));
                int envts = this.getNbInstanceForGroup(true, this.skippedTests.get(tc.getName()));
                envtf += this.getNbInstanceForGroup(true, tc.getFailedConfigurations());
                envts += this.getNbInstanceForGroup(true, tc.getSkippedConfigurations());
                int testp = this.getNbInstanceForGroup(false, tc.getPassedTests());
                int testf = this.getNbInstanceForGroup(false, this.failedTests.get(tc.getName()));
                int tests = this.getNbInstanceForGroup(false, this.skippedTests.get(tc.getName()));
                String envthtml = this.generateHTML(tc, true, suite, tc);
                String testhtml = this.generateHTML(tc, false, suite, tc);
                StringBuffer globalErrorTabs = new StringBuffer();
                StringBuffer globalErrorHtmls = new StringBuffer();
                this.generateGlobalErrorHTML(tc, globalErrorTabs, globalErrorHtmls);
                this.generateReportDetailsContainer(tc.getName(), envtp, envtf, envts, testp, testf, tests, envthtml, testhtml, globalErrorTabs.toString(), globalErrorHtmls.toString());
            }
        }
        this.m_out.println("</div>");
    }

    public void generateSuiteSummaryReport(List<ISuite> suites, String suiteName) {
        DecimalFormat formatter = new DecimalFormat("#,##0.0");
        int qty_method = 0;
        int qty_pass_s = 0;
        int qty_skip = 0;
        int qty_fail = 0;
        long time_start = Long.MAX_VALUE;
        long time_end = Long.MIN_VALUE;
        ArrayList<ShortTestResult> tests2 = new ArrayList<ShortTestResult>();
        for (ISuite suite : suites) {
            Map tests = suite.getResults();
            for (ISuiteResult r : tests.values()) {
                ITestContext overview = r.getTestContext();
                ShortTestResult mini = new ShortTestResult(overview.getName());
                int q = overview.getAllTestMethods().length;
                qty_method += q;
                mini.setTotalMethod(q);
                q = overview.getPassedTests().size();
                qty_pass_s += q;
                mini.setInstancesPassed(q);
                q = this.skippedTests.get(overview.getName()).size();
                qty_skip += q;
                mini.setInstancesSkipped(q);
                q = this.isRetryHandleNeeded.get(overview.getName()) != false ? this.failedTests.get(overview.getName()).size() : this.failedTests.get(overview.getName()).size() + this.getNbInstanceForGroup(true, overview.getFailedConfigurations());
                qty_fail += q;
                mini.setInstancesFailed(q);
                time_start = Math.min(overview.getStartDate().getTime(), time_start);
                time_end = Math.max(overview.getEndDate().getTime(), time_end);
                tests2.add(mini);
            }
        }
        ShortTestResult total = new ShortTestResult("total");
        total.setTotalMethod(qty_method);
        total.setInstancesPassed(qty_pass_s);
        total.setInstancesFailed(qty_fail);
        total.setInstancesSkipped(qty_skip);
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"class");
            ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.init();
            Template t = ve.getTemplate("/templates/report.part.summary.html");
            VelocityContext context = new VelocityContext();
            context.put("suiteName", (Object)suiteName);
            context.put("totalRunTime", (Object)(formatter.format((double)(time_end - time_start) / 1000.0) + " sec"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE dd MMM HH:mm:ss zzz yyyy");
            context.put("TimeStamp", (Object)simpleDateFormat.format(new GregorianCalendar().getTime()));
            context.put("tests", tests2);
            context.put("total", (Object)total);
            StringWriter writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
            this.m_out.write(writer.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    protected void generateTheStackTrace(Throwable exception, ITestNGMethod method, String title, StringBuffer contentBuffer, String lastline) {
        contentBuffer.append(" <div class='stContainer' >" + exception.getClass() + ":" + SeleniumTestsReporter.escape(title) + "(<a  href='javascript:void(0);'  class='exceptionlnk'>stacktrace</a>)");
        contentBuffer.append("<div class='exception' style='display:none'>");
        StackTraceElement[] s1 = exception.getStackTrace();
        Throwable t2 = exception.getCause();
        if (t2 == exception) {
            t2 = null;
        }
        for (int x = 0; x < s1.length; ++x) {
            contentBuffer.append((x > 0 ? "<br/>at " : "") + SeleniumTestsReporter.escape(s1[x].toString()));
        }
        if (t2 != null) {
            this.generateExceptionReport(t2, method, "Caused by " + t2.getLocalizedMessage(), contentBuffer, "");
        }
        contentBuffer.append("</div></div>");
    }

    protected Collection<ITestNGMethod> getAllMethods(ISuite suite) {
        LinkedHashSet<ITestNGMethod> all = new LinkedHashSet<ITestNGMethod>();
        Map methods = suite.getMethodsByGroups();
        for (Map.Entry group : methods.entrySet()) {
            all.addAll((Collection)methods.get(group.getKey()));
        }
        return all;
    }

    protected int getDim(Class<?> cls) {
        int dim = 0;
        while (cls.isArray()) {
            ++dim;
            cls = cls.getComponentType();
        }
        return dim;
    }

    protected ITestResult getFailedOrSkippedResult(ITestContext ctx, ITestNGMethod method) {
        LinkedList res = new LinkedList();
        res.addAll(this.failedTests.get(ctx.getName()).getResults(method));
        if (res.size() != 0) {
            return (ITestResult)res.get(0);
        }
        res.addAll(ctx.getPassedTests().getResults(method));
        if (res.size() != 0) {
            return (ITestResult)res.get(0);
        }
        res.addAll(this.skippedTests.get(ctx.getName()).getResults(method));
        if (res.size() != 0) {
            return (ITestResult)res.get(0);
        }
        return null;
    }

    protected JavaDocBuilder getJavaDocBuilder(Class clz) throws URISyntaxException {
        String projectPath = new File("").getAbsolutePath();
        String packagePath = clz.getPackage().getName().replaceAll("\\.", "/");
        if (this.builder == null) {
            this.builder = new JavaDocBuilder();
            URL resource = Thread.currentThread().getContextClassLoader().getResource(packagePath);
            File src = new File(resource.toURI());
            this.builder.addSourceTree(src);
            File realFolder = new File(projectPath + "/src/main/java/" + packagePath);
            if (realFolder.exists()) {
                this.builder.addSourceTree(realFolder);
            }
        }
        return this.builder;
    }

    protected String getJavadocComments(ITestNGMethod method) {
        try {
            Method m = method.getMethod();
            String javaClass = m.getDeclaringClass().getName();
            String javaMethod = m.getName();
            JavaClass jc = this.getJavaDocBuilder(m.getDeclaringClass()).getClassByName(javaClass);
            Class<?>[] types = method.getMethod().getParameterTypes();
            Type[] qdoxTypes = new Type[types.length];
            for (int i = 0; i < types.length; ++i) {
                String type = this.getType(types[i]);
                int dim = this.getDim(types[i]);
                qdoxTypes[i] = new Type(type, dim);
            }
            JavaMethod jm = jc.getMethodBySignature(javaMethod, qdoxTypes);
            return jm.getComment();
        }
        catch (Throwable e) {
            logger.error((Object)("Exception loading the javadoc comments for : " + method.getMethodName() + e));
            return null;
        }
    }

    protected Collection<ITestNGMethod> getMethodSet(IResultMap tests) {
        TreeSet<ITestNGMethod> r = new TreeSet<ITestNGMethod>(new TestMethodSorter());
        r.addAll(tests.getAllMethods());
        return r;
    }

    protected int getNbInstanceForGroup(boolean envt, IResultMap tests) {
        int res = 0;
        for (ITestResult result : tests.getAllResults()) {
            boolean resultIsAnEnvtRes = Arrays.asList(result.getMethod().getGroups()).contains("envt");
            if (resultIsAnEnvtRes) {
                if (!envt) continue;
                ++res;
                continue;
            }
            if (envt) continue;
            ++res;
        }
        return res;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public File getReportLocation() {
        return this.report;
    }

    public String getResources() {
        return this.resources;
    }

    protected Collection<ITestResult> getResultSet(IResultMap tests, ITestNGMethod method) {
        TreeSet<ITestResult> r = new TreeSet<ITestResult>(new TestResultSorter());
        for (ITestResult result : tests.getAllResults()) {
            if (!result.getMethod().getMethodName().equals(method.getMethodName())) continue;
            r.add(result);
        }
        return r;
    }

    protected ITestNGMethod getTestNGMethod(ITestContext ctx, String method) {
        HashSet<ITestNGMethod> methods = new HashSet<ITestNGMethod>();
        int index = method.substring(0, method.lastIndexOf(".")).lastIndexOf(".");
        String localMethod = method.substring(index + 1);
        ITestNGMethod[] all = ctx.getAllTestMethods();
        for (int i = 0; i < all.length; ++i) {
            methods.add(all[i]);
        }
        for (ITestNGMethod m : methods) {
            if (!m.toString().startsWith(localMethod)) continue;
            return m;
        }
        throw new RuntimeException("method " + method + " not found. Should not happen. Suite " + ctx.getName());
    }

    protected String getType(Class<?> cls) {
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls.getName();
    }

    protected boolean hasDependencies(ITestNGMethod method) {
        return method.getGroupsDependedUpon().length + method.getMethodsDependedUpon().length != 0;
    }

    protected Map<String, ITestResult> initMethodsByGroup() {
        this.methodsByGroup = new HashMap<String, ITestResult>();
        return null;
    }

    public void onFinish(ITestContext arg0) {
        if (this.isRetryHandleNeeded.get(arg0.getName()).booleanValue()) {
            this.removeIncorrectlySkippedTests(arg0, this.failedTests.get(arg0.getName()));
            this.removeFailedTestsInTestNG(arg0);
        } else {
            this.failedTests.put(arg0.getName(), arg0.getFailedTests());
            this.skippedTests.put(arg0.getName(), arg0.getSkippedTests());
        }
    }

    public void onStart(ITestContext arg0) {
        this.isRetryHandleNeeded.put(arg0.getName(), false);
        this.failedTests.put(arg0.getName(), (IResultMap)new ResultMap());
        this.skippedTests.put(arg0.getName(), (IResultMap)new ResultMap());
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public synchronized void onTestFailure(ITestResult arg0) {
        if (arg0.getMethod().getRetryAnalyzer() != null) {
            TestRetryAnalyzer testRetryAnalyzer = (TestRetryAnalyzer)arg0.getMethod().getRetryAnalyzer();
            if (1 <= testRetryAnalyzer.getCount()) {
                arg0.setStatus(3);
                Reporter.setCurrentTestResult(null);
            } else {
                IResultMap rMap = this.failedTests.get(arg0.getTestContext().getName());
                rMap.addResult(arg0, arg0.getMethod());
                this.failedTests.put(arg0.getTestContext().getName(), rMap);
            }
            System.out.println(arg0.getMethod() + " Failed in " + 3 + " times");
            this.isRetryHandleNeeded.put(arg0.getTestContext().getName(), true);
        }
        if (WebUIDriver.getWebDriver() != null) {
            ScreenShot screenShot = new ScreenshotUtil().captureWebPageSnapshot();
            TestLogging.logWebOutput(screenShot.getTitle(), TestLogging.buildScreenshotLog(screenShot), true);
        }
    }

    public void onTestSkipped(ITestResult arg0) {
    }

    public void onTestStart(ITestResult arg0) {
    }

    public void onTestSuccess(ITestResult arg0) {
    }

    private void removeFailedTestsInTestNG(ITestContext tc) {
        IResultMap returnValue = tc.getFailedTests();
        ResultMap removeMap = new ResultMap();
        for (ITestResult result : returnValue.getAllResults()) {
            boolean isFailed = false;
            for (ITestResult resultToCheck : this.failedTests.get(tc.getName()).getAllResults()) {
                if (!result.getMethod().equals(resultToCheck.getMethod()) || result.getEndMillis() != resultToCheck.getEndMillis()) continue;
                isFailed = true;
                break;
            }
            if (isFailed) continue;
            System.out.println("Removed failed cases:" + result.getMethod().getMethodName());
            removeMap.addResult(result, result.getMethod());
        }
        for (ITestResult result : removeMap.getAllResults()) {
            ITestResult removeResult = null;
            for (ITestResult resultToCheck : returnValue.getAllResults()) {
                if (!result.getMethod().equals(resultToCheck.getMethod()) || result.getEndMillis() != resultToCheck.getEndMillis()) continue;
                removeResult = resultToCheck;
                break;
            }
            if (removeResult == null) continue;
            returnValue.getAllResults().remove(removeResult);
        }
    }

    private void removeIncorrectlySkippedTests(ITestContext tc, IResultMap map) {
        ArrayList<ITestNGMethod> failsToRemove = new ArrayList<ITestNGMethod>();
        IResultMap returnValue = tc.getSkippedTests();
        block0: for (ITestResult result : returnValue.getAllResults()) {
            for (ITestResult resultToCheck : map.getAllResults()) {
                if (!resultToCheck.getMethod().equals(result.getMethod())) continue;
                failsToRemove.add(resultToCheck.getMethod());
                break;
            }
            for (ITestResult resultToCheck : tc.getPassedTests().getAllResults()) {
                if (!resultToCheck.getMethod().equals(result.getMethod())) continue;
                failsToRemove.add(resultToCheck.getMethod());
                continue block0;
            }
        }
        for (ITestNGMethod method : failsToRemove) {
            returnValue.removeResult(method);
        }
        this.skippedTests.put(tc.getName(), tc.getSkippedTests());
    }

    public void setOutputDirectory(String outtimestamped) {
        this.outputDirectory = outtimestamped;
    }

    public void setReportId(String uuid) {
        this.uuid = uuid;
    }

    public void setResources(String resources) {
        this.resources = resources;
    }

    protected void startHtml(ITestContext ctx, PrintWriter out) {
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"class");
            ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.init();
            Template t = ve.getTemplate("/templates/report.part.header.html");
            VelocityContext context = new VelocityContext();
            String userName = System.getProperty("user.name");
            context.put("userName", (Object)userName);
            context.put("currentDate", (Object)new Date().toString());
            String mode = SeleniumTestsContextManager.getGlobalContext().getWebRunMode();
            String hubUrl = SeleniumTestsContextManager.getGlobalContext().getWebDriverGrid();
            context.put("gridHub", (Object)("<a href='" + hubUrl + "' target=hub>" + hubUrl + "</a>"));
            context.put("mode", (Object)mode);
            StringBuilder sbGroups = new StringBuilder();
            sbGroups.append("envt,test");
            List<SeleniumTestsPageListener> pageListenerList = PluginsHelper.getInstance().getPageListeners();
            if (pageListenerList != null && !pageListenerList.isEmpty()) {
                for (SeleniumTestsPageListener abstractPageListener : pageListenerList) {
                    sbGroups.append(",").append(abstractPageListener.getClass().getSimpleName());
                }
            }
            context.put("groups", (Object)sbGroups.toString());
            StringWriter writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
            out.write(writer.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    protected void takeCareOfDirectDependencies(ISuite suite, ITestNGMethod method, int indent, ITestContext ctx, String treeId, StringBuffer res) {
        int i;
        String[] methStr;
        if (indent == 0) {
            res.append("<a href=\"#\" onclick=\"expandTree('" + treeId + "'); return false;\">Expand All</a>&nbsp;");
            res.append("<a href=\"#\" onclick=\"collapseTree('" + treeId + "'); return false;\">Collapse All</a>");
            res.append("<ul class=\"mktree\" id=\"" + treeId + "\">");
        }
        if ((methStr = method.getMethodsDependedUpon()).length != 0) {
            for (i = 0; i < methStr.length; ++i) {
                ITestNGMethod m = this.getTestNGMethod(ctx, methStr[i]);
                String intendstr = "";
                for (int j = 0; j < indent; ++j) {
                    intendstr = intendstr + "\t";
                }
                String img = "<img src=\"";
                String m_root = "resources/images/mktree/";
                img = img + "resources/images/mktree//test" + this.getFailedOrSkippedResult(ctx, m).getStatus() + ".gif";
                img = img + "\"/>";
                res.append(intendstr + "<li>" + img + m);
                if (this.hasDependencies(m)) {
                    res.append(intendstr + "<ul>");
                    this.takeCareOfDirectDependencies(suite, m, indent + 1, ctx, treeId, res);
                    res.append(intendstr + "</ul>");
                }
                res.append("</li>");
            }
        }
        for (i = 0; i < method.getGroupsDependedUpon().length; ++i) {
            if (this.methodsByGroup == null) {
                this.methodsByGroup = this.initMethodsByGroup();
            }
            String dependentGroup = method.getGroupsDependedUpon()[i];
            LinkedHashSet methods = new LinkedHashSet();
            Collection c = (Collection)suite.getMethodsByGroups().get(dependentGroup);
            if (c != null) {
                methods.addAll(c);
            }
            res.append("<li><u>Group " + dependentGroup + "</u>");
            res.append("<ul>");
            for (ITestNGMethod m : methods) {
                String intendstr = "";
                for (int j = 0; j < indent; ++j) {
                    intendstr = intendstr + "\t";
                }
                String img = "<img src=\"";
                String m_root = "resources/images/mktree/";
                img = img + "resources/images/mktree//test" + this.getFailedOrSkippedResult(ctx, m).getStatus() + ".gif";
                img = img + "\"/>";
                res.append(intendstr + "<li>" + img + m);
                if (this.hasDependencies(m)) {
                    res.append(intendstr + "<ul>");
                    this.takeCareOfDirectDependencies(suite, m, indent + 1, ctx, treeId, res);
                    res.append(intendstr + "</ul>");
                }
                res.append("</li>");
            }
            res.append("</ul>");
            res.append("</li>");
        }
        if (indent == 0) {
            res.append("</ul>");
        }
    }

    protected class TestResultSorter<T extends ITestResult>
    implements Comparator<T> {
        protected TestResultSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            String sig1 = StringUtility.constructMethodSignature(o1.getMethod().getMethod(), o1.getParameters());
            String sig2 = StringUtility.constructMethodSignature(o2.getMethod().getMethod(), o2.getParameters());
            return sig1.compareTo(sig2);
        }
    }

    protected class TestMethodSorter<T extends ITestNGMethod>
    implements Comparator<T> {
        protected TestMethodSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            int r = o1.getTestClass().getName().compareTo(o2.getTestClass().getName());
            if (r == 0) {
                r = o1.getMethodName().compareTo(o2.getMethodName());
            }
            return r;
        }
    }
}

