/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sendgrid.ASM;
import com.sendgrid.Attachments;
import com.sendgrid.Content;
import com.sendgrid.Email;
import com.sendgrid.MailSettings;
import com.sendgrid.Personalization;
import com.sendgrid.TrackingSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Mail {
    @JsonProperty(value="from")
    public Email from;
    @JsonProperty(value="subject")
    public String subject;
    @JsonProperty(value="personalizations")
    public List<Personalization> personalization;
    @JsonProperty(value="content")
    public List<Content> content;
    @JsonProperty(value="attachments")
    public List<Attachments> attachments;
    @JsonProperty(value="template_id")
    public String templateId;
    @JsonProperty(value="sections")
    public Map<String, String> sections;
    @JsonProperty(value="headers")
    public Map<String, String> headers;
    @JsonProperty(value="categories")
    public List<String> categories;
    @JsonProperty(value="custom_args")
    public Map<String, String> customArgs;
    @JsonProperty(value="send_at")
    public long sendAt;
    @JsonProperty(value="batch_id")
    public String batchId;
    @JsonProperty(value="asm")
    public ASM asm;
    @JsonProperty(value="ip_pool_name")
    public String ipPoolId;
    @JsonProperty(value="mail_settings")
    public MailSettings mailSettings;
    @JsonProperty(value="tracking_settings")
    public TrackingSettings trackingSettings;
    @JsonProperty(value="reply_to")
    public Email replyTo;
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapper();

    private <T> List<T> addToList(T element, List<T> defaultList) {
        if (defaultList != null) {
            defaultList.add(element);
            return defaultList;
        }
        ArrayList<T> list = new ArrayList<T>();
        list.add(element);
        return list;
    }

    private <K, V> Map<K, V> addToMap(K key, V value, Map<K, V> defaultMap) {
        if (defaultMap != null) {
            defaultMap.put(key, value);
            return defaultMap;
        }
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public Mail() {
    }

    public Mail(Email from, String subject, Email to, Content content) {
        this.setFrom(from);
        this.setSubject(subject);
        Personalization personalization = new Personalization();
        personalization.addTo(to);
        this.addPersonalization(personalization);
        this.addContent(content);
    }

    @JsonProperty(value="from")
    public Email getFrom() {
        return this.from;
    }

    public void setFrom(Email from) {
        this.from = from;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="asm")
    public ASM getASM() {
        return this.asm;
    }

    public void setASM(ASM asm) {
        this.asm = asm;
    }

    @JsonProperty(value="personalizations")
    public List<Personalization> getPersonalization() {
        return this.personalization;
    }

    public void addPersonalization(Personalization personalization) {
        this.personalization = this.addToList(personalization, this.personalization);
    }

    @JsonProperty(value="content")
    public List<Content> getContent() {
        return this.content;
    }

    public void addContent(Content content) {
        Content newContent = new Content();
        newContent.setType(content.getType());
        newContent.setValue(content.getValue());
        this.content = this.addToList(newContent, this.content);
    }

    @JsonProperty(value="attachments")
    public List<Attachments> getAttachments() {
        return this.attachments;
    }

    public void addAttachments(Attachments attachments) {
        Attachments newAttachment = new Attachments();
        newAttachment.setContent(attachments.getContent());
        newAttachment.setType(attachments.getType());
        newAttachment.setFilename(attachments.getFilename());
        newAttachment.setDisposition(attachments.getDisposition());
        newAttachment.setContentId(attachments.getContentId());
        this.attachments = this.addToList(newAttachment, this.attachments);
    }

    @JsonProperty(value="template_id")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @JsonProperty(value="sections")
    public Map<String, String> getSections() {
        return this.sections;
    }

    public void addSection(String key, String value) {
        this.sections = this.addToMap(key, value, this.sections);
    }

    @JsonProperty(value="headers")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String key, String value) {
        this.headers = this.addToMap(key, value, this.headers);
    }

    @JsonProperty(value="categories")
    public List<String> getCategories() {
        return this.categories;
    }

    public void addCategory(String category) {
        this.categories = this.addToList(category, this.categories);
    }

    @JsonProperty(value="custom_args")
    public Map<String, String> getCustomArgs() {
        return this.customArgs;
    }

    public void addCustomArg(String key, String value) {
        this.customArgs = this.addToMap(key, value, this.customArgs);
    }

    @JsonProperty(value="send_at")
    public long sendAt() {
        return this.sendAt;
    }

    public void setSendAt(long sendAt) {
        this.sendAt = sendAt;
    }

    @JsonProperty(value="batch_id")
    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @JsonProperty(value="ip_pool_name")
    public String getIpPoolId() {
        return this.ipPoolId;
    }

    public void setIpPoolId(String ipPoolId) {
        this.ipPoolId = ipPoolId;
    }

    @JsonProperty(value="mail_settings")
    public MailSettings getMailSettings() {
        return this.mailSettings;
    }

    public void setMailSettings(MailSettings mailSettings) {
        this.mailSettings = mailSettings;
    }

    @JsonProperty(value="tracking_settings")
    public TrackingSettings getTrackingSettings() {
        return this.trackingSettings;
    }

    public void setTrackingSettings(TrackingSettings trackingSettings) {
        this.trackingSettings = trackingSettings;
    }

    @JsonProperty(value="reply_to")
    public Email getReplyto() {
        return this.replyTo;
    }

    public void setReplyTo(Email replyTo) {
        this.replyTo = replyTo;
    }

    public String build() throws IOException {
        return SORTED_MAPPER.writeValueAsString(this);
    }

    public String buildPretty() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.batchId == null ? 0 : this.batchId.hashCode());
        result = 31 * result + (this.categories == null ? 0 : this.categories.hashCode());
        result = 31 * result + (this.customArgs == null ? 0 : this.customArgs.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.ipPoolId == null ? 0 : this.ipPoolId.hashCode());
        result = 31 * result + (this.sections == null ? 0 : this.sections.hashCode());
        result = 31 * result + (int)(this.sendAt ^ this.sendAt >>> 32);
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.templateId == null ? 0 : this.templateId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mail other = (Mail)obj;
        if (this.batchId == null ? other.batchId != null : !this.batchId.equals(other.batchId)) {
            return false;
        }
        if (this.categories == null ? other.categories != null : !this.categories.equals(other.categories)) {
            return false;
        }
        if (this.customArgs == null ? other.customArgs != null : !this.customArgs.equals(other.customArgs)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.ipPoolId == null ? other.ipPoolId != null : !this.ipPoolId.equals(other.ipPoolId)) {
            return false;
        }
        if (this.sections == null ? other.sections != null : !this.sections.equals(other.sections)) {
            return false;
        }
        if (this.sendAt != other.sendAt) {
            return false;
        }
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        return !(this.templateId == null ? other.templateId != null : !this.templateId.equals(other.templateId));
    }

    static {
        SORTED_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }
}

