/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.process;

import com.simtechdata.process.EventSink;
import com.simtechdata.process.ExecutionEvent;
import com.simtechdata.process.OutputConsumptionThread;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class ByteArrayConsumptionThread
implements OutputConsumptionThread {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private Thread thread;
    private Throwable throwable;
    private byte[] bytes;
    private final EventSink eventSink;

    ByteArrayConsumptionThread(EventSink eventSink) {
        this.eventSink = eventSink;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void startConsumption(InputStream inputStream) {
        this.thread = new Thread(() -> {
            block2: {
                try {
                    this.bytes = ByteArrayConsumptionThread.toByteArray(inputStream);
                }
                catch (Throwable t) {
                    if (this.thread.isInterrupted()) break block2;
                    this.throwable = t;
                    this.eventSink.dispatch(ExecutionEvent.EXCEPTION_IN_STREAM_HANDLING);
                }
            }
        });
        this.thread.start();
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (-1 != (n = inputStream.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    @Override
    public void join() throws InterruptedException {
        this.thread.join();
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

