/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.process;

import com.simtechdata.process.EventSink;
import com.simtechdata.process.ExecutionEvent;
import com.simtechdata.process.OutputConsumptionThread;
import com.simtechdata.process.StreamConsumer;
import java.io.InputStream;

class StreamConsumerConsumptionThread
implements OutputConsumptionThread {
    private final EventSink eventSink;
    private final StreamConsumer stdout;
    private Thread thread;
    private Throwable throwable;

    public StreamConsumerConsumptionThread(EventSink eventSink, StreamConsumer stdout) {
        this.eventSink = eventSink;
        this.stdout = stdout;
    }

    @Override
    public void startConsumption(InputStream inputStream) {
        this.thread = new Thread(() -> {
            block2: {
                try {
                    this.stdout.consume(inputStream);
                }
                catch (Throwable t) {
                    if (this.thread.isInterrupted()) break block2;
                    this.throwable = t;
                    this.eventSink.dispatch(ExecutionEvent.EXCEPTION_IN_STREAM_HANDLING);
                }
            }
        });
        this.thread.start();
    }

    @Override
    public void join() throws InterruptedException {
        this.thread.join();
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

