/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Token
implements Serializable {
    private static final long serialVersionUID = 766168501082045382L;
    public static final String ACCESS_TOKEN = "access_token";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String SCOPE = "scope";
    public static final String EXPIRES_IN = "expires_in";
    public static final String SCOPE_DEFAULT = "*";
    public static final String SCOPE_SIGNUP = "signup";
    public static final String SCOPE_PLAYCOUNT = "playcount";
    public static final String SCOPE_NON_EXPIRING = "non-expiring";
    public String access;
    public String refresh;
    public String scope;
    public long expiresIn;
    public final Map<String, String> customParameters = new HashMap<String, String>();

    public Token(String access, String refresh) {
        this(access, refresh, null);
    }

    public Token(String access, String refresh, String scope) {
        this.access = access;
        this.refresh = refresh;
        this.scope = scope;
    }

    public Token(JSONObject json) throws IOException {
        try {
            Iterator it = json.keys();
            while (it.hasNext()) {
                String key = it.next().toString();
                if (ACCESS_TOKEN.equals(key)) {
                    this.access = json.getString(ACCESS_TOKEN);
                    continue;
                }
                if (REFRESH_TOKEN.equals(key)) {
                    this.refresh = json.getString(REFRESH_TOKEN);
                    this.expiresIn = System.currentTimeMillis() + json.getLong(EXPIRES_IN) * 1000L;
                    continue;
                }
                if (SCOPE.equals(key)) {
                    this.scope = json.getString(SCOPE);
                    continue;
                }
                this.customParameters.put(key, json.getString(key));
            }
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void invalidate() {
        this.access = null;
    }

    public Date getExpiresIn() {
        return this.expiresIn == 0L ? null : new Date(this.expiresIn);
    }

    public boolean defaultScoped() {
        return this.scoped(SCOPE_DEFAULT);
    }

    public boolean signupScoped() {
        return this.scoped(SCOPE_SIGNUP);
    }

    public boolean scoped(String scope) {
        if (this.scope != null) {
            for (String s : this.scope.split(" ")) {
                if (!scope.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean valid() {
        return this.access != null && (this.scoped(SCOPE_NON_EXPIRING) || this.refresh != null);
    }

    public String getSignup() {
        return this.customParameters.get("soundcloud:user:sign-up");
    }

    public String toString() {
        return "Token{access='" + this.access + '\'' + ", refresh='" + this.refresh + '\'' + ", scope='" + this.scope + '\'' + ", expires=" + this.getExpiresIn() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Token) {
            Token token = (Token)o;
            if (this.access != null ? !this.access.equals(token.access) : token.access != null) {
                return false;
            }
            if (this.refresh != null ? !this.refresh.equals(token.refresh) : token.refresh != null) {
                return false;
            }
            return !(this.scope != null ? !this.scope.equals(token.scope) : token.scope != null);
        }
        return super.equals(o);
    }

    public int hashCode() {
        int result = this.access != null ? this.access.hashCode() : 0;
        result = 31 * result + (this.refresh != null ? this.refresh.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }
}

