/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Env {
    LIVE("api.soundcloud.com", "soundcloud.com"),
    SANDBOX("api.sandbox-soundcloud.com", "sandbox-soundcloud.com");

    public final HttpHost resourceHost;
    public final HttpHost sslResourceHost;
    public final HttpHost authResourceHost;
    public final HttpHost sslAuthResourceHost;

    private Env(String resourceHost, String authResourceHost) {
        this.resourceHost = new HttpHost(resourceHost, 80, "http");
        this.sslResourceHost = new HttpHost(resourceHost, 443, "https");
        this.authResourceHost = new HttpHost(authResourceHost, 80, "http");
        this.sslAuthResourceHost = new HttpHost(authResourceHost, 443, "https");
    }

    public HttpHost getResourceHost(boolean secure) {
        return secure ? this.sslResourceHost : this.resourceHost;
    }

    public HttpHost getAuthResourceHost(boolean secure) {
        return secure ? this.sslAuthResourceHost : this.authResourceHost;
    }

    public URI getResourceURI(boolean secure) {
        return Env.hostToUri(this.getResourceHost(secure));
    }

    public URI getAuthResourceURI(boolean secure) {
        return Env.hostToUri(this.getAuthResourceHost(secure));
    }

    public boolean isApiHost(HttpHost host) {
        return ("http".equals(host.getSchemeName()) || "https".equals(host.getSchemeName())) && this.resourceHost.getHostName().equals(host.getHostName());
    }

    private static URI hostToUri(HttpHost host) {
        try {
            return new URI(host.getSchemeName(), host.getHostName(), null, null);
        }
        catch (URISyntaxException ignored) {
            throw new RuntimeException();
        }
    }
}

