/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Http {
    private Http() {
    }

    public static String getString(HttpResponse response) throws IOException {
        int n;
        InputStream is = response.getEntity().getContent();
        if (is == null) {
            return null;
        }
        int length = 8192;
        Header contentLength = null;
        try {
            contentLength = response.getFirstHeader("Content-Length");
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        if (contentLength != null) {
            try {
                length = Integer.parseInt(contentLength.getValue());
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder(length);
        byte[] buffer = new byte[8192];
        while ((n = is.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, n));
        }
        return sb.toString();
    }

    public static JSONObject getJSON(HttpResponse response) throws IOException {
        String json = Http.getString(response);
        if (json == null || json.length() == 0) {
            throw new IOException("JSON response is empty");
        }
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            throw new IOException("could not parse JSON document: " + e.getMessage() + " " + (json.length() > 80 ? json.substring(0, 79) + "..." : json));
        }
    }

    public static String etag(HttpResponse resp) {
        Header etag = resp.getFirstHeader("Etag");
        return etag != null ? etag.getValue() : null;
    }

    public static String formatJSON(String s) {
        try {
            return new JSONObject(s).toString(4);
        }
        catch (JSONException e) {
            try {
                return new JSONArray(s).toString(4);
            }
            catch (JSONException e2) {
                return s;
            }
        }
    }
}

