/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.ApiWrapper;
import com.soundcloud.api.CountingMultipartEntity;
import com.soundcloud.api.Token;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
implements Iterable<NameValuePair> {
    public static final String UTF_8 = "UTF-8";
    private List<NameValuePair> mParams = new ArrayList<NameValuePair>();
    private Map<String, Attachment> mFiles;
    private HttpEntity mEntity;
    private Token mToken;
    private String mResource;
    private TransferProgressListener listener;
    private String mIfNoneMatch;
    private long[] mRange;

    public Request() {
    }

    public Request(String resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (!(resource.startsWith("http:") || resource.startsWith("https:") || resource.startsWith("/"))) {
            resource = "/" + resource;
        }
        if (resource.contains("?")) {
            String query = resource.substring(Math.min(resource.length(), resource.indexOf("?") + 1), resource.length());
            for (String s : query.split("&")) {
                String[] kv = s.split("=", 2);
                if (kv == null) continue;
                try {
                    if (kv.length == 2) {
                        this.mParams.add((NameValuePair)new BasicNameValuePair(URLDecoder.decode(kv[0], UTF_8), URLDecoder.decode(kv[1], UTF_8)));
                        continue;
                    }
                    if (kv.length != 1) continue;
                    this.mParams.add((NameValuePair)new BasicNameValuePair(URLDecoder.decode(kv[0], UTF_8), null));
                }
                catch (UnsupportedEncodingException ignored) {
                    // empty catch block
                }
            }
            this.mResource = resource.substring(0, resource.indexOf("?"));
        } else {
            this.mResource = resource;
        }
    }

    public Request(URI uri) {
        this(uri.getPath() == null ? "/" : uri.getPath() + (uri.getQuery() == null ? "" : "?" + uri.getQuery()));
    }

    public Request(Request request) {
        this.mResource = request.mResource;
        this.mToken = request.mToken;
        this.listener = request.listener;
        this.mParams = new ArrayList<NameValuePair>(request.mParams);
        this.mIfNoneMatch = request.mIfNoneMatch;
        this.mEntity = request.mEntity;
        if (request.mFiles != null) {
            this.mFiles = new HashMap<String, Attachment>(request.mFiles);
        }
    }

    public static Request to(String resource, Object ... args) {
        if (args != null && args.length > 0) {
            resource = String.format(Locale.ENGLISH, resource, args);
        }
        return new Request(resource);
    }

    public Request add(String name, Object value) {
        this.mParams.add((NameValuePair)new BasicNameValuePair(name, String.valueOf(value)));
        return this;
    }

    public Request set(String name, Object value) {
        return this.clear(name).add(name, value);
    }

    public Request clear(String name) {
        Iterator<NameValuePair> it = this.mParams.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(name)) continue;
            it.remove();
        }
        return this;
    }

    public Request with(Object ... args) {
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("need even number of arguments");
            }
            for (int i = 0; i < args.length; i += 2) {
                this.add(args[i].toString(), args[i + 1]);
            }
        }
        return this;
    }

    public Request newResource(String resource) {
        Request newRequest = new Request(this);
        newRequest.mResource = resource;
        return newRequest;
    }

    public Request usingToken(Token token) {
        this.mToken = token;
        return this;
    }

    public int size() {
        return this.mParams.size();
    }

    public String queryString() {
        return Request.format(this.mParams, UTF_8);
    }

    public String toUrl(String resource) {
        return this.mParams.isEmpty() ? resource : resource + "?" + this.queryString();
    }

    public String toUrl() {
        return this.toUrl(this.mResource);
    }

    public Request withFile(String name, File file) {
        return file != null ? this.withFile(name, file, file.getName()) : this;
    }

    public Request withFile(String name, File file, String fileName) {
        if (this.mFiles == null) {
            this.mFiles = new HashMap<String, Attachment>();
        }
        if (file != null) {
            this.mFiles.put(name, new Attachment(file, fileName));
        }
        return this;
    }

    @Deprecated
    public Request withFile(String name, byte[] data) {
        return this.withFile(name, ByteBuffer.wrap(data));
    }

    public Request withFile(String name, byte[] data, String fileName) {
        return this.withFile(name, ByteBuffer.wrap(data), fileName);
    }

    @Deprecated
    public Request withFile(String name, ByteBuffer data) {
        return this.withFile(name, data, "upload");
    }

    public Request withFile(String name, ByteBuffer data, String fileName) {
        if (this.mFiles == null) {
            this.mFiles = new HashMap<String, Attachment>();
        }
        if (data != null) {
            this.mFiles.put(name, new Attachment(data, fileName));
        }
        return this;
    }

    public Request withEntity(HttpEntity entity) {
        this.mEntity = entity;
        return this;
    }

    public Request withContent(String content, String contentType) {
        try {
            StringEntity stringEntity = new StringEntity(content, UTF_8);
            if (contentType != null) {
                stringEntity.setContentType(contentType);
            }
            return this.withEntity((HttpEntity)stringEntity);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Request range(long ... ranges) {
        this.mRange = ranges;
        return this;
    }

    public Request setProgressListener(TransferProgressListener listener) {
        this.listener = listener;
        return this;
    }

    public boolean isMultipart() {
        return this.mFiles != null && !this.mFiles.isEmpty();
    }

    public Request ifNoneMatch(String etag) {
        this.mIfNoneMatch = etag;
        return this;
    }

    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        for (NameValuePair p : this.mParams) {
            params.put(p.getName(), p.getValue());
        }
        return params;
    }

    public <T extends HttpRequestBase> T buildRequest(Class<T> method) {
        try {
            HttpRequestBase request = (HttpRequestBase)method.newInstance();
            if (request instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase enclosingRequest = (HttpEntityEnclosingRequestBase)request;
                Charset charSet = Charset.forName(UTF_8);
                if (this.isMultipart()) {
                    MultipartEntity multiPart = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, charSet);
                    if (this.mFiles != null) {
                        for (Map.Entry entry : this.mFiles.entrySet()) {
                            multiPart.addPart((String)entry.getKey(), ((Attachment)entry.getValue()).toContentBody());
                        }
                    }
                    for (NameValuePair nameValuePair : this.mParams) {
                        multiPart.addPart(nameValuePair.getName(), (ContentBody)new StringBody(nameValuePair.getValue(), "text/plain", charSet));
                    }
                    enclosingRequest.setEntity((HttpEntity)(this.listener == null ? multiPart : new CountingMultipartEntity((HttpEntity)multiPart, this.listener)));
                    request.setURI(URI.create(this.mResource));
                } else if (this.mEntity != null) {
                    request.setHeader(this.mEntity.getContentType());
                    enclosingRequest.setEntity(this.mEntity);
                    request.setURI(URI.create(this.toUrl()));
                } else {
                    if (!this.mParams.isEmpty()) {
                        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
                        enclosingRequest.setEntity((HttpEntity)new StringEntity(this.queryString()));
                    }
                    request.setURI(URI.create(this.mResource));
                }
            } else {
                if (this.mRange != null) {
                    request.addHeader("Range", Request.formatRange(this.mRange));
                }
                if (this.mIfNoneMatch != null) {
                    request.addHeader("If-None-Match", this.mIfNoneMatch);
                }
                request.setURI(URI.create(this.toUrl()));
            }
            if (this.mToken != null) {
                request.addHeader(ApiWrapper.createOAuthHeader(this.mToken));
            }
            return (T)request;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatRange(long ... range) {
        switch (range.length) {
            case 0: {
                return "bytes=0-";
            }
            case 1: {
                if (range[0] < 0L) {
                    throw new IllegalArgumentException("negative range");
                }
                return "bytes=" + range[0] + "-";
            }
            case 2: {
                if (range[0] < 0L) {
                    throw new IllegalArgumentException("negative range");
                }
                if (range[0] > range[1]) {
                    throw new IllegalArgumentException(range[0] + ">" + range[1]);
                }
                return "bytes=" + range[0] + "-" + range[1];
            }
        }
        throw new IllegalArgumentException("invalid range specified");
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.mParams.iterator();
    }

    public String toString() {
        return "Request{mResource='" + this.mResource + '\'' + ", params=" + this.mParams + ", files=" + this.mFiles + ", entity=" + this.mEntity + ", mToken=" + this.mToken + ", listener=" + this.listener + '}';
    }

    Token getToken() {
        return this.mToken;
    }

    TransferProgressListener getListener() {
        return this.listener;
    }

    public static String format(List<? extends NameValuePair> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedValue;
            String encodedName = Request.encode(nameValuePair.getName(), encoding);
            String value = nameValuePair.getValue();
            String string = encodedValue = value != null ? Request.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            if (value == null) continue;
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    static class Attachment {
        public final File file;
        public final ByteBuffer data;
        public final String fileName;

        Attachment(File file) {
            this(file, file.getName());
        }

        Attachment(File file, String fileName) {
            if (file == null) {
                throw new IllegalArgumentException("file cannot be null");
            }
            this.fileName = fileName;
            this.file = file;
            this.data = null;
        }

        Attachment(ByteBuffer data) {
            this(data, null);
        }

        Attachment(ByteBuffer data, String fileName) {
            if (data == null) {
                throw new IllegalArgumentException("data cannot be null");
            }
            this.data = data;
            this.fileName = fileName;
            this.file = null;
        }

        public ContentBody toContentBody() {
            if (this.file != null) {
                return new FileBody(this.file){

                    public String getFilename() {
                        return Attachment.this.fileName;
                    }
                };
            }
            if (this.data != null) {
                return new ByteBufferBody(this.data){

                    public String getFilename() {
                        return Attachment.this.fileName;
                    }
                };
            }
            throw new IllegalStateException("no upload data");
        }
    }

    static class ByteBufferBody
    extends AbstractContentBody {
        private ByteBuffer mBuffer;

        public ByteBufferBody(ByteBuffer buffer) {
            super("application/octet-stream");
            this.mBuffer = buffer;
        }

        public String getFilename() {
            return null;
        }

        public String getTransferEncoding() {
            return "binary";
        }

        public String getCharset() {
            return null;
        }

        public long getContentLength() {
            return this.mBuffer.capacity();
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.mBuffer.hasArray()) {
                out.write(this.mBuffer.array());
            } else {
                byte[] dst = new byte[this.mBuffer.capacity()];
                this.mBuffer.get(dst);
                out.write(dst);
            }
        }
    }

    public static interface TransferProgressListener {
        public void transferred(long var1) throws IOException;
    }
}

