/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.protocol.HttpContext;

class OAuth2HttpRequestInterceptor
implements HttpRequestInterceptor {
    OAuth2HttpRequestInterceptor() {
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme;
        AuthState authState;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        if (!request.getRequestLine().getMethod().equalsIgnoreCase("CONNECT") && (authState = (AuthState)context.getAttribute("http.auth.target-scope")) != null && (authScheme = authState.getAuthScheme()) != null && !authScheme.isConnectionBased()) {
            try {
                request.setHeader(authScheme.authenticate(null, request));
            }
            catch (AuthenticationException ignored) {
                // empty catch block
            }
        }
    }
}

