/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.ApiWrapper;
import com.soundcloud.api.CloudAPI;
import com.soundcloud.api.Token;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

class OAuth2Scheme
implements AuthScheme {
    public HashMap<String, String> mParams;
    public HttpParams mHttpParams;
    private CloudAPI mApi;
    public static Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("^OAuth (\\w+)$");

    public OAuth2Scheme(CloudAPI api, HttpParams params) {
        this.mApi = api;
        this.mHttpParams = params;
        this.mParams = new HashMap();
    }

    public String getSchemeName() {
        return "oauth";
    }

    public String getParameter(String name) {
        return this.mParams.get(name);
    }

    public String getRealm() {
        return this.getParameter("realm");
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        String usedToken = OAuth2Scheme.extractToken(request);
        Class<OAuth2Scheme> clazz = OAuth2Scheme.class;
        synchronized (OAuth2Scheme.class) {
            Token apiToken = this.mApi.getToken();
            if ((apiToken == null || apiToken.access == null || apiToken.access.equals(usedToken)) && this.mApi.invalidateToken() == null) {
                try {
                    this.mApi.refreshToken();
                }
                catch (IOException e) {
                    throw new AuthenticationException("Error refreshing token", (Throwable)e);
                }
                catch (IllegalStateException e) {
                    throw new AuthenticationException("Error refreshing token", (Throwable)e);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ApiWrapper.createOAuthHeader(this.mApi.getToken());
        }
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        int pos;
        CharArrayBuffer buffer;
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        String authHeader = header.getName();
        if (!authHeader.equalsIgnoreCase("WWW-Authenticate")) {
            throw new MalformedChallengeException("Unexpected header name: " + authHeader);
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            pos = ((FormattedHeader)header).getValuePos();
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            pos = 0;
        }
        while (pos < buffer.length() && HTTP.isWhitespace((char)buffer.charAt(pos))) {
            ++pos;
        }
        int beginIndex = pos;
        while (pos < buffer.length() && !HTTP.isWhitespace((char)buffer.charAt(pos))) {
            ++pos;
        }
        int endIndex = pos;
        String s = buffer.substring(beginIndex, endIndex);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + s);
        }
        BasicHeaderValueParser parser = BasicHeaderValueParser.DEFAULT;
        ParserCursor cursor = new ParserCursor(pos, buffer.length());
        HeaderElement[] elements = parser.parseElements(buffer, cursor);
        if (elements.length == 0) {
            throw new MalformedChallengeException("Authentication challenge is empty");
        }
        for (HeaderElement element : elements) {
            this.mParams.put(element.getName(), element.getValue());
        }
    }

    static String extractToken(HttpRequest r) {
        return r == null ? null : OAuth2Scheme.extractToken(r.getFirstHeader("Authorization"));
    }

    static String extractToken(Header h) {
        if (h == null || h.getValue() == null) {
            return null;
        }
        if ("Authorization".equalsIgnoreCase(h.getName())) {
            Matcher m = AUTHORIZATION_HEADER_PATTERN.matcher(h.getValue());
            return m.matches() ? m.group(1) : null;
        }
        return null;
    }

    static class EmptyCredentials
    implements Credentials {
        public static final Credentials INSTANCE = new EmptyCredentials();

        EmptyCredentials() {
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getPassword() {
            return null;
        }
    }

    static class Factory
    implements AuthSchemeFactory {
        private CloudAPI api;

        public Factory(CloudAPI api) {
            this.api = api;
        }

        public AuthScheme newInstance(HttpParams params) {
            return new OAuth2Scheme(this.api, params);
        }
    }
}

