/*
 * Decompiled with CFR 0.152.
 */
package com.sovren.models.job;

import com.google.gson.JsonParseException;
import com.sovren.models.Location;
import com.sovren.models.ParsedDocument;
import com.sovren.models.SovrenPrimitive;
import com.sovren.models.job.EmployerNames;
import com.sovren.models.job.JobDegree;
import com.sovren.models.job.JobMetadata;
import com.sovren.models.job.JobTitles;
import com.sovren.models.job.skills.JobTaxonomyRoot;
import com.sovren.utilities.SovrenJsonSerializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.List;

public class ParsedJob
extends ParsedDocument {
    public boolean CurrentJobIsManagement;
    public SovrenPrimitive<Integer> HighestManagementScore;
    public String ManagementLevel;
    public String ExecutiveType;
    public SovrenPrimitive<Integer> MinimumYears;
    public SovrenPrimitive<Integer> MaximumYears;
    public SovrenPrimitive<Integer> MinimumYearsManagement;
    public SovrenPrimitive<Integer> MaximumYearsManagement;
    public String RequiredDegree;
    public SovrenPrimitive<LocalDate> StartDate;
    public SovrenPrimitive<LocalDate> EndDate;
    public String JobDescription;
    public String JobRequirements;
    public JobTitles JobTitles;
    public EmployerNames EmployerNames;
    public List<JobDegree> Degrees;
    public List<String> SchoolNames;
    public List<String> CertificationsAndLicenses;
    public List<String> LanguageCodes;
    public Location CurrentLocation;
    public List<String> TermsOfInterest;
    public List<String> Owners;
    public List<JobTaxonomyRoot> SkillsData;
    public JobMetadata JobMetadata;
    public List<String> UserDefinedTags;

    @Deprecated
    public ParsedJob() {
    }

    public static ParsedJob fromFile(String path) throws IOException, JsonParseException {
        String fileContents = new String(Files.readAllBytes(Paths.get(path, new String[0])), Charset.forName("utf8"));
        return ParsedJob.fromJson(fileContents);
    }

    public static ParsedJob fromJson(String utf8json) throws JsonParseException {
        ParsedJob newJob = SovrenJsonSerializer.deserialize(utf8json, ParsedJob.class);
        if (newJob.JobMetadata == null) {
            throw new JsonParseException("The provided JSON is not a valid ParsedJob created by the Sovren Job Parser");
        }
        return newJob;
    }
}

