/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.error;

import com.stackify.api.StackifyError;
import com.stackify.api.common.error.ErrorCounter;

public class ErrorGovernor {
    private static final int MAX_DUP_ERROR_PER_MINUTE = 100;
    private static final int CLEAN_UP_MINUTES = 15;
    private final ErrorCounter errorCounter = new ErrorCounter();
    private long nextErrorToCounterCleanUp = this.getUnixEpochMinutes() + 15L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean errorShouldBeSent(StackifyError error) {
        if (error == null) {
            throw new NullPointerException("StackifyError is null");
        }
        boolean shouldBeProcessed = false;
        long epochMinute = this.getUnixEpochMinutes();
        ErrorCounter errorCounter = this.errorCounter;
        synchronized (errorCounter) {
            int errorCount = this.errorCounter.incrementCounter(error, epochMinute);
            if (errorCount <= 100) {
                shouldBeProcessed = true;
            }
            if (this.nextErrorToCounterCleanUp < epochMinute) {
                this.errorCounter.purgeCounters(epochMinute);
                this.nextErrorToCounterCleanUp = epochMinute + 15L;
            }
        }
        return shouldBeProcessed;
    }

    private long getUnixEpochMinutes() {
        return System.currentTimeMillis() / 60000L;
    }
}

