/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.stackify.api.AppIdentity;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.util.Preconditions;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppIdentityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppIdentityService.class);
    private static long FIVE_MINUTES_MILLIS = 300000L;
    private Map<String, AppIdentityState> applicationIdentityCache = new Hashtable<String, AppIdentityState>();
    private final ApiConfiguration defaultApiConfig;
    private final ObjectMapper objectMapper;
    private final boolean deviceAppIdRequired;

    public AppIdentityService(ApiConfiguration apiConfig, ObjectMapper objectMapper) {
        Preconditions.checkNotNull(apiConfig);
        Preconditions.checkNotNull(objectMapper);
        this.defaultApiConfig = apiConfig;
        this.objectMapper = objectMapper;
        this.deviceAppIdRequired = false;
    }

    public AppIdentityService(ApiConfiguration apiConfig, ObjectMapper objectMapper, boolean deviceAppIdRequired) {
        Preconditions.checkNotNull(apiConfig);
        Preconditions.checkNotNull(objectMapper);
        this.defaultApiConfig = apiConfig;
        this.objectMapper = objectMapper;
        this.deviceAppIdRequired = deviceAppIdRequired;
    }

    private AppIdentity getAppIdentity(ApiConfiguration apiConfig) {
        String applicationName = apiConfig.getApplication();
        if (applicationName == null) {
            return null;
        }
        if (!this.applicationIdentityCache.containsKey(applicationName)) {
            this.applicationIdentityCache.put(applicationName, new AppIdentityState());
        }
        AppIdentityState state = this.applicationIdentityCache.get(applicationName);
        long now = System.currentTimeMillis();
        if (state.lastModified() + FIVE_MINUTES_MILLIS < now) {
            state.touch();
            try {
                AppIdentity identity = this.identifyApp(apiConfig);
                this.applicationIdentityCache.put(applicationName, state.updateAppIdentity(identity));
                LOGGER.debug("Application identity: {}", (Object)identity);
            }
            catch (Throwable t) {
                LOGGER.info("Unable to determine application identity", t);
            }
        }
        return this.applicationIdentityCache.get(apiConfig.getApplication()).getAppIdentity();
    }

    public AppIdentity getAppIdentity(String applicationName) {
        if (this.isCached(applicationName)) {
            return this.applicationIdentityCache.get(applicationName).getAppIdentity();
        }
        EnvironmentDetail updatedEnvDetail = this.updateEnvironmentDetail(this.defaultApiConfig.getEnvDetail(), applicationName);
        ApiConfiguration updatedApiConfig = this.defaultApiConfig.toBuilder().application(applicationName).envDetail(updatedEnvDetail).build();
        return this.getAppIdentity(updatedApiConfig);
    }

    public AppIdentity getAppIdentity() {
        if (this.isCached(this.defaultApiConfig.getApplication())) {
            return this.applicationIdentityCache.get(this.defaultApiConfig.getApplication()).getAppIdentity();
        }
        return this.getAppIdentity(this.defaultApiConfig);
    }

    private AppIdentity identifyApp(ApiConfiguration apiConfig) throws IOException, HttpException {
        byte[] jsonBytes = this.objectMapper.writer().writeValueAsBytes((Object)apiConfig.getEnvDetail());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("IdentifyApp Request: {}", (Object)new String(jsonBytes, "UTF-8"));
        }
        HttpClient httpClient = new HttpClient(apiConfig);
        String responseString = httpClient.post("/Metrics/IdentifyApp", jsonBytes);
        LOGGER.debug("IdentifyApp Response: {}", (Object)responseString);
        ObjectReader jsonReader = this.objectMapper.reader((TypeReference)new TypeReference<AppIdentity>(){});
        AppIdentity identity = (AppIdentity)jsonReader.readValue(responseString);
        if (this.deviceAppIdRequired && identity.getDeviceAppId() == null) {
            throw new NullPointerException("DeviceAppId is null");
        }
        return identity;
    }

    private boolean isCached(String applicationName) {
        Preconditions.checkNotNull(applicationName);
        return this.applicationIdentityCache.containsKey(applicationName) && this.applicationIdentityCache.get(applicationName).getAppIdentity() != null;
    }

    private EnvironmentDetail updateEnvironmentDetail(EnvironmentDetail envDetail, String newConfAppName) {
        return EnvironmentDetail.newBuilder().deviceName(envDetail.getDeviceName()).appName(envDetail.getAppName()).appLocation(envDetail.getAppLocation()).configuredAppName(newConfAppName).configuredEnvironmentName(envDetail.getConfiguredEnvironmentName()).build();
    }

    private class AppIdentityState {
        private AppIdentity mayBeAppIdentity = null;
        private long lastQueryTimeStamp = 0L;

        public final AppIdentityState updateAppIdentity(AppIdentity appIdentity) {
            this.mayBeAppIdentity = appIdentity;
            return this;
        }

        public final AppIdentity getAppIdentity() {
            return this.mayBeAppIdentity;
        }

        public final long lastModified() {
            return this.lastQueryTimeStamp;
        }

        public final void touch() {
            this.lastQueryTimeStamp = System.currentTimeMillis();
        }
    }
}

