/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertyUtil.class);

    public static Map<String, String> readAndMerge(String ... files) {
        if (files == null) {
            throw new NullPointerException("files");
        }
        HashMap<String, String> mergedMap = new HashMap<String, String>();
        for (String file : files) {
            Map<String, String> map = PropertyUtil.read(file);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (mergedMap.containsKey(entry.getKey())) continue;
                mergedMap.put(entry.getKey(), entry.getValue());
            }
        }
        return mergedMap;
    }

    public static Map<String, String> read(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (new File(file).exists()) {
            try {
                Properties p = new Properties();
                p.load(new FileInputStream(new File(file)));
                for (Object key : p.keySet()) {
                    String value = p.getProperty(String.valueOf(key));
                    if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if ((value = value.trim()).equals("")) continue;
                    map.put(String.valueOf(key), value);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }
}

