/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.stackify.api.common.concurrent.BackgroundService;
import com.stackify.api.common.log.LogBackgroundServiceScheduler;
import com.stackify.api.common.log.LogCollector;
import com.stackify.api.common.log.LogSender;
import com.stackify.api.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBackgroundService
extends BackgroundService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogBackgroundService.class);
    private final LogBackgroundServiceScheduler scheduler = new LogBackgroundServiceScheduler();
    private final LogCollector collector;
    private final LogSender sender;

    public LogBackgroundService(LogCollector collector, LogSender sender) {
        Preconditions.checkNotNull(collector);
        Preconditions.checkNotNull(sender);
        this.collector = collector;
        this.sender = sender;
    }

    @Override
    protected void startUp() {
    }

    @Override
    protected long getNextScheduleDelayMilliseconds() {
        return this.scheduler.getScheduleDelay();
    }

    @Override
    protected void runOneIteration() {
        try {
            int numSent = this.collector.flush(this.sender);
            this.scheduler.update(numSent);
        }
        catch (Throwable t) {
            LOGGER.info("Exception running Stackify_LogBackgroundService", t);
            this.scheduler.update(t);
        }
    }

    @Override
    protected void shutDown() {
        try {
            this.collector.flush(this.sender);
        }
        catch (Throwable t) {
            LOGGER.info("Exception flushing log collector during shut down", t);
        }
    }
}

