/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.stackify.api.common.concurrent.BackgroundService;
import com.stackify.api.common.log.LogBackgroundServiceScheduler;
import com.stackify.api.common.log.LogCollector;
import com.stackify.api.common.log.LogTransport;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBackgroundService
extends BackgroundService {
    private static final Logger log = LoggerFactory.getLogger(LogBackgroundService.class);
    private final LogBackgroundServiceScheduler scheduler = new LogBackgroundServiceScheduler();
    private final LogCollector collector;
    private final LogTransport logTransport;

    public LogBackgroundService(@NonNull LogCollector collector, @NonNull LogTransport logTransport) {
        if (collector == null) {
            throw new NullPointerException("collector is marked non-null but is null");
        }
        if (logTransport == null) {
            throw new NullPointerException("logTransport is marked non-null but is null");
        }
        this.collector = collector;
        this.logTransport = logTransport;
    }

    @Override
    protected void startUp() {
    }

    @Override
    protected long getNextScheduleDelayMilliseconds() {
        return this.scheduler.getScheduleDelay();
    }

    @Override
    protected void runOneIteration() {
        try {
            int numSent = this.collector.flush(this.logTransport);
            this.scheduler.update(numSent);
        }
        catch (Throwable t) {
            log.info("Exception running Stackify_LogBackgroundService", t);
            this.scheduler.update(t);
        }
    }

    @Override
    protected void shutDown() {
        try {
            this.collector.flush(this.logTransport);
        }
        catch (Throwable t) {
            log.info("Exception flushing log collector during shut down", t);
        }
    }
}

