/**
 * Copyright 2012 StackMob
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.stackmob.sdk.callback;

import com.stackmob.sdk.exception.StackMobException;

/**
 * A callback that does absolutely nothing regardless of success or failure. Supply
 * this to StackMob calls when you don't care about the results
 * @see StackMobCallback
 */
public class StackMobNoopCallback extends StackMobCallback {

    @Override
    public void success(String responseBody) { }

    @Override
    public void failure(StackMobException e) { }
}
